/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.time;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.api.time.events.DateChangedEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.DayChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.MonthChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.PreDateChangedEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.WeekChangeEvent;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.event.Event;

public class TimeChecker {
    private AdvancedCorePlugin plugin;
    private boolean activeProcessing = false;
    private ScheduledExecutorService timer;
    private boolean timerLoaded = false;
    private boolean processingEnabled = true;

    public TimeChecker(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
    }

    public void forceChanged(final TimeType time) {
        this.timer.execute(new Runnable(){

            @Override
            public void run() {
                TimeChecker.this.forceChanged(time, true, true, true);
            }
        });
    }

    public synchronized void forceChanged(TimeType time, boolean fake, boolean preDate, boolean postDate) {
        this.activeProcessing = true;
        try {
            this.plugin.debug("Executing time change events: " + time.toString());
            this.plugin.getLogger().info("Time change event: " + time.toString() + ", Fake: " + fake);
            if (preDate) {
                PreDateChangedEvent preDateChanged = new PreDateChangedEvent(time);
                preDateChanged.setFake(fake);
                this.plugin.getServer().getPluginManager().callEvent((Event)preDateChanged);
            }
            if (time.equals((Object)TimeType.DAY)) {
                DayChangeEvent dayChange = new DayChangeEvent();
                dayChange.setFake(fake);
                this.plugin.getServer().getPluginManager().callEvent((Event)dayChange);
            } else if (time.equals((Object)TimeType.WEEK)) {
                WeekChangeEvent weekChange = new WeekChangeEvent();
                weekChange.setFake(fake);
                this.plugin.getServer().getPluginManager().callEvent((Event)weekChange);
            } else if (time.equals((Object)TimeType.MONTH)) {
                MonthChangeEvent monthChange = new MonthChangeEvent();
                monthChange.setFake(fake);
                this.plugin.getServer().getPluginManager().callEvent((Event)monthChange);
            }
            if (postDate) {
                DateChangedEvent dateChanged = new DateChangedEvent(time);
                dateChanged.setFake(fake);
                this.plugin.getServer().getPluginManager().callEvent((Event)dateChanged);
            }
            this.activeProcessing = false;
            this.plugin.debug("Finished executing time change events: " + time.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.activeProcessing = false;
    }

    public LocalDateTime getTime() {
        LocalDateTime localNow = LocalDateTime.now();
        if (!this.plugin.getOptions().getTimeZone().isEmpty()) {
            try {
                ZonedDateTime zonedTime = localNow.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of(this.plugin.getOptions().getTimeZone()));
                localNow = zonedTime.toLocalDateTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return localNow.plusHours(AdvancedCorePlugin.getInstance().getOptions().getTimeHourOffSet());
    }

    public boolean hasDayChanged(boolean set) {
        int day;
        int prevDay = this.plugin.getServerDataFile().getPrevDay();
        if (prevDay == (day = this.getTime().getDayOfMonth())) {
            return false;
        }
        if (set) {
            this.plugin.getServerDataFile().setPrevDay(day);
        }
        return true;
    }

    public boolean hasMonthChanged(boolean set) {
        String month;
        String prevMonth = this.plugin.getServerDataFile().getPrevMonth();
        if (prevMonth.equals(month = this.getTime().getMonth().toString())) {
            return false;
        }
        if (set) {
            this.plugin.getServerDataFile().setPrevMonth(month);
        }
        if (!this.plugin.getOptions().isTimeChangeFailSafeBypass() && this.getTime().getDayOfMonth() > 3) {
            this.plugin.getLogger().warning("Detected a month change, but current day is not near end of a month, ignoring month change, " + this.getTime().getDayOfMonth());
            this.plugin.getServerDataFile().setPrevMonth(month);
            return false;
        }
        return true;
    }

    public boolean hasTimeOffSet() {
        return AdvancedCorePlugin.getInstance().getOptions().getTimeHourOffSet() != 0;
    }

    public boolean hasWeekChanged(boolean set) {
        TemporalField woy;
        int prevDate = this.plugin.getServerDataFile().getPrevWeekDay();
        LocalDateTime date = this.getTime().plusDays(this.plugin.getOptions().getTimeWeekOffSet());
        int weekNumber = date.get(woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear());
        if (weekNumber == prevDate) {
            return false;
        }
        if (set) {
            this.plugin.getServerDataFile().setPrevWeekDay(weekNumber);
        }
        return true;
    }

    public void loadTimer() {
        if (!this.timerLoaded) {
            this.timerLoaded = true;
            this.timer = Executors.newScheduledThreadPool(1);
            if (this.plugin.getServerDataFile().getLastUpdated() > 0L && System.currentTimeMillis() - this.plugin.getServerDataFile().getLastUpdated() > 345600000L) {
                this.plugin.getServerDataFile().setIgnoreTime(true);
                this.plugin.getLogger().warning("Skipping time change events, since server has been offline for awhile, use /av forcetimechanged to force them if needed");
            }
            this.plugin.getServerDataFile().setLastUpdated();
            this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (TimeChecker.this.plugin != null && TimeChecker.this.plugin.isEnabled()) {
                        if (!TimeChecker.this.isActiveProcessing() && TimeChecker.this.isProcessingEnabled()) {
                            TimeChecker.this.update();
                        }
                    } else {
                        TimeChecker.this.timer.shutdown();
                        TimeChecker.this.timerLoaded = false;
                    }
                }
            }, 60L, 5L, TimeUnit.SECONDS);
            this.timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    TimeChecker.this.plugin.getServerDataFile().setLastUpdated();
                    if (!TimeChecker.this.isProcessingEnabled()) {
                        TimeChecker.this.plugin.debug("Processing time changes locally disabled");
                        if (TimeChecker.this.hasDayChanged(false)) {
                            TimeChecker.this.hasDayChanged(true);
                        }
                        if (TimeChecker.this.hasWeekChanged(false)) {
                            TimeChecker.this.hasWeekChanged(true);
                        }
                        if (TimeChecker.this.hasMonthChanged(false)) {
                            TimeChecker.this.hasMonthChanged(true);
                        }
                    }
                }
            }, 60L, 60L, TimeUnit.MINUTES);
        } else {
            AdvancedCorePlugin.getInstance().debug("Timer is already loaded");
        }
    }

    public void setProcessingEnabled(boolean value) {
        this.processingEnabled = value;
        this.plugin.debug("Local time change processing disabled");
    }

    public void update() {
        if (this.plugin == null) {
            return;
        }
        if (this.hasTimeOffSet()) {
            this.plugin.extraDebug("TimeHourOffSet: " + this.getTime().getHour() + ":" + this.getTime().getMinute());
        }
        if (this.plugin.getServerDataFile().isIgnoreTime()) {
            this.hasDayChanged(true);
            this.hasMonthChanged(true);
            this.hasWeekChanged(true);
            this.plugin.getServerDataFile().setIgnoreTime(false);
            this.plugin.getLogger().info("Ignoring time change events for one time only");
        }
        if (!this.isActiveProcessing()) {
            if (this.hasMonthChanged(false)) {
                this.plugin.getLogger().info("Detected month changed, processing...");
                if (this.isProcessingEnabled()) {
                    this.forceChanged(TimeType.MONTH, false, true, true);
                } else {
                    this.plugin.debug("Processing time changes locally disabled");
                }
                this.hasMonthChanged(true);
                this.plugin.getLogger().info("Finished processing month changes");
            } else if (this.hasWeekChanged(false)) {
                this.plugin.getLogger().info("Detected week changed, processing...");
                if (this.isProcessingEnabled()) {
                    this.forceChanged(TimeType.WEEK, false, true, true);
                } else {
                    this.plugin.debug("Processing time changes locally disabled");
                }
                this.hasWeekChanged(true);
                this.plugin.getLogger().info("Finished processing week changes");
            } else if (this.hasDayChanged(false)) {
                this.plugin.getLogger().info("Detected day changed, processing...");
                if (this.isProcessingEnabled()) {
                    this.forceChanged(TimeType.DAY, false, true, true);
                } else {
                    this.plugin.debug("Processing time changes locally disabled");
                }
                this.hasDayChanged(true);
                this.plugin.getLogger().info("Finished processing day changes");
            }
        }
    }

    @Generated
    public boolean isActiveProcessing() {
        return this.activeProcessing;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public void setTimer(ScheduledExecutorService timer) {
        this.timer = timer;
    }

    @Generated
    public boolean isProcessingEnabled() {
        return this.processingEnabled;
    }
}

