/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards.editbuttons;

import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUI;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUIButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueInventory;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardEditData;
import com.bencodez.votingplugin.advancedcore.api.rewards.editbuttons.RewardEdit;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.InputMethod;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequestBuilder;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.StringListener;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public abstract class RewardEditPotions
extends RewardEdit {
    @Override
    public void open(final Player player, RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Potions: " + reward.getName());
        inv.addData("Reward", reward);
        final ArrayList<String> potionEffects = new ArrayList<String>();
        for (PotionEffectType effect : PotionEffectType.values()) {
            potionEffects.add(effect.toString());
        }
        inv.addButton(new EditGUIButton(new EditGUIValueInventory("Potions"){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                new ValueRequestBuilder(new StringListener(){

                    @Override
                    public void onInput(Player player, String value) {
                        RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                        reward.createSection("Potions." + value);
                        RewardEditPotions.this.reloadAdvancedCore();
                        RewardEditPotions.this.open(player, reward);
                    }
                }, ArrayUtils.convert(potionEffects)).usingMethod(InputMethod.INVENTORY).request(clickEvent.getPlayer());
            }
        }).setName("&aAdd potion effect"));
        inv.addButton(new EditGUIButton(new EditGUIValueInventory("Potions"){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                if (reward.hasPath("Potions")) {
                    RewardEditPotions.this.openRemove(player, reward);
                }
            }
        }).setName("&aRemove potion"));
        inv.addButton(new EditGUIButton(new EditGUIValueInventory("Potions"){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                if (reward.hasPath("Potions")) {
                    RewardEditPotions.this.openEditSub(player, reward);
                }
            }
        }).setName("&aEdit potion effect"));
        inv.addButton(this.getBackButton(reward));
        inv.openInventory(player);
    }

    public void openEditSub(final Player player, RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Potions Edit Sub: " + reward.getName());
        inv.addData("Reward", reward);
        for (final String key : reward.getData().getConfigurationSection("Potions").getKeys(false)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(Material.PAPER).setName("&a" + key).addLoreLine("&aClick to edit")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                    RewardEditPotions.this.openEditSub(player, reward, key);
                }
            });
        }
        inv.addButton(this.getBackButtonCustom(reward, new EditGUIValueInventory(""){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditPotions.this.open(player, reward);
            }
        }));
        inv.openInventory(player);
    }

    public void openEditSub(final Player player, RewardEditData reward, String potion) {
        EditGUI inv = new EditGUI("Edit Potions Edit " + potion + ": " + reward.getName());
        inv.addData("Reward", reward);
        inv.addButton(this.getIntButton("Potions." + potion + ".Duration", reward));
        inv.addButton(this.getIntButton("Potions." + potion + ".Amplifier", reward));
        inv.addButton(this.getBackButtonCustom(reward, new EditGUIValueInventory(""){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditPotions.this.open(player, reward);
            }
        }));
        inv.openInventory(player);
    }

    public void openRemove(final Player player, RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Potions Remove: " + reward.getName());
        inv.addData("Reward", reward);
        for (final String key : reward.getData().getConfigurationSection("Potions").getKeys(false)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(Material.PAPER).setName("&c" + key).addLoreLine("&cClick to remove")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                    reward.setValue("Potions." + key, null);
                    RewardEditPotions.this.reloadAdvancedCore();
                    RewardEditPotions.this.open(player, reward);
                }
            });
        }
        inv.addButton(this.getBackButtonCustom(reward, new EditGUIValueInventory(""){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditPotions.this.open(player, reward);
            }
        }));
        inv.openInventory(player);
    }
}

