/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards.editbuttons;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.UpdatingBInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUI;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUIButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueList;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueNumber;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueString;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardEditData;
import com.bencodez.votingplugin.advancedcore.api.rewards.editbuttons.RewardEdit;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;

public abstract class RewardEditItems
extends RewardEdit {
    private AdvancedCorePlugin plugin;

    public RewardEditItems(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void open(final Player player, RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Items: " + reward.getName());
        inv.addData("Reward", reward);
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.PAPER).setName("&cView current items").addLoreLine("&aDisplaying all current items on next slot").addLoreLine("&aThis doesn't support adding conditional items")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        UpdatingBInventoryButton b = new UpdatingBInventoryButton(this.plugin, new ItemBuilder(Material.PAPER).setName("&cView current items").addLoreLine("&aDisplaying all current items").addLoreLine("This doesn't support adding conditional items"), 750L, 750L){

            public ItemBuilder nextItem() {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                if (reward.hasPath("Items")) {
                    try {
                        int num = (Integer)this.getData("CurrentItem");
                        ArrayList set = (ArrayList)this.getData("ItemsKeys");
                        if (++num >= set.size()) {
                            num = 0;
                        }
                        this.addData("CurrentItem", num);
                        return new ItemBuilder(reward.getData().getConfigurationSection("Items." + (String)set.get(num))).addLoreLine("&cDisplaying: " + (String)set.get(num));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new ItemBuilder(Material.STONE).setName("Error");
                    }
                }
                return new ItemBuilder(Material.PAPER).setName("&cNo Items");
            }

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditItems.this.open(player, reward);
            }

            @Override
            public ItemBuilder onUpdate(Player player2) {
                return this.nextItem();
            }
        };
        if (reward.hasPath("Items")) {
            b.addData("ItemsKeys", ArrayUtils.convert(reward.getData().getConfigurationSection("Items").getKeys(false)));
        } else {
            b.addData("ItemsKeys", new ArrayList());
        }
        b.addData("CurrentItem", 0);
        inv.addButton(b);
        inv.addButton(new EditGUIButton(new EditGUIValueInventory("Items"){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                if (reward.hasPath("Items")) {
                    RewardEditItems.this.openRemove(player, reward);
                }
            }
        }).setName("&aRemove item"));
        inv.addButton(new EditGUIButton(new EditGUIValueInventory("Items"){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                if (reward.hasPath("Items")) {
                    RewardEditItems.this.openEdit(player, reward);
                }
            }
        }).setName("&aEdit existing item"));
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.PAPER).setName("&aAdd item in hand").addLoreLine("Click for more")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditItems.this.openAdd(clickEvent.getPlayer(), reward);
            }
        });
        inv.addButton(this.getBackButton(reward));
        inv.openInventory(player);
    }

    public void openAdd(final Player player, final RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Item Add: " + reward.getName());
        inv.addData("Reward", reward);
        inv.addButton(new BInventoryButton(new ItemBuilder(player.getInventory().getItemInMainHand().clone()).addLoreLine("&cClick to add")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                ItemBuilder item = new ItemBuilder(clickEvent.getPlayer().getInventory().getItemInMainHand().clone());
                Map<String, Object> map = item.getConfiguration(false);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    reward.setValue("Items." + item.getType().toString() + "." + entry.getKey(), entry.getValue());
                }
                RewardEditItems.this.open(player, reward);
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(player.getInventory().getItemInMainHand().clone()).addLoreLine("&cClick to add with exact data")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                ItemBuilder item = new ItemBuilder(clickEvent.getPlayer().getInventory().getItemInMainHand().clone());
                Map<String, Object> map = item.getConfiguration(true);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    reward.setValue("Items." + item.getType().toString() + ".ItemStack." + entry.getKey(), entry.getValue());
                }
                RewardEditItems.this.open(player, reward);
            }
        });
        inv.addButton(this.getBackButtonCustom(reward, new EditGUIValueInventory(""){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditItems.this.open(player, reward);
            }
        }));
        inv.openInventory(player);
    }

    public void openEdit(final Player player, final RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Item Edit: " + reward.getName());
        inv.addData("Reward", reward);
        for (String key : reward.getData().getConfigurationSection("Items").getKeys(false)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(reward.getData().getConfigurationSection("Items." + key)).setName("&c" + key).addLoreLine("&cClick to edit")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    String key = (String)this.getData("key");
                    RewardEditItems.this.openEditItem(player, key, reward);
                }
            }.addData("key", key));
        }
        inv.addButton(this.getBackButtonCustom(reward, new EditGUIValueInventory(""){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditItems.this.open(player, reward);
            }
        }));
        inv.openInventory(player);
    }

    public void openEditItem(final Player player, String item, RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Item " + item + ": " + reward.getName());
        inv.addData("Reward", reward);
        inv.addData("Item", item);
        inv.addButton(new BInventoryButton(new ItemBuilder(reward.getData().getConfigurationSection("Items." + item))){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                String item = (String)this.getInv().getData("Item");
                RewardEditItems.this.openEditItem(player, item, reward);
            }
        });
        inv.addButton(new EditGUIButton(new EditGUIValueString("Items." + item + ".Name", reward.getValue("Items." + item + ".Name")){

            @Override
            public void setValue(Player player, String value) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                reward.setValue(this.getKey(), value);
                RewardEditItems.this.reloadAdvancedCore();
                String item = (String)this.getInv().getData("Item");
                RewardEditItems.this.openEditItem(player, item, reward);
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueList("Items." + item + ".Lore", reward.getValue("Items." + item + ".Lore")){

            @Override
            public void setValue(Player player, ArrayList<String> value) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                reward.setValue(this.getKey(), value);
                RewardEditItems.this.reloadAdvancedCore();
                String item = (String)this.getInv().getData("Item");
                RewardEditItems.this.openEditItem(player, item, reward);
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueNumber("Items." + item + ".Amount", reward.getValue("Items." + item + ".Amount")){

            @Override
            public void setValue(Player player, Number value) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                reward.setValue(this.getKey(), value.intValue());
                RewardEditItems.this.reloadAdvancedCore();
                String item = (String)this.getInv().getData("Item");
                RewardEditItems.this.openEditItem(player, item, reward);
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueNumber("Items." + item + ".CustomModelData", reward.getValue("Items." + item + ".CustomModelData")){

            @Override
            public void setValue(Player player, Number value) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                reward.setValue(this.getKey(), value.intValue());
                RewardEditItems.this.reloadAdvancedCore();
                String item = (String)this.getInv().getData("Item");
                RewardEditItems.this.openEditItem(player, item, reward);
            }
        }));
        ArrayList<String> flagList = new ArrayList<String>();
        for (ItemFlag flag : ItemFlag.values()) {
            flagList.add(flag.toString());
        }
        inv.addButton(new EditGUIButton(new EditGUIValueList("Items." + item + ".ItemFlags", reward.getValue("Items." + item + ".ItemFlags")){

            @Override
            public void setValue(Player player, ArrayList<String> value) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                reward.setValue(this.getKey(), value);
                RewardEditItems.this.reloadAdvancedCore();
                String item = (String)this.getInv().getData("Item");
                RewardEditItems.this.openEditItem(player, item, reward);
            }
        }).addOptions(ArrayUtils.convert(flagList)));
        inv.addButton(this.getBackButtonCustom(reward, new EditGUIValueInventory(""){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditItems.this.open(player, reward);
            }
        }));
        inv.openInventory(player);
    }

    public void openRemove(final Player player, RewardEditData reward) {
        EditGUI inv = new EditGUI("Edit Item Remove: " + reward.getName());
        inv.addData("Reward", reward);
        for (final String key : reward.getData().getConfigurationSection("Items").getKeys(false)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(reward.getData().getConfigurationSection("Items." + key)).setName("&c" + key).addLoreLine("&cClick to remove")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                    reward.setValue("Items." + key, null);
                    RewardEditItems.this.reloadAdvancedCore();
                    RewardEditItems.this.open(player, reward);
                }
            });
        }
        inv.addButton(this.getBackButtonCustom(reward, new EditGUIValueInventory(""){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                RewardEditItems.this.open(player, reward);
            }
        }));
        inv.openInventory(player);
    }
}

