/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class RewardOptions {
    private boolean checkRepeat = true;
    private boolean checkTimed = true;
    private boolean forceOffline = false;
    private boolean giveOffline = true;
    private boolean ignoreChance = false;
    private boolean ignoreRequirements = false;
    private boolean online = true;
    private boolean onlineSet = false;
    private HashMap<String, String> placeholders = new HashMap();
    private String prefix = "";
    private String server = "";
    private String suffix = "";
    private boolean useDefaultWorlds = true;
    private long orginalTrigger = -1L;

    public RewardOptions addPlaceholder(String arg1, String arg2) {
        this.getPlaceholders().put(arg1, arg2);
        return this;
    }

    public RewardOptions disableDefaultWorlds() {
        this.useDefaultWorlds = false;
        return this;
    }

    public RewardOptions forceOffline() {
        this.forceOffline = true;
        return this;
    }

    public HashMap<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isCheckTimed() {
        return this.checkTimed;
    }

    public boolean isGiveOffline() {
        return this.giveOffline;
    }

    public boolean isIgnoreChance() {
        return this.ignoreChance;
    }

    public boolean isOnline() {
        return this.online;
    }

    public RewardOptions orginalTrigger(long trigger) {
        this.orginalTrigger = trigger;
        return this;
    }

    public RewardOptions setCheckRepeat(boolean checkRepeat) {
        this.checkRepeat = checkRepeat;
        return this;
    }

    public RewardOptions setCheckTimed(boolean checkTimed) {
        this.checkTimed = checkTimed;
        return this;
    }

    public RewardOptions setGiveOffline(boolean giveOffline) {
        this.giveOffline = giveOffline;
        return this;
    }

    public RewardOptions setIgnoreChance(boolean ignoreChance) {
        this.ignoreChance = ignoreChance;
        return this;
    }

    public RewardOptions setIgnoreRequirements(boolean ignoreRequirements) {
        this.ignoreRequirements = ignoreRequirements;
        return this;
    }

    public RewardOptions setOnline(boolean online) {
        this.online = online;
        this.onlineSet = true;
        return this;
    }

    public RewardOptions setPlaceholders(HashMap<String, String> placeholders) {
        this.placeholders = placeholders;
        return this;
    }

    public RewardOptions setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RewardOptions setServer(boolean b) {
        if (b) {
            this.server = AdvancedCorePlugin.getInstance().getOptions().getServer();
            this.addPlaceholder("Server", this.server);
        }
        return this;
    }

    public RewardOptions setServer(String server) {
        this.server = server;
        this.addPlaceholder("Server", this.server);
        return this;
    }

    public RewardOptions setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public String toString() {
        String str = "Online: " + this.online + ", ";
        str = str + "OnlineSet: " + this.onlineSet + ", ";
        str = str + "GiveOffline: " + this.giveOffline + ", ";
        str = str + "ForceOffline: " + this.forceOffline + ", ";
        str = str + "CheckTimed: " + this.checkTimed + ", ";
        str = str + "IgnoreChance: " + this.ignoreChance + ", ";
        str = str + "IgnoreRequirements: " + this.ignoreRequirements + ", ";
        str = str + "Placeholders: " + ArrayUtils.makeString(this.placeholders) + ", ";
        str = str + "Prefix: " + this.prefix + ", ";
        str = str + "Suffix: " + this.suffix;
        return str;
    }

    public RewardOptions withPlaceHolder(HashMap<String, String> placeholders2) {
        for (Map.Entry<String, String> entry : placeholders2.entrySet()) {
            this.placeholders.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Generated
    public boolean isCheckRepeat() {
        return this.checkRepeat;
    }

    @Generated
    public boolean isForceOffline() {
        return this.forceOffline;
    }

    @Generated
    public boolean isIgnoreRequirements() {
        return this.ignoreRequirements;
    }

    @Generated
    public boolean isOnlineSet() {
        return this.onlineSet;
    }

    @Generated
    public void setOnlineSet(boolean onlineSet) {
        this.onlineSet = onlineSet;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public boolean isUseDefaultWorlds() {
        return this.useDefaultWorlds;
    }

    @Generated
    public long getOrginalTrigger() {
        return this.orginalTrigger;
    }
}

