/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards;

import com.bencodez.votingplugin.advancedcore.api.rewards.DefinedReward;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class RewardFileDefinedReward
implements DefinedReward {
    private String path;
    private Reward master;

    public RewardFileDefinedReward(Reward master) {
        this.master = master;
        this.path = "";
    }

    public RewardFileDefinedReward(Reward master, String path) {
        this.master = master;
        this.path = path;
    }

    @Override
    public void createSection(String key) {
        this.master.getConfig().createSection(key);
    }

    public void createSectionLocal(String key) {
        if (this.getPath().isEmpty()) {
            this.createSection(key);
        } else {
            this.createSection(this.getPath() + "." + key);
        }
    }

    @Override
    public ConfigurationSection getFileData() {
        return this.master.getConfig().getConfigData();
    }

    @Override
    public String getFullPath() {
        return this.master.getName() + "." + this.path;
    }

    public Reward getReward() {
        if (this.getPath().isEmpty()) {
            return this.master;
        }
        if (this.isDirectlyDefined()) {
            return new Reward(this.getPath().replace(".", "_"), this.getFileData().getConfigurationSection(this.getPath())).needsRewardFile(false);
        }
        return null;
    }

    public Object getValue(String path) {
        if (this.getPath().isEmpty()) {
            return this.getFileData().get(path);
        }
        return this.getFileData().get(this.getPath() + "." + path);
    }

    public boolean isDirectlyDefined() {
        if (this.path.isEmpty()) {
            return true;
        }
        return this.getFileData().isConfigurationSection(this.getPath());
    }

    @Override
    public String needsDot() {
        if (this.getPath().isEmpty()) {
            return "";
        }
        return ".";
    }

    @Override
    public void save() {
        this.master.getConfig().save();
    }

    @Override
    public void setData(String path, Object value) {
        this.master.getConfig().set(path, value);
    }

    public void setParentValue(Object value) {
        this.setData(this.getPath(), value);
    }

    public void setValue(String path, Object value) {
        if (this.getPath().isEmpty()) {
            this.setData(path, value);
        } else {
            this.setData(this.getPath() + "." + path, value);
        }
    }

    @Override
    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public Reward getMaster() {
        return this.master;
    }

    @Generated
    public void setMaster(Reward master) {
        this.master = master;
    }
}

