/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.misc.files.FilesManager;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RewardFileData {
    private ConfigurationSection configData;
    private File dataFile;
    private FileConfiguration fileData;
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();
    private Reward reward;
    private File rewardFolder;

    public RewardFileData(Reward reward, ConfigurationSection section) {
        this.reward = reward;
        this.configData = section;
    }

    public RewardFileData(Reward reward, File rewardFolder) {
        this.reward = reward;
        this.dataFile = reward.getFile();
        if (!rewardFolder.isDirectory()) {
            rewardFolder = rewardFolder.getParentFile();
        }
        this.rewardFolder = rewardFolder;
        this.setup();
    }

    public void createSection(String path) {
        if (this.fileData != null) {
            this.fileData.createSection(path);
            this.save(this.fileData);
            this.reload();
        }
    }

    public double getChance() {
        return this.getConfigData().getDouble("Chance");
    }

    public Set<String> getChoices() {
        if (this.getConfigData().isConfigurationSection("Choices")) {
            return this.getConfigData().getConfigurationSection("Choices").getKeys(false);
        }
        return new HashSet<String>();
    }

    public ConfigurationSection getChoicesItem(String choice) {
        return this.getConfigData().getConfigurationSection("Choices." + choice + ".DisplayItem");
    }

    public String getChoicesRewardsPath(String choice) {
        return "Choices." + choice + ".Rewards";
    }

    public ArrayList<String> getCommandsConsole() {
        if (this.getConfigData().isList("Commands")) {
            return (ArrayList)this.getConfigData().getList("Commands", new ArrayList());
        }
        return (ArrayList)this.getConfigData().getList("Commands.Console", new ArrayList());
    }

    public ArrayList<String> getCommandsPlayer() {
        return (ArrayList)this.getConfigData().getList("Commands.Player", new ArrayList());
    }

    public ConfigurationSection getConfigData() {
        return this.configData;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public boolean getDelayedEnabled() {
        return this.getConfigData().getBoolean("Delayed.Enabled");
    }

    public int getDelayedHours() {
        return this.getConfigData().getInt("Delayed.Hours");
    }

    public int getDelayedMilliSeconds() {
        return this.getConfigData().getInt("Delayed.MilliSeconds");
    }

    public int getDelayedMinutes() {
        return this.getConfigData().getInt("Delayed.Minutes");
    }

    public int getDelayedSeconds() {
        return this.getConfigData().getInt("Delayed.Seconds");
    }

    public ConfigurationSection getDisplayItem() {
        return this.getConfigData().getConfigurationSection("DisplayItem");
    }

    public boolean getEnableChoices() {
        return this.getConfigData().getBoolean("EnableChoices");
    }

    public FileConfiguration getFileData() {
        return this.fileData;
    }

    public boolean getForceOffline() {
        return this.getConfigData().getBoolean("ForceOffline");
    }

    @Deprecated
    public int getItemAmount(String item) {
        return this.getConfigData().getInt("Items." + item + ".Amount");
    }

    @Deprecated
    public int getItemData(String item) {
        return this.getConfigData().getInt("Items." + item + ".Data");
    }

    @Deprecated
    public int getItemDurability(String item) {
        return this.getConfigData().getInt("Items." + item + ".Durability");
    }

    @Deprecated
    public Set<String> getItemEnchants(String item) {
        try {
            return this.getConfigData().getConfigurationSection("Items." + item + ".Enchants").getKeys(false);
        }
        catch (Exception ex) {
            return new HashSet<String>();
        }
    }

    @Deprecated
    public int getItemEnchantsLevel(String item, String enchant) {
        return this.getConfigData().getInt("Items." + item + ".Enchants." + enchant);
    }

    @Deprecated
    public ArrayList<String> getItemLore(String item) {
        return (ArrayList)this.getConfigData().getList("Items." + item + ".Lore");
    }

    @Deprecated
    public String getItemMaterial(String item) {
        return this.getConfigData().getString("Items." + item + ".Material");
    }

    @Deprecated
    public int getItemMaxAmount(String item) {
        return this.getConfigData().getInt("Items." + item + ".MaxAmount");
    }

    @Deprecated
    public int getItemMinAmount(String item) {
        return this.getConfigData().getInt("Items." + item + ".MinAmount");
    }

    @Deprecated
    public String getItemName(String item) {
        return this.getConfigData().getString("Items." + item + ".Name");
    }

    public Set<String> getItems() {
        try {
            return this.getConfigData().getConfigurationSection("Items").getKeys(false);
        }
        catch (Exception ex) {
            return new HashSet<String>();
        }
    }

    public ConfigurationSection getItemSection(String item) {
        return this.getConfigData().getConfigurationSection("Items." + item);
    }

    @Deprecated
    public String getItemSkull(String item) {
        return this.getConfigData().getString("Items." + item + ".Skull");
    }

    public String getPermission() {
        return this.getConfigData().getString("Permission", "AdvancedCore.Reward." + this.reward.getRewardName());
    }

    public ArrayList<String> getPriority() {
        return (ArrayList)this.getConfigData().getList("Priority", new ArrayList());
    }

    public boolean getRequirePermission() {
        return this.getConfigData().getBoolean("RequirePermission");
    }

    public String getRewardType() {
        String str = this.getConfigData().getString("RewardType", "BOTH");
        if (str != null) {
            if (str.equalsIgnoreCase("online")) {
                return "ONLINE";
            }
            if (str.equalsIgnoreCase("offline")) {
                return "OFFLINE";
            }
            return "BOTH";
        }
        return "BOTH";
    }

    public String getServer() {
        return this.getConfigData().getString("Server", "");
    }

    public boolean getTimedEnabled() {
        return this.getConfigData().getBoolean("Timed.Enabled");
    }

    public int getTimedHour() {
        return this.getConfigData().getInt("Timed.Hour");
    }

    public int getTimedMinute() {
        return this.getConfigData().getInt("Timed.Minute");
    }

    public ArrayList<String> getWorlds() {
        return (ArrayList)this.getConfigData().getList("Worlds", new ArrayList());
    }

    public boolean hasRewardFile() {
        return this.dataFile != null;
    }

    public boolean isDirectlyDefinedReward() {
        return this.getConfigData().getBoolean("DirectlyDefinedReward");
    }

    public boolean isRewardFile() {
        return this.dataFile != null && !this.isDirectlyDefinedReward();
    }

    public void reload() {
        this.fileData = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.configData = this.fileData.getConfigurationSection("");
    }

    public void save() {
        FilesManager.getInstance().editFile(this.dataFile, this.fileData);
    }

    public void save(FileConfiguration fileData) {
        FilesManager.getInstance().editFile(this.dataFile, fileData);
    }

    public void set(String path, Object value) {
        if (this.fileData != null) {
            this.fileData.set(path, value);
            this.save(this.fileData);
            this.reload();
        } else {
            this.plugin.debug("Editing invalid reward: " + this.reward.getName());
        }
    }

    public void setChance(double d) {
        this.set("Chance", d);
    }

    public void setCommandsConsole(ArrayList<String> value) {
        this.set("Commands.Console", value);
    }

    public void setCommandsPlayer(ArrayList<String> value) {
        this.set("Commands.Player", value);
    }

    public void setConfigData(ConfigurationSection configData) {
        this.configData = configData;
    }

    public void setData(ConfigurationSection value) {
        Map map = value.getConfigurationSection("").getValues(true);
        for (Map.Entry entry : map.entrySet()) {
            this.set((String)entry.getKey(), entry.getValue());
        }
        this.reward.loadValues();
    }

    public void setDataFile(File dFile) {
        this.dataFile = dFile;
    }

    public void setDirectlyDefinedReward(boolean b) {
        this.set("DirectlyDefinedReward", b);
    }

    public void setGiveInEachWorld(boolean value) {
        this.set("GiveInEachWorld", value);
    }

    public void setItemAmount(String item, int value) {
        this.set("Items." + item + ".Amount", value);
    }

    public void setItemData(String item, int value) {
        this.set("Items." + item + ".Data", value);
    }

    public void setItemDurability(String item, int value) {
        this.set("Items." + item + ".Durability", value);
    }

    public void setItemEnchant(String item, String enchant, int value) {
        this.set("Items." + item + ".Enchants." + enchant, value);
    }

    public void setItemLore(String item, ArrayList<String> value) {
        this.set("Items." + item + ".Lore", value);
    }

    public void setItemMaterial(String item, String value) {
        this.set("Items." + item + ".Material", value);
    }

    public void setItemMaxAmount(String item, int value) {
        this.set("Items." + item + ".MaxAmount", value);
    }

    public void setItemMinAmount(String item, int value) {
        this.set("Items." + item + ".MinAmount", value);
    }

    public void setItemName(String item, String value) {
        this.set("Items." + item + ".Name", value);
    }

    public void setPermission(String perm) {
        this.set("Permission", perm);
    }

    public void setRequirePermission(boolean value) {
        this.set("RequirePermission", value);
    }

    public void setRewardType(String value) {
        this.set("RewardType", value);
    }

    public void setup() {
        this.fileData = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (!this.dataFile.exists()) {
            try {
                this.fileData.save(this.dataFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe(ChatColor.RED + "Could not create " + this.dataFile.getAbsolutePath());
            }
        }
        this.configData = this.fileData.getConfigurationSection("");
    }

    public void setWorlds(ArrayList<String> value) {
        this.set("Worlds", value);
    }

    @Generated
    public File getRewardFolder() {
        return this.rewardFolder;
    }
}

