/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards;

import com.bencodez.votingplugin.advancedcore.api.rewards.DirectlyDefinedReward;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.command.gui.RewardEditGUI;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class RewardEditData {
    private DirectlyDefinedReward directlyDefinedReward;
    private RewardEditData parent;
    private Reward reward;

    public RewardEditData(DirectlyDefinedReward directlyDefinedReward) {
        this.directlyDefinedReward = directlyDefinedReward;
    }

    public RewardEditData(DirectlyDefinedReward directlyDefinedReward, RewardEditData parent) {
        this.directlyDefinedReward = directlyDefinedReward;
        this.parent = parent;
    }

    public RewardEditData(Reward reward) {
        this.reward = reward;
    }

    public void createSection(String path) {
        if (this.reward != null) {
            this.reward.getConfig().createSection(path);
        } else if (this.directlyDefinedReward != null) {
            this.directlyDefinedReward.createSectionLocal(path);
        }
    }

    public ConfigurationSection getData() {
        if (this.reward != null) {
            return this.reward.getConfig().getConfigData();
        }
        if (this.directlyDefinedReward != null) {
            return this.directlyDefinedReward.getFileData().getConfigurationSection(this.directlyDefinedReward.getPath());
        }
        return null;
    }

    public String getName() {
        if (this.reward != null) {
            return this.reward.getName();
        }
        return this.directlyDefinedReward.getPath();
    }

    public Object getValue(String key) {
        if (this.reward != null) {
            return this.reward.getConfig().getConfigData().get(key);
        }
        if (this.directlyDefinedReward != null) {
            return this.directlyDefinedReward.getValue(key);
        }
        return null;
    }

    public boolean hasPath(String path) {
        if (this.reward != null) {
            return this.reward.getConfig().getConfigData().contains(path, false);
        }
        return this.directlyDefinedReward.getFileData().contains(this.directlyDefinedReward.getPath() + "." + path, false);
    }

    public void reOpenEditGUI(Player player) {
        RewardEditGUI.getInstance().openRewardGUI(player, this, this.getName());
    }

    public void save() {
        if (this.reward != null) {
            this.reward.getConfig().save(this.reward.getConfig().getFileData());
        } else if (this.directlyDefinedReward != null) {
            this.directlyDefinedReward.save();
        }
    }

    public void setValue(String path, Object value) {
        if (this.reward != null) {
            this.reward.getConfig().set(path, value);
        } else if (this.directlyDefinedReward != null) {
            this.directlyDefinedReward.setValue(path, value);
        }
    }

    @Generated
    public RewardEditData getParent() {
        return this.parent;
    }
}

