/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class RewardBuilder {
    private ConfigurationSection data;
    private String path;
    private Reward reward;
    private RewardOptions rewardOptions;

    public RewardBuilder(ConfigurationSection data, String path) {
        this.data = data;
        this.path = path;
        this.rewardOptions = new RewardOptions();
        LocalDateTime ldt = LocalDateTime.now();
        Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        this.rewardOptions.getPlaceholders().put("Date", "" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(date));
    }

    public RewardBuilder(ConfigurationSection data, String path, RewardOptions rewardOptions) {
        this.data = data;
        this.path = path;
        this.rewardOptions = rewardOptions;
        if (rewardOptions == null) {
            this.rewardOptions = new RewardOptions();
        }
        LocalDateTime ldt = LocalDateTime.now();
        Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        this.rewardOptions.getPlaceholders().put("Date", "" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(date));
    }

    public RewardBuilder(Reward reward) {
        this.reward = reward;
        this.rewardOptions = new RewardOptions();
        LocalDateTime ldt = LocalDateTime.now();
        Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        this.rewardOptions.getPlaceholders().put("Date", "" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(date));
    }

    public RewardBuilder(Reward reward, RewardOptions rewardOptions) {
        this.reward = reward;
        this.rewardOptions = rewardOptions;
        if (rewardOptions == null) {
            this.rewardOptions = new RewardOptions();
        }
        LocalDateTime ldt = LocalDateTime.now();
        Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        this.rewardOptions.getPlaceholders().put("Date", "" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(date));
    }

    public RewardBuilder disableDefaultWorlds() {
        this.rewardOptions.disableDefaultWorlds();
        return this;
    }

    public RewardOptions getRewardOptions() {
        return this.rewardOptions;
    }

    public RewardBuilder orginalTrigger(long trigger) {
        this.rewardOptions.orginalTrigger(trigger);
        return this;
    }

    public void send(AdvancedCoreUser user) {
        if (this.reward == null) {
            if (this.data != null) {
                user.getPlugin().getRewardHandler().giveReward(user, this.data, this.path, this.rewardOptions);
            }
        } else {
            user.getPlugin().getRewardHandler().giveReward(user, this.reward, this.rewardOptions);
        }
    }

    public void send(AdvancedCoreUser ... users) {
        for (AdvancedCoreUser user : users) {
            this.send(user);
        }
    }

    public void send(ArrayList<AdvancedCoreUser> users) {
        for (AdvancedCoreUser user : users) {
            this.send(user);
        }
    }

    public void send(OfflinePlayer p) {
        this.send(AdvancedCorePlugin.getInstance().getUserManager().getUser(p));
    }

    public void send(Player p) {
        this.send(AdvancedCorePlugin.getInstance().getUserManager().getUser(p));
    }

    public RewardBuilder setCheckTimed(boolean checkTimed) {
        this.getRewardOptions().setCheckTimed(checkTimed);
        return this;
    }

    public RewardBuilder setGiveOffline(boolean giveOffline) {
        this.getRewardOptions().setGiveOffline(giveOffline);
        return this;
    }

    public RewardBuilder setIgnoreChance(boolean ignoreChance) {
        this.getRewardOptions().setIgnoreChance(ignoreChance);
        return this;
    }

    public RewardBuilder setIgnoreRequirements(boolean ignoreRequirements) {
        this.getRewardOptions().setIgnoreRequirements(ignoreRequirements);
        return this;
    }

    public RewardBuilder setOnline(boolean online) {
        this.getRewardOptions().setOnline(online);
        return this;
    }

    public void setReward(Reward reward) {
        this.reward = reward;
    }

    public RewardBuilder setRewardOptions(RewardOptions rewardOptions) {
        this.rewardOptions = rewardOptions;
        return this;
    }

    public RewardBuilder setServer(boolean b) {
        if (b) {
            this.getRewardOptions().setServer(b);
        }
        return this;
    }

    public RewardBuilder withPlaceHolder(HashMap<String, String> placeholders) {
        this.rewardOptions.getPlaceholders().putAll(placeholders);
        return this;
    }

    public RewardBuilder withPlaceHolder(String toReplace, String replaceWith) {
        this.rewardOptions.getPlaceholders().put(toReplace, replaceWith);
        return this;
    }

    public RewardBuilder withPrefix(String prefix) {
        this.rewardOptions.setPrefix(prefix);
        return this;
    }

    public RewardBuilder withSuffix(String suffix) {
        this.rewardOptions.setSuffix(suffix);
        return this;
    }
}

