/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RepeatHandle;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardFileData;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardPlaceholderHandle;
import com.bencodez.votingplugin.advancedcore.api.rewards.injected.RewardInject;
import com.bencodez.votingplugin.advancedcore.api.rewards.injectedrequirement.RequirementInject;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.listeners.PlayerRewardEvent;
import com.bencodez.votingplugin.simpleapi.file.annotation.AnnotationHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class Reward {
    private RewardFileData config;
    private boolean delayEnabled;
    private int delayHours;
    private int delayMinutes;
    private int delaySeconds;
    private int delayMilliSeconds;
    private File file;
    private boolean forceOffline;
    private String name;
    private boolean needsRewardFile = true;
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();
    private RepeatHandle repeatHandle;
    private boolean timedEnabled;
    private int timedHour;
    private int timedMinute;

    public Reward(File file, String reward) {
        this.load(file, reward);
    }

    public Reward(String reward) {
        this.load(this.plugin.getRewardHandler().getDefaultFolder(), reward);
    }

    public Reward(String name, ConfigurationSection section) {
        this.load(name, section);
    }

    public boolean canGiveReward(AdvancedCoreUser user, RewardOptions options) {
        for (RequirementInject inject : this.plugin.getRewardHandler().getInjectedRequirements()) {
            try {
                this.plugin.extraDebug(this.getRewardName() + ": Checking " + inject.getPath() + ":" + inject.getPriority());
                if (inject.onRequirementRequest(this, user, this.getConfig().getConfigData(), options)) continue;
                return false;
            }
            catch (Exception e) {
                this.plugin.debug("Failed to check requirement");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean checkDelayed(AdvancedCoreUser user, HashMap<String, String> placeholders) {
        if (!this.isDelayEnabled()) {
            return false;
        }
        LocalDateTime time = LocalDateTime.now();
        time = time.plus(this.getDelayHours(), ChronoUnit.HOURS);
        time = time.plus(this.getDelayMinutes(), ChronoUnit.MINUTES);
        time = time.plus(this.getDelaySeconds(), ChronoUnit.SECONDS);
        time = time.plus(this.getDelayMilliSeconds(), ChronoUnit.MILLIS);
        this.checkRewardFile();
        user.addTimedReward(this, placeholders, time.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        this.plugin.debug("Giving reward " + this.name + " in " + this.getDelayHours() + " hours, " + this.getDelayMinutes() + " minutes, " + this.getDelaySeconds() + " seconds (" + time.toString() + ")");
        return true;
    }

    public void checkRewardFile() {
        if (!this.getConfig().hasRewardFile() && this.needsRewardFile) {
            this.setRewardFile();
        }
    }

    public boolean checkTimed(AdvancedCoreUser user, HashMap<String, String> placeholders) {
        if (!this.isTimedEnabled()) {
            return false;
        }
        LocalDateTime time = LocalDateTime.now();
        time = time.withHour(this.getTimedHour());
        time = time.withMinute(this.getTimedMinute());
        if (LocalDateTime.now().isAfter(time)) {
            time = time.plusDays(1L);
        }
        this.checkRewardFile();
        user.addTimedReward(this, placeholders, time.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        this.plugin.debug("Giving reward " + this.name + " at " + time.toString());
        return true;
    }

    public ItemStack getItem() {
        return new ItemStack(Material.STONE);
    }

    public ItemStack getItemStack(AdvancedCoreUser user, String item) {
        return new ItemBuilder(this.getConfig().getItemSection(item)).setSkullOwner(user.getOfflinePlayer()).toItemStack(user.getPlayer());
    }

    public String getRewardName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveInjectedRewards(AdvancedCoreUser user, HashMap<String, String> placeholders) {
        ArrayList<RewardInject> postReward = new ArrayList<RewardInject>();
        for (RewardInject inject : this.plugin.getRewardHandler().getInjectedRewards()) {
            boolean Addplaceholder = inject.isAddAsPlaceholder();
            try {
                Object obj = null;
                this.plugin.extraDebug(this.getRewardName() + ": Attempting to give " + inject.getPath() + ":" + inject.getPriority());
                if (!inject.isPostReward()) {
                    Object b;
                    if (inject.isSynchronize()) {
                        Object object = inject.getObject();
                        synchronized (object) {
                            obj = inject.onRewardRequest(this, user, this.getConfig().getConfigData(), placeholders);
                        }
                    } else {
                        obj = inject.onRewardRequest(this, user, this.getConfig().getConfigData(), placeholders);
                    }
                    if (!Addplaceholder || obj == null) continue;
                    String placeholderName = inject.getPlaceholderName();
                    Object value = "";
                    if (obj instanceof Boolean) {
                        b = (Boolean)obj;
                        value = ((Boolean)b).toString();
                    } else if (obj instanceof String) {
                        value = b = (String)obj;
                    } else if (obj instanceof Double) {
                        b = (Double)obj;
                        value = ((Double)b).toString();
                    } else if (obj instanceof Integer) {
                        b = (Integer)obj;
                        value = ((Integer)b).toString();
                    }
                    this.plugin.extraDebug("Adding placeholder " + placeholderName + ":" + (String)value);
                    placeholders.put(placeholderName, (String)value);
                    continue;
                }
                postReward.add(inject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (RewardInject inject : postReward) {
            try {
                inject.onRewardRequest(this, user, this.getConfig().getConfigData(), placeholders);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void giveReward(AdvancedCoreUser user, RewardOptions rewardOptions) {
        if (!AdvancedCorePlugin.getInstance().getOptions().isProcessRewards()) {
            AdvancedCorePlugin.getInstance().debug("Processing rewards is disabled");
            return;
        }
        if (rewardOptions == null) {
            rewardOptions = new RewardOptions();
        }
        if (!rewardOptions.getPlaceholders().containsKey("ExecDate")) {
            rewardOptions.addPlaceholder("ExecDate", "" + System.currentTimeMillis());
        }
        if (!rewardOptions.getPlaceholders().containsKey("date")) {
            try {
                LocalDateTime ldt = LocalDateTime.now();
                Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
                rewardOptions.addPlaceholder("Date", "" + new SimpleDateFormat(this.plugin.getOptions().getFormatRewardTimeFormat()).format(date));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PlayerRewardEvent event = new PlayerRewardEvent(this, user, rewardOptions);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.plugin.debug("Reward " + this.name + " was cancelled for " + user.getPlayerName());
            return;
        }
        if (rewardOptions.isCheckTimed() && (this.checkDelayed(user, rewardOptions.getPlaceholders()) || this.checkTimed(user, rewardOptions.getPlaceholders()))) {
            return;
        }
        if (!rewardOptions.isOnlineSet()) {
            rewardOptions.setOnline(user.isOnline());
        }
        for (RewardPlaceholderHandle handle : this.plugin.getRewardHandler().getPlaceholders()) {
            if (!handle.isPreProcess()) continue;
            rewardOptions.addPlaceholder(handle.getKey(), handle.getValue(this, user));
        }
        boolean allowOffline = false;
        boolean canGive = true;
        if (!rewardOptions.isIgnoreRequirements()) {
            for (RequirementInject inject : this.plugin.getRewardHandler().getInjectedRequirements()) {
                try {
                    this.plugin.extraDebug(this.getRewardName() + ": Checking requirement " + inject.getPath() + ":" + inject.getPriority());
                    if (inject.onRequirementRequest(this, user, this.getConfig().getConfigData(), rewardOptions)) continue;
                    this.plugin.debug(this.getRewardName() + ": Requirement failed " + inject.getPath() + ":" + inject.isAllowReattempt());
                    canGive = false;
                    if (!inject.isAllowReattempt()) {
                        return;
                    }
                    allowOffline = true;
                }
                catch (Exception e) {
                    this.plugin.debug("Failed to check requirement " + inject.getPath());
                    e.printStackTrace();
                    canGive = false;
                }
            }
        }
        if (this.plugin.getOptions().isPauseRewards()) {
            this.checkRewardFile();
            user.addOfflineRewards(this, rewardOptions.getPlaceholders());
            this.plugin.getLogger().info("Rewards are paused, saving offline reward " + this.getRewardName() + ": " + user.getPlayerName());
            return;
        }
        if (this.plugin.getOptions().isTreatVanishAsOffline() && user.isVanished()) {
            this.checkRewardFile();
            user.addOfflineRewards(this, rewardOptions.getPlaceholders());
            this.plugin.getLogger().info(this.getRewardName() + ": " + user.getPlayerName() + " is vanished, saving reward offline");
            return;
        }
        if (!((rewardOptions.isOnline() && rewardOptions.getServer() == null || user.isOnline()) && !allowOffline || this.isForceOffline() || rewardOptions.isForceOffline())) {
            if (rewardOptions.isGiveOffline()) {
                this.checkRewardFile();
                user.addOfflineRewards(this, rewardOptions.getPlaceholders());
                this.plugin.debug("Saving offline reward " + this.getRewardName() + " for " + user.getPlayerName());
            }
            return;
        }
        if (canGive || this.isForceOffline() || rewardOptions.isForceOffline()) {
            this.plugin.debug(this.name + ": Passed requirements, attempting to give to " + user.getPlayerName() + "/" + user.getUUID());
            this.giveRewardUser(user, rewardOptions.getPlaceholders(), rewardOptions);
        }
    }

    public void giveRewardUser(AdvancedCoreUser user, HashMap<String, String> phs, RewardOptions rewardOptions) {
        Player player = user.getPlayer();
        if (player == null) {
            player = Bukkit.getPlayer((String)user.getPlayerName());
        }
        if (player != null || this.isForceOffline()) {
            if (phs == null) {
                phs = new HashMap();
            }
            String playerName = user.getPlayerName();
            phs.put("player", playerName);
            if (player != null) {
                phs.put("displayname", player.getDisplayName());
            }
            phs.put("@p", playerName);
            LocalDateTime ldt = LocalDateTime.now();
            Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
            phs.put("CurrentDate", "" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(date));
            phs.put("uuid", user.getUUID());
            for (RewardPlaceholderHandle handle : this.plugin.getRewardHandler().getPlaceholders()) {
                if (handle.isPreProcess()) continue;
                phs.put(handle.getKey(), handle.getValue(this, user));
            }
            HashMap<String, String> placeholders = new HashMap<String, String>(phs);
            this.giveInjectedRewards(user, placeholders);
            this.plugin.debug("Gave " + user.getPlayerName() + " reward " + this.name);
            if (rewardOptions.isCheckRepeat() && this.repeatHandle.isEnabled() && !this.repeatHandle.isRepeatOnStartup()) {
                this.repeatHandle.giveRepeat(this.plugin, user);
            }
        } else {
            this.plugin.debug(this.getRewardName() + ": Player == null & forceoffline false, player: " + user.getPlayerName() + "/" + user.getUUID());
        }
    }

    public void load(File folder, String reward) {
        this.name = reward;
        this.file = folder.isDirectory() ? new File(folder, reward + ".yml") : folder;
        this.config = new RewardFileData(this, folder);
        this.loadValues();
    }

    public void load(String name, ConfigurationSection section) {
        this.config = new RewardFileData(this, section);
        this.name = name;
        this.loadValues();
    }

    public void loadValues() {
        this.forceOffline = this.getConfig().getForceOffline();
        this.setDelayEnabled(this.getConfig().getDelayedEnabled());
        if (this.delayEnabled) {
            this.setDelayHours(this.getConfig().getDelayedHours());
            this.setDelayMinutes(this.getConfig().getDelayedMinutes());
            this.setDelaySeconds(this.getConfig().getDelayedSeconds());
            this.setDelayMilliSeconds(this.getConfig().getDelayedMilliSeconds());
        }
        this.setTimedEnabled(this.getConfig().getTimedEnabled());
        if (this.timedEnabled) {
            this.setTimedHour(this.getConfig().getTimedHour());
            this.setTimedMinute(this.getConfig().getTimedMinute());
        }
        this.repeatHandle = new RepeatHandle(this);
        new AnnotationHandler().load(this.getConfig().getConfigData(), this);
    }

    public Reward needsRewardFile(boolean value) {
        this.needsRewardFile = value;
        return this;
    }

    private void setRewardFile() {
        Reward reward = this.plugin.getRewardHandler().getRewardDirectlyDefined(this.name);
        ConfigurationSection section = this.getConfig().getConfigData();
        reward.getConfig().setData(section);
        reward.getConfig().getFileData().options().header("Directly defined reward file. WRONG PLACE TO EDIT THIS! DO NOT EDIT");
        reward.getConfig().setDirectlyDefinedReward(true);
        reward.getConfig().save(reward.getConfig().getFileData());
        this.plugin.getRewardHandler().updateReward(reward);
    }

    public void validate() {
        if (this.getName().equalsIgnoreCase("examplebasic") || this.getName().equalsIgnoreCase("exampleadvanced")) {
            return;
        }
        for (RequirementInject requirementInject : this.plugin.getRewardHandler().getInjectedRequirements()) {
            requirementInject.validate(this, this.getConfig().getConfigData());
        }
        for (RewardInject rewardInject : this.plugin.getRewardHandler().getInjectedRewards()) {
            rewardInject.validate(this, this.getConfig().getConfigData());
        }
        for (String string : this.getConfig().getConfigData().getKeys(false)) {
            boolean valid = false;
            for (RequirementInject requirementInject : this.plugin.getRewardHandler().getInjectedRequirements()) {
                if (requirementInject.hasValidator()) {
                    if (!requirementInject.getValidate().isValid(requirementInject, string)) continue;
                    valid = true;
                    continue;
                }
                if (!requirementInject.getPath().startsWith(string)) continue;
                valid = true;
            }
            for (RewardInject rewardInject : this.plugin.getRewardHandler().getInjectedRewards()) {
                if (rewardInject.isAlwaysValid()) {
                    valid = true;
                    continue;
                }
                if (rewardInject.hasValidator()) {
                    if (!rewardInject.getValidate().isValid(rewardInject, string)) continue;
                    valid = true;
                    continue;
                }
                if (!rewardInject.getPath().startsWith(string)) continue;
                valid = true;
            }
            if (this.plugin.getRewardHandler().getValidPaths().contains(string)) {
                valid = true;
            }
            if (valid) continue;
            this.plugin.getLogger().warning(string + " possibly not valid in reward " + this.getRewardName());
        }
    }

    @Generated
    public RewardFileData getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(RewardFileData config) {
        this.config = config;
    }

    @Generated
    public boolean isDelayEnabled() {
        return this.delayEnabled;
    }

    @Generated
    public void setDelayEnabled(boolean delayEnabled) {
        this.delayEnabled = delayEnabled;
    }

    @Generated
    public int getDelayHours() {
        return this.delayHours;
    }

    @Generated
    public void setDelayHours(int delayHours) {
        this.delayHours = delayHours;
    }

    @Generated
    public int getDelayMinutes() {
        return this.delayMinutes;
    }

    @Generated
    public void setDelayMinutes(int delayMinutes) {
        this.delayMinutes = delayMinutes;
    }

    @Generated
    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    @Generated
    public void setDelaySeconds(int delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    @Generated
    public int getDelayMilliSeconds() {
        return this.delayMilliSeconds;
    }

    @Generated
    public void setDelayMilliSeconds(int delayMilliSeconds) {
        this.delayMilliSeconds = delayMilliSeconds;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public void setFile(File file) {
        this.file = file;
    }

    @Generated
    public boolean isForceOffline() {
        return this.forceOffline;
    }

    @Generated
    public void setForceOffline(boolean forceOffline) {
        this.forceOffline = forceOffline;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public boolean isNeedsRewardFile() {
        return this.needsRewardFile;
    }

    @Generated
    public RepeatHandle getRepeatHandle() {
        return this.repeatHandle;
    }

    @Generated
    public boolean isTimedEnabled() {
        return this.timedEnabled;
    }

    @Generated
    public void setTimedEnabled(boolean timedEnabled) {
        this.timedEnabled = timedEnabled;
    }

    @Generated
    public int getTimedHour() {
        return this.timedHour;
    }

    @Generated
    public void setTimedHour(int timedHour) {
        this.timedHour = timedHour;
    }

    @Generated
    public int getTimedMinute() {
        return this.timedMinute;
    }

    @Generated
    public void setTimedMinute(int timedMinute) {
        this.timedMinute = timedMinute;
    }
}

