/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.rewards;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import java.util.Iterator;
import java.util.TimerTask;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class RepeatHandle {
    private int amount = -1;
    private boolean autoStop = false;
    private boolean enabled = false;
    private int globalAmount = 0;
    private boolean repeatOnStartup = false;
    private Reward reward;
    private long timeBetween = 0L;

    public RepeatHandle(Reward reward) {
        this.reward = reward;
        ConfigurationSection data = reward.getConfig().getConfigData().getConfigurationSection("Repeat");
        if (data != null) {
            this.enabled = data.getBoolean("Enabled", false);
            this.timeBetween = data.getLong("TimeBetween", 0L);
            this.amount = data.getInt("Amount", -1);
            this.repeatOnStartup = data.getBoolean("RepeatOnStartup", false);
            this.autoStop = data.getBoolean("AutoStop", true);
        }
    }

    public void giveRepeat(final AdvancedCorePlugin plugin, final AdvancedCoreUser user) {
        if (this.repeatOnStartup) {
            return;
        }
        plugin.debug("Giving repeat reward in " + this.timeBetween);
        plugin.getRewardHandler().getRepeatTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (RepeatHandle.this.amount > 0) {
                    int cAmount = user.getRepeatAmount(RepeatHandle.this.reward);
                    if (cAmount >= RepeatHandle.this.amount) {
                        user.setRepeatAmount(RepeatHandle.this.reward, 0);
                        this.cancel();
                        return;
                    }
                    user.setRepeatAmount(RepeatHandle.this.reward, cAmount + 1);
                    if (RepeatHandle.this.autoStop) {
                        if (!RepeatHandle.this.reward.canGiveReward(user, new RewardOptions())) {
                            user.setRepeatAmount(RepeatHandle.this.reward, 0);
                            this.cancel();
                            return;
                        }
                        RepeatHandle.this.giveReward(plugin, user, true);
                        this.cancel();
                        return;
                    }
                    RepeatHandle.this.giveReward(plugin, user, false);
                    this.cancel();
                    return;
                }
                if (RepeatHandle.this.autoStop) {
                    if (!RepeatHandle.this.reward.canGiveReward(user, new RewardOptions())) {
                        this.cancel();
                        return;
                    }
                    RepeatHandle.this.giveReward(plugin, user, true);
                    this.cancel();
                    return;
                }
                RepeatHandle.this.giveReward(plugin, user, false);
                this.cancel();
            }
        }, this.timeBetween);
    }

    public void giveRepeatAll(final AdvancedCorePlugin plugin) {
        plugin.getRewardHandler().getRepeatTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                Iterator iterator;
                if (RepeatHandle.this.amount > 0) {
                    if (RepeatHandle.this.globalAmount >= RepeatHandle.this.amount) {
                        this.cancel();
                        return;
                    }
                    RepeatHandle.this.globalAmount++;
                }
                if ((iterator = Bukkit.getOnlinePlayers().iterator()).hasNext()) {
                    Player p = (Player)iterator.next();
                    AdvancedCoreUser user = AdvancedCorePlugin.getInstance().getUserManager().getUser(p);
                    RepeatHandle.this.giveReward(plugin, user, false);
                    this.cancel();
                    return;
                }
            }
        }, this.timeBetween);
    }

    public void giveReward(AdvancedCorePlugin plugin, AdvancedCoreUser user, boolean bypassRequirement) {
        AdvancedCorePlugin.getInstance().debug("Giving repeat reward " + this.reward.getName() + " for " + user.getPlayerName());
        if (bypassRequirement) {
            this.reward.giveReward(user, new RewardOptions().setIgnoreRequirements(false).setIgnoreChance(false).setCheckRepeat(false).forceOffline());
        } else {
            this.reward.giveReward(user, new RewardOptions().setCheckRepeat(false).forceOffline());
        }
        this.giveRepeat(plugin, user);
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Generated
    public boolean isAutoStop() {
        return this.autoStop;
    }

    @Generated
    public void setAutoStop(boolean autoStop) {
        this.autoStop = autoStop;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isRepeatOnStartup() {
        return this.repeatOnStartup;
    }

    @Generated
    public void setRepeatOnStartup(boolean repeatOnStartup) {
        this.repeatOnStartup = repeatOnStartup;
    }

    @Generated
    public Reward getReward() {
        return this.reward;
    }

    @Generated
    public long getTimeBetween() {
        return this.timeBetween;
    }

    @Generated
    public void setTimeBetween(long timeBetween) {
        this.timeBetween = timeBetween;
    }
}

