/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.placeholder;

import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public abstract class PlaceHolder<T> {
    private String description;
    private String identifier;
    private boolean useStartsWith = false;
    private String noValueReturn = "0";
    private ConcurrentHashMap<String, ConcurrentHashMap<UUID, String>> cache;
    private String updateDataKey = "";
    private boolean usesCache = false;

    public PlaceHolder(String identifier) {
        this.identifier = identifier;
    }

    public PlaceHolder(String identifier, boolean useStartsWith) {
        this.identifier = identifier;
        this.useStartsWith = useStartsWith;
    }

    public PlaceHolder(String identifier, String noValueReturn) {
        this.identifier = identifier;
        this.noValueReturn = noValueReturn;
    }

    public PlaceHolder(String identifier, String noValueReturn, boolean useStartsWith) {
        this.identifier = identifier;
        this.useStartsWith = useStartsWith;
        this.noValueReturn = noValueReturn;
    }

    public void clearCachePlayer(UUID javaUUID) {
        for (String ident : this.cache.keySet()) {
            if (!this.cache.get(ident).containsKey(javaUUID)) continue;
            this.cache.get(ident).remove(javaUUID);
        }
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean isCached(String identifier) {
        return this.cache.containsKey(identifier);
    }

    public boolean isCached(String identifier, UUID uuid) {
        return this.isCached(identifier) && this.cache.get(identifier).containsKey(uuid);
    }

    public boolean matches(String identifier) {
        return this.isUseStartsWith() ? MessageAPI.startsWithIgnoreCase(identifier, this.getIdentifier()) : this.getIdentifier().equalsIgnoreCase(identifier);
    }

    public abstract String placeholderRequest(T var1, String var2);

    public PlaceHolder<T> setUseCache(boolean usesCache, String identifier) {
        this.usesCache = usesCache;
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        this.cache.put(identifier, new ConcurrentHashMap());
        return this;
    }

    public PlaceHolder<T> updateDataKey(String key) {
        this.updateDataKey = key;
        return this;
    }

    public PlaceHolder<T> useStartsWith() {
        this.useStartsWith = true;
        return this;
    }

    public PlaceHolder<T> withDescription(String desc) {
        this.description = desc;
        return this;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public boolean isUseStartsWith() {
        return this.useStartsWith;
    }

    @Generated
    public String getNoValueReturn() {
        return this.noValueReturn;
    }

    @Generated
    public ConcurrentHashMap<String, ConcurrentHashMap<UUID, String>> getCache() {
        return this.cache;
    }

    @Generated
    public String getUpdateDataKey() {
        return this.updateDataKey;
    }

    @Generated
    public boolean isUsesCache() {
        return this.usesCache;
    }
}

