/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.placeholder;

import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public abstract class NonPlayerPlaceHolder<T> {
    private String description;
    private String identifier;
    private boolean useStartsWith = false;
    private ConcurrentHashMap<String, String> cache;
    private boolean usesCache = false;
    private String noValueReturn = "0";

    public NonPlayerPlaceHolder(String identifier) {
        this.identifier = identifier;
    }

    public NonPlayerPlaceHolder(String identifier, boolean useStartsWith) {
        this.identifier = identifier;
        this.useStartsWith = useStartsWith;
    }

    public NonPlayerPlaceHolder(String identifier, String noValueReturn) {
        this.identifier = identifier;
        this.noValueReturn = noValueReturn;
    }

    public NonPlayerPlaceHolder(String identifier, String noValueReturn, boolean useStartsWith) {
        this.identifier = identifier;
        this.useStartsWith = useStartsWith;
        this.noValueReturn = noValueReturn;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean isCached(String identifier) {
        return this.cache.containsKey(identifier);
    }

    public boolean matches(String identifier) {
        return this.isUseStartsWith() ? MessageAPI.startsWithIgnoreCase(identifier, this.getIdentifier()) : this.getIdentifier().equalsIgnoreCase(identifier);
    }

    public abstract String placeholderRequest(String var1);

    public NonPlayerPlaceHolder<T> setUseCache(boolean usesCache, String identifier) {
        this.usesCache = usesCache;
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        this.cache.put(identifier, "");
        return this;
    }

    public NonPlayerPlaceHolder<T> useStartsWith() {
        this.useStartsWith = true;
        return this;
    }

    public NonPlayerPlaceHolder<T> withDescription(String desc) {
        this.description = desc;
        return this;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public boolean isUseStartsWith() {
        return this.useStartsWith;
    }

    @Generated
    public ConcurrentHashMap<String, String> getCache() {
        return this.cache;
    }

    @Generated
    public boolean isUsesCache() {
        return this.usesCache;
    }

    @Generated
    public String getNoValueReturn() {
        return this.noValueReturn;
    }
}

