/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.permissions;

import com.bencodez.votingplugin.advancedcore.api.permissions.PermissionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;

public class PlayerPermissionHandler {
    private UUID uuid;
    private PermissionAttachment attachment;
    private PermissionHandler handler;
    private HashMap<String, Long> timedPermissions;
    private HashMap<String, Long> permsToAdd;

    public PlayerPermissionHandler(UUID uuid, PermissionAttachment attachment, PermissionHandler handler) {
        this.uuid = uuid;
        this.attachment = attachment;
        this.handler = handler;
    }

    public PlayerPermissionHandler addExpiration(final String perm, long delay) {
        if (this.timedPermissions == null) {
            this.timedPermissions = new HashMap();
        }
        this.timedPermissions.put(perm, System.currentTimeMillis() + delay * 1000L);
        this.getAttachment().setPermission(perm, true);
        this.handler.getTimer().schedule(new Runnable(){

            @Override
            public void run() {
                PlayerPermissionHandler.this.removePermission(perm);
            }
        }, delay, TimeUnit.SECONDS);
        this.handler.getPlugin().debug("Giving temp permission " + perm + " to " + this.uuid.toString() + " for " + delay);
        return this;
    }

    public PlayerPermissionHandler addOfflinePerm(String perm, long delay) {
        if (this.permsToAdd == null) {
            this.permsToAdd = new HashMap();
        }
        this.permsToAdd.put(perm, delay);
        return this;
    }

    public PlayerPermissionHandler addPerm(String perm) {
        if (this.getAttachment() != null) {
            this.getAttachment().setPermission(perm, true);
            this.handler.getPlugin().debug("Giving permission " + perm + " to " + this.uuid.toString());
        }
        return this;
    }

    public void onLogin(Player player) {
        if (player == null || this.permsToAdd == null) {
            return;
        }
        for (Map.Entry<String, Long> entry : this.permsToAdd.entrySet()) {
            if (entry.getValue() > 0L) {
                this.addExpiration(entry.getKey(), entry.getValue() / 1000L);
                continue;
            }
            this.addPerm(entry.getKey());
        }
    }

    public void remove() {
        this.getAttachment().remove();
        this.handler.removePermission(this.uuid);
    }

    public void removePermission(String perm) {
        this.getAttachment().setPermission(perm, false);
        this.getAttachment().getPermissions().remove(perm);
        if (this.timedPermissions != null) {
            this.timedPermissions.remove(perm);
        }
        this.handler.getPlugin().debug("Removing permission " + perm + " to " + this.uuid.toString());
        if (this.getAttachment().getPermissions().size() == 0) {
            this.remove();
        }
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public PermissionAttachment getAttachment() {
        return this.attachment;
    }

    @Generated
    public void setAttachment(PermissionAttachment attachment) {
        this.attachment = attachment;
    }

    @Generated
    public HashMap<String, Long> getTimedPermissions() {
        return this.timedPermissions;
    }
}

