/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.permissions;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.permissions.PlayerPermissionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class PermissionHandler {
    private AdvancedCorePlugin plugin;
    private ConcurrentHashMap<UUID, PlayerPermissionHandler> perms = new ConcurrentHashMap();
    private ScheduledExecutorService timer = Executors.newScheduledThreadPool(1);
    private HashMap<UUID, PlayerPermissionHandler> permsToAdd;

    public PermissionHandler(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
        this.permsToAdd = new HashMap();
        if (plugin.getServerDataFile().getData() != null && plugin.getServerDataFile().getData().isConfigurationSection("TimedPermissions")) {
            for (String string : plugin.getServerDataFile().getData().getConfigurationSection("TimedPermissions").getKeys(false)) {
                UUID uuid = UUID.fromString(string);
                List list = plugin.getServerDataFile().getData().getStringList("TimedPermissions." + string);
                for (String str : list) {
                    String[] data = str.split(Pattern.quote("%line%"));
                    if (data.length <= 1) continue;
                    String perm = data[0];
                    String longStr = data[1];
                    long delay = Long.valueOf(longStr) - System.currentTimeMillis();
                    if (delay <= 0L) continue;
                    plugin.debug("Adding permission " + perm + " to " + string);
                    this.addPermission(uuid, perm, delay);
                }
            }
            plugin.getServerDataFile().getData().set("TimedPermissions", null);
        }
    }

    public void addPermission(Player player, String permission) {
        this.addPermission(player.getUniqueId(), permission);
    }

    public void addPermission(Player player, String permission, long expiration) {
        this.addPermission(player.getUniqueId(), permission, expiration);
    }

    public void addPermission(UUID uuid, String permission) {
        if (permission.isEmpty()) {
            this.plugin.debug("Permission is empty");
            return;
        }
        for (String perm : permission.split(Pattern.quote("|"))) {
            if (this.getPerms().contains(uuid)) {
                this.getPerms().get(uuid).addPerm(perm);
                continue;
            }
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p != null) {
                PermissionAttachment attachment = p.addAttachment((Plugin)this.plugin);
                PlayerPermissionHandler handle = new PlayerPermissionHandler(uuid, attachment, this);
                this.plugin.getPermissionHandler().getPerms().put(uuid, handle.addPerm(perm));
                continue;
            }
            this.getPermsToAdd().put(uuid, new PlayerPermissionHandler(uuid, null, this).addOfflinePerm(perm, -1L));
        }
    }

    public void addPermission(UUID uuid, String permission, long delay) {
        if (permission.isEmpty()) {
            this.plugin.debug("Permission is empty");
            return;
        }
        for (String perm : permission.split(Pattern.quote("|"))) {
            if (this.getPerms().contains(uuid)) {
                this.getPerms().get(uuid).addPerm(perm);
                continue;
            }
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p != null) {
                PermissionAttachment attachment = p.addAttachment((Plugin)this.plugin);
                PlayerPermissionHandler handle = new PlayerPermissionHandler(uuid, attachment, this);
                this.plugin.getPermissionHandler().getPerms().put(uuid, handle.addExpiration(perm, delay));
                continue;
            }
            this.getPermsToAdd().put(uuid, new PlayerPermissionHandler(uuid, null, this).addOfflinePerm(perm, delay));
        }
    }

    public void login(Player player) {
        if (this.permsToAdd.containsKey(player.getUniqueId())) {
            PlayerPermissionHandler handle = this.permsToAdd.get(player.getUniqueId());
            handle.setAttachment(player.addAttachment((Plugin)this.plugin));
            handle.onLogin(player);
            this.getPerms().put(player.getUniqueId(), handle);
            this.permsToAdd.remove(player.getUniqueId());
        }
    }

    public void removePermission(UUID uuid) {
        this.getPerms().remove(uuid);
    }

    public void removePermission(UUID uuid, String playerName, String permission) {
        if (this.plugin.getPermissionHandler().getPerms().containsKey(uuid)) {
            for (String perm : permission.split(Pattern.quote("|"))) {
                this.plugin.getPermissionHandler().getPerms().get(uuid).removePermission(perm);
                this.plugin.debug("Removing temp permission " + perm + " from " + playerName);
            }
        }
    }

    public void shutDown() {
        for (PlayerPermissionHandler handle : this.getPerms().values()) {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, Long> entry : handle.getTimedPermissions().entrySet()) {
                list.add(entry.getKey() + "%line%" + entry.getValue());
            }
            if (list.size() <= 0) continue;
            this.plugin.getServerDataFile().getData().set("TimedPermissions." + handle.getUuid().toString(), list);
        }
        this.plugin.getServerDataFile().saveData();
    }

    @Generated
    public AdvancedCorePlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public ConcurrentHashMap<UUID, PlayerPermissionHandler> getPerms() {
        return this.perms;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public HashMap<UUID, PlayerPermissionHandler> getPermsToAdd() {
        return this.permsToAdd;
    }
}

