/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.misc.effects;

import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Title {
    private int fadeInTime = -1;
    private int fadeOutTime = -1;
    private int stayTime = -1;
    private String subtitle = "";
    private String title = "";

    public Title() {
    }

    public Title(String title) {
        this.title = title;
    }

    public Title(String title, String subtitle) {
        this.title = title;
        this.subtitle = subtitle;
    }

    public Title(String title, String subtitle, int fadeInTime, int stayTime, int fadeOutTime) {
        this.title = title;
        this.subtitle = subtitle;
        this.fadeInTime = fadeInTime;
        this.stayTime = stayTime;
        this.fadeOutTime = fadeOutTime;
    }

    public Title(Title title) {
        this.title = title.getTitle();
        this.subtitle = title.getSubtitle();
        this.fadeInTime = title.getFadeInTime();
        this.fadeOutTime = title.getFadeOutTime();
        this.stayTime = title.getStayTime();
    }

    public void broadcast() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.send(p);
        }
    }

    public void clearTitle(Player player) {
        player.sendTitle("", "", -1, -1, -1);
    }

    public int getFadeInTime() {
        return this.fadeInTime;
    }

    public int getFadeOutTime() {
        return this.fadeOutTime;
    }

    public int getStayTime() {
        return this.stayTime;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void resetTitle(Player player) {
        this.clearTitle(player);
    }

    public void send(Player player) {
        this.send(player, this.title, this.subtitle, this.fadeInTime, this.stayTime, this.fadeOutTime);
    }

    public void send(Player player, String title, String subtitle, int fadeInTime, int stayTime, int fadeOutTime) {
        player.sendTitle(MessageAPI.colorize(title), MessageAPI.colorize(subtitle), fadeInTime, stayTime, fadeOutTime);
    }

    public void setFadeInTime(int time) {
        this.fadeInTime = time;
    }

    public void setFadeOutTime(int time) {
        this.fadeOutTime = time;
    }

    public void setStayTime(int time) {
        this.stayTime = time;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void updateSubtitle(Player player) {
        this.updateSubtitle(player, this.subtitle);
    }

    public void updateSubtitle(Player player, String subtitle) {
        player.sendTitle("", MessageAPI.colorize(subtitle), -1, -1, -1);
    }

    public void updateTimes(Player player) {
        this.updateTimes(player, this.fadeInTime, this.stayTime, this.fadeOutTime);
    }

    public void updateTimes(Player player, int fadeInTime, int stayTime, int fadeOutTime) {
        player.sendTitle("", "", fadeInTime, stayTime, fadeOutTime);
    }

    public void updateTitle(Player player) {
        this.updateTitle(player, this.title);
    }

    public void updateTitle(Player player, String title) {
        player.sendTitle(MessageAPI.colorize(title), "", -1, -1, -1);
    }
}

