/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.misc.effects;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.List;
import java.util.PriorityQueue;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemMessage {
    private static final String DEF_FORMAT_1 = "%s";
    private static final String DEF_FORMAT_2 = " %s ";
    private static final int DEFAULT_DURATION = 2;
    private static final int DEFAULT_PRIORITY = 0;
    private static final String METADATA_ID_KEY = "item-message:id";
    private static final String METADATA_Q_KEY = "item-message:msg-queue";
    private Material emptyHandReplacement = Material.SNOW;
    private String[] formats = new String[]{"%s", " %s "};
    private int interval = 20;
    private final Plugin plugin;

    public ItemMessage(Plugin plugin) {
        this.plugin = plugin;
    }

    private PriorityQueue<MessageRecord> getMessageQueue(Player player) {
        if (!player.hasMetadata(METADATA_Q_KEY)) {
            player.setMetadata(METADATA_Q_KEY, (MetadataValue)new FixedMetadataValue(this.plugin, new PriorityQueue()));
        }
        for (MetadataValue v : player.getMetadata(METADATA_Q_KEY)) {
            if (!(v.value() instanceof PriorityQueue)) continue;
            return (PriorityQueue)v.value();
        }
        return null;
    }

    private long getNextId(Player player) {
        List l;
        long id = player.hasMetadata(METADATA_ID_KEY) ? ((l = player.getMetadata(METADATA_ID_KEY)).size() >= 1 ? ((MetadataValue)l.get(0)).asLong() : 1L) : 1L;
        player.setMetadata(METADATA_ID_KEY, (MetadataValue)new FixedMetadataValue(this.plugin, (Object)(id + 1L)));
        return id;
    }

    private MessageRecord importOtherMessageRecord(Object other) {
        if (other instanceof MessageRecord) {
            return (MessageRecord)other;
        }
        if (other.getClass().getName().endsWith(".ItemMessage$MessageRecord")) {
            try {
                Method m1 = other.getClass().getMethod("getId", new Class[0]);
                Method m2 = other.getClass().getMethod("getPriority", new Class[0]);
                Method m3 = other.getClass().getMethod("getMessage", new Class[0]);
                Method m4 = other.getClass().getMethod("getDuration", new Class[0]);
                long otherId = (Long)m1.invoke(other, new Object[0]);
                int otherPriority = (Integer)m2.invoke(other, new Object[0]);
                String otherMessage = (String)m3.invoke(other, new Object[0]);
                int otherDuration = (Integer)m4.invoke(other, new Object[0]);
                return new MessageRecord(otherMessage, otherDuration, otherPriority, otherId);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void notifyDone(Player player) {
        PriorityQueue<MessageRecord> msgQueue = this.getMessageQueue(player);
        msgQueue.poll();
        if (!msgQueue.isEmpty()) {
            MessageRecord rec = this.importOtherMessageRecord(msgQueue.peek());
            new NamerTask(player, rec).runTaskTimer(this.plugin, 1L, this.interval);
        }
    }

    public void sendMessage(Player player, String message) {
        this.sendMessage(player, message, 2, 0);
    }

    public void sendMessage(Player player, String message, int duration) {
        this.sendMessage(player, message, duration, 0);
    }

    public void sendMessage(Player player, String message, int duration, int priority) {
        PriorityQueue<MessageRecord> msgQueue = this.getMessageQueue(player);
        msgQueue.add(new MessageRecord(message, duration, priority, this.getNextId(player)));
        if (msgQueue.size() == 1) {
            new NamerTask(player, msgQueue.peek()).runTaskTimer(this.plugin, 1L, this.interval);
        }
    }

    public void setEmptyHandReplacement(Material material) {
        if (material == null) {
            throw new NullPointerException("There must be a replacement for an empty hand!");
        }
        this.emptyHandReplacement = material;
    }

    public void setFormats(String ... formats) {
        if (formats.length <= 1) {
            throw new IllegalArgumentException("Two formats are minimum!");
        }
        for (String format : formats) {
            if (format.contains(DEF_FORMAT_1)) continue;
            throw new IllegalArgumentException("format string \"" + format + "\" must contain a %s");
        }
        this.formats = formats;
    }

    public void setInterval(int interval) {
        if (interval < 1) {
            throw new IllegalArgumentException("Interval can't be below 1!");
        }
        this.interval = interval;
    }

    public class MessageRecord
    implements Comparable<Object> {
        private final int duration;
        private final long id;
        private final String message;
        private final int priority;

        public MessageRecord(String message, int duration, int priority, long id) {
            this.message = message;
            this.duration = duration;
            this.priority = priority;
            this.id = id;
        }

        @Override
        public int compareTo(Object other) {
            MessageRecord rec = ItemMessage.this.importOtherMessageRecord(other);
            if (rec == null) {
                return 0;
            }
            if (this.priority == rec.getPriority()) {
                return Long.valueOf(this.id).compareTo(rec.getId());
            }
            return Integer.valueOf(this.priority).compareTo(rec.getPriority());
        }

        public int getDuration() {
            return this.duration;
        }

        public long getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    private class NamerTask
    extends BukkitRunnable
    implements Listener {
        private int iterations;
        private final String message;
        private final WeakReference<Player> playerRef;
        private int slot;

        public NamerTask(Player player, MessageRecord rec) {
            this.playerRef = new WeakReference<Player>(player);
            this.iterations = Math.max(1, rec.getDuration() * 20 / ItemMessage.this.interval);
            this.slot = player.getInventory().getHeldItemSlot();
            this.message = rec.getMessage();
            Bukkit.getPluginManager().registerEvents((Listener)this, ItemMessage.this.plugin);
        }

        private void cleanup() {
            this.cancel();
            HandlerList.unregisterAll((Listener)this);
        }

        private void finish(Player player) {
            this.sendItemSlotChange(player, this.slot, player.getInventory().getItem(this.slot));
            ItemMessage.this.notifyDone(player);
            this.cleanup();
        }

        private ItemStack makeStack(Player player) {
            ItemStack stack0 = player.getInventory().getItem(this.slot);
            ItemStack stack = stack0 == null || stack0.getType() == Material.AIR ? new ItemStack(ItemMessage.this.emptyHandReplacement, 1) : new ItemStack(stack0);
            ItemMeta meta = Bukkit.getItemFactory().getItemMeta(stack.getType());
            meta.setDisplayName(String.format(ItemMessage.this.formats[this.iterations % ItemMessage.this.formats.length], this.message));
            stack.setItemMeta(meta);
            return stack;
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onItemHeldChange(PlayerItemHeldEvent event) {
            Player player = event.getPlayer();
            if (player.equals(this.playerRef.get())) {
                this.sendItemSlotChange(player, event.getPreviousSlot(), player.getInventory().getItem(event.getPreviousSlot()));
                this.slot = event.getNewSlot();
                this.refresh(event.getPlayer());
            }
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            Player player = (Player)this.playerRef.get();
            if (event.getPlugin() == ItemMessage.this.plugin && player != null) {
                ItemMessage.this.getMessageQueue(player).clear();
                this.finish((Player)this.playerRef.get());
            }
        }

        private void refresh(Player player) {
            this.sendItemSlotChange(player, this.slot, this.makeStack(player));
        }

        public void run() {
            Player player = (Player)this.playerRef.get();
            if (player != null) {
                if (this.iterations-- <= 0) {
                    this.finish(player);
                } else {
                    this.refresh(player);
                }
            } else {
                this.cleanup();
            }
        }

        private void sendItemSlotChange(Player player, int slot, ItemStack stack) {
            PacketContainer setSlot = new PacketContainer(PacketType.Play.Server.SET_SLOT);
            setSlot.getIntegers().write(0, (Object)0).write(1, (Object)(slot + 36));
            setSlot.getItemModifier().write(0, (Object)stack);
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, setSlot);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

