/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.misc.effects;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import java.util.ArrayList;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class FireworkHandler
implements Listener {
    static FireworkHandler instance = new FireworkHandler();
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public static FireworkHandler getInstance() {
        return instance;
    }

    private FireworkHandler() {
    }

    public void launchFirework(final Location loc, final int power, final ArrayList<String> colors, final ArrayList<String> fadeOutColor, final boolean trail, final boolean flicker, final ArrayList<String> types, final boolean detonate) {
        this.plugin.getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int blue;
                int green;
                int red;
                int rgb;
                String hexColor;
                Firework fw = (Firework)loc.getWorld().spawnEntity(loc, MiscUtils.getInstance().getEntityType("FIREWORK_ROCKET", "FIREWORK"));
                FireworkMeta fwmeta = fw.getFireworkMeta();
                FireworkEffect.Builder builder = FireworkEffect.builder();
                if (trail) {
                    builder.withTrail();
                }
                if (flicker) {
                    builder.withFlicker();
                }
                for (String color : colors) {
                    if (color.startsWith("#")) {
                        hexColor = color.substring(1);
                        rgb = Integer.parseInt(hexColor, 16);
                        red = rgb >> 16 & 0xFF;
                        green = rgb >> 8 & 0xFF;
                        blue = rgb & 0xFF;
                        builder.withColor(Color.fromRGB((int)red, (int)green, (int)blue));
                        continue;
                    }
                    try {
                        builder.withColor(DyeColor.valueOf((String)color).getColor());
                    }
                    catch (Exception ex) {
                        FireworkHandler.this.plugin.getLogger().info(color + " is not a valid color, see https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Color.html");
                    }
                }
                for (String color : fadeOutColor) {
                    if (color.startsWith("#")) {
                        hexColor = color.substring(1);
                        rgb = Integer.parseInt(hexColor, 16);
                        red = rgb >> 16 & 0xFF;
                        green = rgb >> 8 & 0xFF;
                        blue = rgb & 0xFF;
                        builder.withFade(Color.fromRGB((int)red, (int)green, (int)blue));
                        continue;
                    }
                    try {
                        builder.withFade(DyeColor.valueOf((String)color).getColor());
                    }
                    catch (Exception ex) {
                        FireworkHandler.this.plugin.getLogger().info(color + " is not a valid color, see https://hub.spigotmc.org/javadocs/spigot/org/bukkit/DyeColor.html");
                    }
                }
                for (String type : types) {
                    try {
                        builder.with(FireworkEffect.Type.valueOf((String)type));
                    }
                    catch (Exception ex) {
                        FireworkHandler.this.plugin.getLogger().info(type + " is not a valid Firework Effect, see https://hub.spigotmc.org/javadocs/spigot/org/bukkit/FireworkEffect.Type.html");
                    }
                }
                fwmeta.addEffects(new FireworkEffect[]{builder.build()});
                fwmeta.setPower(power);
                fw.setFireworkMeta(fwmeta);
                fw.setCustomName("reward");
                fw.setCustomNameVisible(false);
                if (detonate) {
                    fw.detonate();
                }
            }
        }, loc);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onFireworkDamage(EntityDamageByEntityEvent event) {
        Firework fw;
        if (event.getDamager() instanceof Firework && (fw = (Firework)event.getDamager()).getCustomName() != null && fw.getCustomName().equals("reward")) {
            event.setCancelled(true);
        }
    }
}

