/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.misc.effects;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossBar {
    private org.bukkit.boss.BossBar bossBar;

    public BossBar(String msg, String barColor, String barStyle, double progress) {
        this.bossBar = Bukkit.createBossBar((String)MessageAPI.colorize(msg), (BarColor)BarColor.valueOf((String)barColor), (BarStyle)BarStyle.valueOf((String)barStyle), (BarFlag[])new BarFlag[0]);
        this.bossBar.setProgress(progress);
    }

    public void addPlayer(Player player) {
        this.bossBar.addPlayer(player);
    }

    public void addPlayer(final Player player, int delay) {
        try {
            if (player == null) {
                return;
            }
            this.bossBar.addPlayer(player);
            if (delay > 0) {
                AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskLater((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        if (BossBar.this.bossBar != null && player != null) {
                            BossBar.this.bossBar.removePlayer(player);
                        }
                    }
                }, (long)(delay * 50 + 60), TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            AdvancedCorePlugin.getInstance().debug(e);
        }
    }

    public List<Player> getPlayers() {
        return this.bossBar.getPlayers();
    }

    public void hide() {
        if (this.bossBar != null) {
            this.bossBar.setVisible(false);
            this.bossBar.removeAll();
        }
    }

    private void hideInDelay(int delay) {
        AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskLater((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

            @Override
            public void run() {
                BossBar.this.hide();
            }
        }, (long)(delay * 50), TimeUnit.MILLISECONDS);
    }

    public void removePlayer(Player player) {
        this.bossBar.removePlayer(player);
    }

    public void send() {
        this.bossBar.setVisible(true);
    }

    public void send(int delay) {
        this.bossBar.setVisible(true);
        this.hideInDelay(delay);
    }

    public void send(Player player, int delay) {
        this.bossBar.addPlayer(player);
        this.bossBar.setVisible(true);
        this.hideInDelay(delay);
    }

    public void setColor(String barColor) {
        if (barColor != null) {
            this.bossBar.setColor(BarColor.valueOf((String)barColor));
        }
    }

    public void setProgress(double progress) {
        if (progress > 1.0) {
            progress = 1.0;
        }
        if (progress < 0.0) {
            progress = 0.0;
        }
        this.bossBar.setProgress(progress);
    }

    public void setStyle(String barStyle) {
        if (barStyle != null) {
            this.bossBar.setStyle(BarStyle.valueOf((String)barStyle));
        }
    }

    public void setTitle(String title) {
        if (title != null) {
            this.bossBar.setTitle(MessageAPI.colorize(title));
        }
    }

    public void setVisible(boolean visible) {
        this.bossBar.setVisible(visible);
    }

    @Generated
    public org.bukkit.boss.BossBar getBossBar() {
        return this.bossBar;
    }
}

