/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.misc.effects;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.nms.NMSManager;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBar {
    private int duration;
    private String msg;
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public ActionBar(String msg, int duration) {
        this.setMsg(MessageAPI.colorize(msg));
        this.setDuration(duration);
    }

    public int getDuration() {
        return this.duration;
    }

    public String getMsg() {
        return this.msg;
    }

    public void send(Player ... players) {
        for (Player player : players) {
            this.sendActionBar(player, this.getMsg(), this.getDuration());
        }
    }

    public void sendActionBar(Player player, String message) {
        if (!NMSManager.getInstance().isVersion("1.7", "1.8", "1.9", "1.10", "1.11", "1.12")) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
    }

    public void sendActionBar(final Player player, final String message, int duration) {
        this.sendActionBar(player, message);
        if (duration >= 0) {
            new BukkitRunnable(){

                public void run() {
                    ActionBar.this.sendActionBar(player, "");
                }
            }.runTaskLater((Plugin)this.plugin, (long)(duration + 1));
        }
        for (int i = 30; i < duration; i += 30) {
            new BukkitRunnable(){

                public void run() {
                    ActionBar.this.sendActionBar(player, message);
                }
            }.runTaskLater((Plugin)this.plugin, (long)i);
        }
    }

    public void sendActionBarToAllPlayers(String message) {
        this.sendActionBarToAllPlayers(message, -1);
    }

    public void sendActionBarToAllPlayers(String message, int duration) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.sendActionBar(p, message, duration);
        }
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

