/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.misc;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerManager {
    static PlayerManager instance = new PlayerManager();
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public static PlayerManager getInstance() {
        return instance;
    }

    private PlayerManager() {
    }

    public boolean damageItemInHand(Player player, int damage) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        ItemMeta meta = itemInHand.getItemMeta();
        boolean isUnbreakable = false;
        try {
            isUnbreakable = meta.isUnbreakable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (meta instanceof Damageable && !isUnbreakable) {
            Damageable dMeta = (Damageable)meta;
            int level = itemInHand.getEnchantmentLevel(MiscUtils.getInstance().getEnchant("UNBREAKING", "DURABILITY"));
            int chance = 100 / (level + 1);
            int addedDamage = 0;
            for (int i = 0; i < damage; ++i) {
                if (chance != 100 && ThreadLocalRandom.current().nextInt(100) >= chance) continue;
                ++addedDamage;
            }
            if (addedDamage > 0) {
                dMeta.setDamage(dMeta.getDamage() + addedDamage);
                itemInHand.setItemMeta((ItemMeta)dMeta);
                if (dMeta.getDamage() > itemInHand.getType().getMaxDurability()) {
                    player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String getPlayerName(AdvancedCoreUser user, String uuid) {
        return this.getPlayerName(user, uuid, true);
    }

    public String getPlayerName(AdvancedCoreUser user, String uuid, boolean useCache) {
        String n;
        if (uuid == null || uuid.equalsIgnoreCase("null") || uuid.isEmpty()) {
            this.plugin.debug("Null UUID");
            return "";
        }
        if (this.plugin.getUuidNameCache().containsKey(uuid) && (n = this.plugin.getUuidNameCache().get(uuid)) != null && !n.isEmpty() && !n.equalsIgnoreCase("Error getting name")) {
            return n;
        }
        String name = "";
        if (uuid.length() <= 5) {
            return "Error getting name";
        }
        UUID u = UUID.fromString(uuid);
        Player player = Bukkit.getPlayer((UUID)u);
        String storedName = user.getData().getString("PlayerName", useCache, true);
        if (player != null) {
            name = player.getName();
            if ((storedName == null || name != storedName || storedName.isEmpty() || storedName.equalsIgnoreCase("Error getting name")) && user.getUserData().hasData()) {
                user.getData().setString("PlayerName", name);
            }
            return name;
        }
        return storedName;
    }

    public ItemStack getPlayerSkull(UUID uuid, String name) {
        return this.getPlayerSkull(uuid, name, true);
    }

    public ItemStack getPlayerSkull(UUID uuid, String name, boolean force) {
        return this.plugin.getSkullCacheHandler().getSkull(uuid, name);
    }

    public String getUUID(String playerName) {
        if (playerName == null || playerName.isEmpty()) {
            return null;
        }
        if (!this.plugin.getOptions().isOnlineMode()) {
            return UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes(StandardCharsets.UTF_8)).toString();
        }
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player != null) {
            return player.getUniqueId().toString();
        }
        String uuid = this.getUUIDLookup(playerName);
        if (!uuid.equals("")) {
            return uuid;
        }
        try {
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)playerName);
            return p.getUniqueId().toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().info("Unable to get UUID for: " + playerName);
            this.plugin.debug(e);
            return "";
        }
    }

    private String getUUIDLookup(String playerName) {
        String name;
        if (playerName == null) {
            return "";
        }
        ConcurrentHashMap<String, String> uuids = this.plugin.getUuidNameCache();
        if (uuids != null) {
            for (Map.Entry<String, String> entry : uuids.entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(playerName)) continue;
                return entry.getKey();
            }
        }
        if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
            name = this.plugin.getMysql().getUUID(playerName);
            if (name != null) {
                return name;
            }
        } else if (this.plugin.getStorageType().equals((Object)UserStorage.SQLITE)) {
            name = this.plugin.getSQLiteUserTable().getUUID(playerName);
            if (name != null) {
                return name;
            }
        } else {
            for (String uuid : this.plugin.getUserManager().getAllUUIDs()) {
                AdvancedCoreUser user = this.plugin.getUserManager().getUser(UUID.fromString(uuid));
                user.dontCache();
                String name2 = user.getData().getString("PlayerName", true);
                if (name2 == null || !name2.equals(playerName)) continue;
                this.plugin.getUuidNameCache().put(uuid, playerName);
                return uuid;
            }
        }
        return "";
    }

    public boolean hasEitherPermission(CommandSender sender, String perm) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (perm.equals("")) {
            return true;
        }
        if (AdvancedCorePlugin.getInstance().getOptions().isUseVaultPermissions() && this.plugin.getVaultHandler() != null && this.plugin.getVaultHandler().getPerms() != null && this.plugin.getVaultHandler().getPerms().isEnabled()) {
            boolean hasPerm = false;
            for (String permission : perm.split("\\|")) {
                boolean has = this.plugin.getVaultHandler().getPerms().playerHas(player, permission);
                if (hasPerm) continue;
                hasPerm = has;
            }
            return hasPerm;
        }
        boolean hasPerm = false;
        for (String permission : perm.split("\\|")) {
            if (!sender.hasPermission(permission)) continue;
            hasPerm = true;
        }
        return hasPerm;
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        return sender.hasPermission(this.plugin.getName() + "." + perm);
    }

    public boolean hasPermission(Player player, String perm) {
        return player.hasPermission(this.plugin.getName() + "." + perm);
    }

    public boolean hasPermission(String playerName, String perm) {
        if (playerName == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((String)playerName);
        if (player != null) {
            return player.hasPermission(this.plugin.getName() + "." + perm);
        }
        return false;
    }

    public boolean hasServerPermission(String playerName, String perm) {
        if (playerName == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((String)playerName);
        if (player != null) {
            return player.hasPermission(perm);
        }
        return false;
    }

    public boolean hasServerPermission(UUID playerUUID, String playername, String perm) {
        if (playerUUID == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player != null) {
            return player.hasPermission(perm);
        }
        player = Bukkit.getPlayer((String)playername);
        if (player != null) {
            return player.hasPermission(perm);
        }
        if (this.plugin.getLuckPermsHandle() != null && this.plugin.getLuckPermsHandle().luckpermsApiLoaded() && this.plugin.getLuckPermsHandle().hasPermission(playerUUID, perm)) {
            return true;
        }
        if (AdvancedCorePlugin.getInstance().getOptions().isUseVaultPermissions() && this.plugin.getVaultHandler() != null && this.plugin.getVaultHandler().getPerms() != null && this.plugin.getVaultHandler().getPerms().isEnabled()) {
            return this.plugin.getVaultHandler().getPerms().playerHas(((World)Bukkit.getWorlds().get(0)).getName(), Bukkit.getOfflinePlayer((UUID)playerUUID), perm);
        }
        return false;
    }

    public boolean isValidUser(String name) {
        return this.isValidUser(name, false);
    }

    public boolean isValidUser(String name, boolean checkServer) {
        OfflinePlayer p;
        Player player = Bukkit.getPlayerExact((String)name);
        if (player != null) {
            return true;
        }
        boolean userExist = this.plugin.getUserManager().userExist(name);
        if (userExist) {
            return userExist;
        }
        if (name.isEmpty()) {
            return false;
        }
        if (this.plugin.getBedrockHandle().isBedrock(name)) {
            this.plugin.extraDebug("Player " + name + " is a bedrock player, skipping offline check");
            return true;
        }
        if (checkServer && !name.startsWith(this.plugin.getOptions().getBedrockPlayerPrefix()) && ((p = Bukkit.getOfflinePlayer((String)name)).hasPlayedBefore() || p.isOnline() || p.getLastPlayed() != 0L)) {
            return true;
        }
        this.plugin.extraDebug("Player " + name + " does not exist");
        return false;
    }
}

