/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.misc;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class MiscUtils {
    static MiscUtils instance = new MiscUtils();
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public static MiscUtils getInstance() {
        return instance;
    }

    private MiscUtils() {
    }

    public Date addSeconds(Date date, int seconds) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(13, seconds);
        return c.getTime();
    }

    public void broadcast(String broadcastMsg) {
        this.broadcast(broadcastMsg, new ArrayList<Player>(Bukkit.getOnlinePlayers()));
    }

    public void broadcast(String broadcastMsg, ArrayList<Player> players) {
        if (broadcastMsg != null && !broadcastMsg.equals("")) {
            String consoleMsg = broadcastMsg;
            for (Player player : players) {
                for (String str1 : broadcastMsg.split(Pattern.quote("%newline%"))) {
                    for (String str : str1.split(Pattern.quote("%NewLine%"))) {
                        String msg = MessageAPI.colorize(PlaceholderUtils.replacePlaceHolders(player, str));
                        PlayerUtils.getServerHandle().sendMessage(player, (BaseComponent)PlaceholderUtils.parseJson(msg));
                    }
                }
            }
            Bukkit.getServer().getConsoleSender().sendMessage(MessageAPI.colorize(consoleMsg));
        }
    }

    public boolean checkChance(double chance, double outOf) {
        if (chance == 0.0 || chance == outOf) {
            return true;
        }
        double randomNum = ThreadLocalRandom.current().nextDouble(outOf);
        this.plugin.extraDebug("Chance Required: " + chance + ", RandomNum: " + randomNum);
        return randomNum <= chance;
    }

    public AdvancedCoreUser[] convertUsers(ArrayList<AdvancedCoreUser> array) {
        if (array == null) {
            return null;
        }
        AdvancedCoreUser[] list = new AdvancedCoreUser[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            list[i] = array.get(i);
        }
        return list;
    }

    public ArrayList<AdvancedCoreUser> convertUsers(Set<AdvancedCoreUser> set) {
        if (set == null) {
            return null;
        }
        ArrayList<AdvancedCoreUser> list = new ArrayList<AdvancedCoreUser>();
        for (AdvancedCoreUser user : set) {
            list.add(user);
        }
        return list;
    }

    public void executeConsoleCommands(ArrayList<String> cmds, HashMap<String, String> placeholders, boolean stagger) {
        if (cmds != null && !cmds.isEmpty()) {
            ArrayList<String> commands = PlaceholderUtils.replacePlaceHolder(cmds, placeholders);
            int tick = 0;
            for (String cmd : commands) {
                this.plugin.debug("Executing console command: " + cmd);
                this.runConsoleCommand(cmd, tick, stagger);
            }
        }
    }

    public void executeConsoleCommands(Player player, ArrayList<String> cmds, HashMap<String, String> placeholders, boolean stagger) {
        if (cmds != null && !cmds.isEmpty()) {
            placeholders.put("player", player.getName());
            ArrayList<String> commands = PlaceholderUtils.replaceJavascript(player, PlaceholderUtils.replacePlaceHolder(cmds, placeholders));
            int tick = 0;
            for (String cmd : commands) {
                this.plugin.debug("Executing console command: " + cmd);
                this.runConsoleCommand(cmd, tick, stagger);
            }
        }
    }

    public void executeConsoleCommands(Player player, String command, HashMap<String, String> placeholders) {
        if (command != null && !command.isEmpty()) {
            final String cmd = PlaceholderUtils.replaceJavascript(player, PlaceholderUtils.replacePlaceHolder(command, placeholders));
            this.plugin.debug("Executing console command: " + command);
            this.plugin.getBukkitScheduler().executeOrScheduleSync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd);
                }
            }, (Entity)player);
        }
    }

    public void executeConsoleCommands(String playerName, ArrayList<String> cmds, HashMap<String, String> placeholders, boolean stagger) {
        if (cmds != null && !cmds.isEmpty()) {
            placeholders.put("player", playerName);
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)playerName);
            ArrayList<String> commands1 = cmds;
            if (p != null) {
                commands1 = PlaceholderUtils.replaceJavascript(p, commands1);
            }
            ArrayList<String> commands = PlaceholderUtils.replacePlaceHolder(commands1, placeholders);
            int tick = 0;
            for (String cmd : commands) {
                this.plugin.debug("Executing console command: " + cmd);
                this.runConsoleCommand(cmd, tick, stagger);
            }
        }
    }

    public void executeConsoleCommands(String playerName, String command, HashMap<String, String> placeholders) {
        if (command != null && !command.isEmpty()) {
            Player p = Bukkit.getPlayer((String)playerName);
            if (p != null) {
                command = PlaceholderUtils.replaceJavascript(p, command);
            }
            if (command.startsWith("/")) {
                command.replaceFirst("/", "");
            }
            final String cmd = PlaceholderUtils.replacePlaceHolder(command, placeholders);
            this.plugin.debug("Executing console command: " + command);
            this.plugin.getBukkitScheduler().executeOrScheduleSync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd);
                }
            });
        }
    }

    public Object getBlockMeta(Block block, String str) {
        for (MetadataValue meta : block.getMetadata(str)) {
            if (!meta.getOwningPlugin().equals((Object)this.plugin)) continue;
            return meta.value();
        }
        return null;
    }

    public Object getConnection(Player player) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getHandle = player.getClass().getMethod("getHandle", new Class[0]);
        Object nmsPlayer = getHandle.invoke((Object)player, new Object[0]);
        Field conField = nmsPlayer.getClass().getField("playerConnection");
        Object con = conField.get(nmsPlayer);
        return con;
    }

    public int getDayFromMili(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).plusHours(AdvancedCorePlugin.getInstance().getOptions().getTimeHourOffSet()).getDayOfMonth();
    }

    public Enchantment getEnchant(String enchant, String enchant2) {
        try {
            Enchantment ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant.toLowerCase()));
            if (ench != null) {
                return ench;
            }
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant2.toLowerCase()));
        }
        catch (Exception e) {
            this.plugin.debug(e);
            for (Enchantment ench : Enchantment.values()) {
                if (!ench.toString().equalsIgnoreCase(enchant) && !ench.toString().equalsIgnoreCase(enchant2)) continue;
                return ench;
            }
            return null;
        }
    }

    public Object getEntityMeta(Entity entity, String str) {
        for (MetadataValue meta : entity.getMetadata(str)) {
            if (!meta.getOwningPlugin().equals((Object)this.plugin)) continue;
            return meta.value();
        }
        return null;
    }

    public EntityType getEntityType(String entity, String entity2) {
        try {
            return EntityType.valueOf((String)entity);
        }
        catch (Exception e) {
            return EntityType.valueOf((String)entity2);
        }
    }

    public int getHourFromMili(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).plusHours(AdvancedCorePlugin.getInstance().getOptions().getTimeHourOffSet()).getHour();
    }

    public int getMinutesFromMili(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).plusHours(AdvancedCorePlugin.getInstance().getOptions().getTimeHourOffSet()).getMinute();
    }

    public int getMonthFromMili(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).plusHours(AdvancedCorePlugin.getInstance().getOptions().getTimeHourOffSet()).getMonthValue();
    }

    public String getMonthString(int month) {
        return new DateFormatSymbols().getMonths()[month];
    }

    public PotionEffectType getPotionType(String potion, String potion2) {
        try {
            return PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)potion));
        }
        catch (Exception e) {
            return PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)potion2));
        }
    }

    public String getProgressBar(int current, int max, int totalBars, String symbol, String completedColor, String notCompletedColor) {
        int i;
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        int leftOver = totalBars - progressBars;
        StringBuilder sb = new StringBuilder();
        sb.append(ChatColor.translateAlternateColorCodes((char)'&', (String)completedColor));
        for (i = 0; i < progressBars; ++i) {
            sb.append(symbol);
        }
        sb.append(ChatColor.translateAlternateColorCodes((char)'&', (String)notCompletedColor));
        for (i = 0; i < leftOver; ++i) {
            sb.append(symbol);
        }
        return sb.toString();
    }

    public List<Block> getRegionBlocks(World world, Location loc1, Location loc2) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double x = loc1.getX(); x <= loc2.getX(); x += 1.0) {
            for (double y = loc1.getY(); y <= loc2.getY(); y += 1.0) {
                for (double z = loc1.getZ(); z <= loc2.getZ(); z += 1.0) {
                    Location loc = new Location(world, x, y, z);
                    blocks.add(loc.getBlock());
                }
            }
        }
        return blocks;
    }

    public LocalDateTime getTime(long mills) {
        return Instant.ofEpochMilli(mills).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public ArrayList<String> getWorldNames() {
        ArrayList<String> worlds = new ArrayList<String>();
        for (World w : Bukkit.getWorlds()) {
            worlds.add(w.getName());
        }
        return worlds;
    }

    public int getYearFromMili(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).getYear();
    }

    private void runConsoleCommand(final String command, int delay, boolean hasDelay) {
        if (hasDelay && delay > 0) {
            this.plugin.getBukkitScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
                }
            }, delay);
        } else {
            this.plugin.getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
                }
            });
        }
    }

    public void setBlockMeta(Block block, String str, final Object value) {
        block.removeMetadata(str, (Plugin)this.plugin);
        block.setMetadata(str, new MetadataValue(){

            public boolean asBoolean() {
                return false;
            }

            public byte asByte() {
                return 0;
            }

            public double asDouble() {
                return 0.0;
            }

            public float asFloat() {
                return 0.0f;
            }

            public int asInt() {
                return 0;
            }

            public long asLong() {
                return 0L;
            }

            public short asShort() {
                return 0;
            }

            public String asString() {
                return null;
            }

            public Plugin getOwningPlugin() {
                return MiscUtils.this.plugin;
            }

            public void invalidate() {
            }

            public Object value() {
                return value;
            }
        });
    }

    public void setEntityMeta(Entity entity, String str, final Object value) {
        entity.removeMetadata(str, (Plugin)this.plugin);
        entity.setMetadata(str, new MetadataValue(){

            public boolean asBoolean() {
                return false;
            }

            public byte asByte() {
                return 0;
            }

            public double asDouble() {
                return 0.0;
            }

            public float asFloat() {
                return 0.0f;
            }

            public int asInt() {
                return 0;
            }

            public long asLong() {
                return 0L;
            }

            public short asShort() {
                return 0;
            }

            public String asString() {
                return null;
            }

            public Plugin getOwningPlugin() {
                return MiscUtils.this.plugin;
            }

            public void invalidate() {
            }

            public Object value() {
                return value;
            }
        });
    }

    public ItemStack setSkullOwner(OfflinePlayer player) {
        if (player.hasPlayedBefore() || player.isOnline() || Bukkit.getOnlineMode()) {
            return new ItemBuilder("PLAYER_HEAD").setSkullOwner(player).toItemStack(player);
        }
        return this.setSkullOwner(player.getName());
    }

    @Deprecated
    public ItemStack setSkullOwner(String playerName) {
        return new ItemBuilder("PLAYER_HEAD").setSkullOwner(playerName).toItemStack();
    }

    public LinkedHashMap<Double, String> sortByKeys(LinkedHashMap<Double, String> topVoterAllTime, final boolean order) {
        LinkedList<Map.Entry<Double, String>> list = new LinkedList<Map.Entry<Double, String>>(topVoterAllTime.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Double, String>>(){

            @Override
            public int compare(Map.Entry<Double, String> o1, Map.Entry<Double, String> o2) {
                if (order) {
                    return o1.getKey().compareTo(o2.getKey());
                }
                return o2.getKey().compareTo(o1.getKey());
            }
        });
        LinkedHashMap<Double, String> sortedMap = new LinkedHashMap<Double, String>();
        for (Map.Entry entry : list) {
            sortedMap.put((Double)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }

    public HashMap<AdvancedCoreUser, Integer> sortByValues(HashMap<AdvancedCoreUser, Integer> unsortMap, final boolean order) {
        LinkedList<Map.Entry<AdvancedCoreUser, Integer>> list = new LinkedList<Map.Entry<AdvancedCoreUser, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<AdvancedCoreUser, Integer>>(){

            @Override
            public int compare(Map.Entry<AdvancedCoreUser, Integer> o1, Map.Entry<AdvancedCoreUser, Integer> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<AdvancedCoreUser, Integer> sortedMap = new LinkedHashMap<AdvancedCoreUser, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((AdvancedCoreUser)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public HashMap<AdvancedCoreUser, Long> sortByValuesLong(HashMap<AdvancedCoreUser, Long> unsortMap, final boolean order) {
        LinkedList<Map.Entry<AdvancedCoreUser, Long>> list = new LinkedList<Map.Entry<AdvancedCoreUser, Long>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<AdvancedCoreUser, Long>>(){

            @Override
            public int compare(Map.Entry<AdvancedCoreUser, Long> o1, Map.Entry<AdvancedCoreUser, Long> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<AdvancedCoreUser, Long> sortedMap = new LinkedHashMap<AdvancedCoreUser, Long>();
        for (Map.Entry entry : list) {
            sortedMap.put((AdvancedCoreUser)entry.getKey(), (Long)entry.getValue());
        }
        return sortedMap;
    }
}

