/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.messages;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.javascript.JavascriptEngine;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlaceholderUtils {
    public static TextComponent parseJson(String msg) {
        TextComponent comp = new TextComponent("");
        if (MessageAPI.contains(msg, "[Text=\"")) {
            String preMessage = "";
            String postMessage = "";
            int startIndex = msg.indexOf("[Text=\"");
            int endIndex = msg.indexOf("\"]");
            int middle = msg.indexOf("\",", startIndex);
            preMessage = msg.substring(0, startIndex);
            postMessage = msg.substring(endIndex + "\"]".length());
            int postText = startIndex + "[Text=\"".length();
            String text = MessageAPI.colorize(msg.substring(postText, middle));
            TextComponent t = new TextComponent(text);
            String typeMsg = msg;
            boolean parsing = true;
            while (parsing) {
                int nextTypeIndex = typeMsg.indexOf("\",");
                int typeMiddle = typeMsg.indexOf("=\"", nextTypeIndex);
                String type = typeMsg.substring(nextTypeIndex + "\",".length(), typeMiddle);
                int typeEndIndex = typeMsg.indexOf("\",", typeMiddle);
                int endIndex1 = typeMsg.indexOf("\"]");
                if (typeEndIndex == -1 || typeEndIndex > endIndex1) {
                    typeEndIndex = endIndex1;
                    parsing = false;
                }
                String typeData = typeMsg.substring(typeMiddle + "=\"".length(), typeEndIndex);
                if (parsing) {
                    typeMsg = typeMsg.substring(typeEndIndex);
                }
                if (type.equalsIgnoreCase("hover")) {
                    BaseComponent[] hoverContent = TextComponent.fromLegacyText((String)typeData);
                    t.setHoverEvent(MessageAPI.getHoverEventSupport().createHoverEvent(hoverContent));
                    continue;
                }
                if (type.equalsIgnoreCase("command")) {
                    t.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, typeData));
                    continue;
                }
                if (type.equalsIgnoreCase("url")) {
                    t.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, typeData));
                    continue;
                }
                if (!type.equalsIgnoreCase("suggest_command")) continue;
                t.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, typeData));
            }
            comp.addExtra((BaseComponent)PlaceholderUtils.parseJson(preMessage));
            comp.addExtra((BaseComponent)t);
            comp.addExtra((BaseComponent)PlaceholderUtils.parseJson(postMessage));
        } else {
            comp.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)msg)));
        }
        return comp;
    }

    public static String parseText(Player player, String str) {
        return PlaceholderUtils.parseText(player, str, null);
    }

    public static String parseText(Player player, String str, HashMap<String, String> placeholders) {
        if (placeholders != null) {
            str = PlaceholderUtils.replacePlaceHolder(str, placeholders);
        }
        str = PlaceholderUtils.replacePlaceHolders(player, str);
        str = PlaceholderUtils.replaceJavascript(player, str);
        return MessageAPI.colorize(str);
    }

    public static String parseText(String str) {
        return PlaceholderUtils.parseText(str, null);
    }

    public static String parseText(String str, HashMap<String, String> placeholders) {
        if (placeholders != null) {
            str = PlaceholderUtils.replacePlaceHolder(str, placeholders);
        }
        str = PlaceholderUtils.replaceJavascript(str);
        return MessageAPI.colorize(str);
    }

    public static ArrayList<String> replaceJavascript(AdvancedCoreUser user, ArrayList<String> list) {
        ArrayList<String> msg = new ArrayList<String>();
        for (String str : list) {
            msg.add(PlaceholderUtils.replaceJavascript(user, str));
        }
        return msg;
    }

    public static String replaceJavascript(AdvancedCoreUser user, String text) {
        if (!user.getPlugin().getOptions().isDisableJavascript()) {
            JavascriptEngine engine = new JavascriptEngine().addPlayer(user);
            return PlaceholderUtils.replaceJavascript(text, engine);
        }
        return text;
    }

    public static ArrayList<String> replaceJavascript(ArrayList<String> list) {
        return PlaceholderUtils.replaceJavascript(list, null);
    }

    public static ArrayList<String> replaceJavascript(ArrayList<String> list, JavascriptEngine engine) {
        ArrayList<String> msg = new ArrayList<String>();
        for (String str : list) {
            msg.add(PlaceholderUtils.replaceJavascript(str, engine));
        }
        return msg;
    }

    public static ArrayList<String> replaceJavascript(CommandSender sender, ArrayList<String> list) {
        ArrayList<String> msg = new ArrayList<String>();
        for (String str : list) {
            msg.add(PlaceholderUtils.replaceJavascript(sender, str));
        }
        return msg;
    }

    public static String replaceJavascript(CommandSender player, String text) {
        if (!AdvancedCorePlugin.getInstance().getOptions().isDisableJavascript()) {
            if (player instanceof Player) {
                return PlaceholderUtils.replaceJavascript((Player)player, text);
            }
            JavascriptEngine engine = new JavascriptEngine().addPlayer(player);
            return PlaceholderUtils.replaceJavascript(text, engine);
        }
        return text;
    }

    public static ArrayList<String> replaceJavascript(OfflinePlayer player, ArrayList<String> list) {
        ArrayList<String> msg = new ArrayList<String>();
        for (String str : list) {
            msg.add(PlaceholderUtils.replaceJavascript(player, str));
        }
        return msg;
    }

    public static String replaceJavascript(OfflinePlayer player, String text) {
        if (!AdvancedCorePlugin.getInstance().getOptions().isDisableJavascript()) {
            if (player.isOnline()) {
                return PlaceholderUtils.replaceJavascript(player.getPlayer(), text);
            }
            JavascriptEngine engine = new JavascriptEngine().addPlayer(player);
            return PlaceholderUtils.replaceJavascript(text, engine);
        }
        return text;
    }

    public static ArrayList<String> replaceJavascript(Player player, ArrayList<String> list) {
        ArrayList<String> msg = new ArrayList<String>();
        for (String str : list) {
            msg.add(PlaceholderUtils.replaceJavascript(player, str));
        }
        return msg;
    }

    public static String replaceJavascript(Player player, String text) {
        if (!AdvancedCorePlugin.getInstance().getOptions().isDisableJavascript()) {
            JavascriptEngine engine = new JavascriptEngine().addPlayer(player);
            return PlaceholderUtils.replaceJavascript(PlaceholderUtils.replacePlaceHolders(player, text), engine);
        }
        return text;
    }

    public static String replaceJavascript(String text) {
        return PlaceholderUtils.replaceJavascript(text, null);
    }

    public static String replaceJavascript(String text, JavascriptEngine engine) {
        String msg = "";
        if (MessageAPI.containsIgnorecase(text, "[Javascript=")) {
            if (engine == null) {
                engine = new JavascriptEngine();
            }
            int lastIndex = 0;
            int startIndex = 0;
            int num = 0;
            while (startIndex != -1) {
                startIndex = text.indexOf("[Javascript=", lastIndex);
                int endIndex = -1;
                if (startIndex == -1) continue;
                msg = num != 0 ? msg + text.substring(lastIndex + 1, startIndex) : msg + text.substring(lastIndex, startIndex);
                ++num;
                endIndex = text.indexOf("]", startIndex);
                String str = text.substring(startIndex + "[Javascript=".length(), endIndex);
                String script = engine.getStringValue(str);
                if (script == null) {
                    script = "" + engine.getBooleanValue(str);
                }
                if (script != null) {
                    msg = msg + script;
                }
                lastIndex = endIndex;
            }
            msg = msg + text.substring(lastIndex + 1);
        } else {
            msg = text;
        }
        return msg;
    }

    public static ArrayList<String> replacePlaceHolder(ArrayList<String> list, HashMap<String, String> placeholders) {
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            newList.add(PlaceholderUtils.replacePlaceHolder(list.get(i), placeholders));
        }
        return newList;
    }

    public static String replacePlaceHolder(String str, HashMap<String, String> placeholders) {
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                str = PlaceholderUtils.replacePlaceHolder(str, entry.getKey(), entry.getValue());
            }
        }
        return str;
    }

    public static String replacePlaceHolder(String str, HashMap<String, String> placeholders, boolean ignoreCase) {
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                str = PlaceholderUtils.replacePlaceHolder(str, entry.getKey(), entry.getValue(), ignoreCase);
            }
        }
        return str;
    }

    public static String replacePlaceHolder(String str, String toReplace, String replaceWith) {
        return PlaceholderUtils.replacePlaceHolder(str, toReplace, replaceWith, true);
    }

    public static String replacePlaceHolder(String str, String toReplace, String replaceWith, boolean ignoreCase) {
        if (ignoreCase) {
            return MessageAPI.replaceIgnoreCase(MessageAPI.replaceIgnoreCase(str, "%" + toReplace + "%", replaceWith), "\\{" + toReplace + "\\}", replaceWith);
        }
        str = str.replaceAll("\\{", "%");
        str = str.replaceAll("\\}", "%");
        str = str.replace("%" + toReplace + "%", replaceWith);
        return str;
    }

    public static ArrayList<String> replacePlaceHolders(ArrayList<String> list, Player p) {
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            newList.add(PlaceholderUtils.replacePlaceHolders(p, list.get(i)));
        }
        return newList;
    }

    public static String replacePlaceHolders(OfflinePlayer player, String text) {
        if (player == null) {
            return text;
        }
        if (AdvancedCorePlugin.getInstance().isPlaceHolderAPIEnabled()) {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
        }
        return text;
    }

    public static String replacePlaceHolders(Player player, String text) {
        if (player == null) {
            return text;
        }
        if (AdvancedCorePlugin.getInstance().isPlaceHolderAPIEnabled()) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }
}

