/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.messages;

import com.bencodez.votingplugin.advancedcore.api.javascript.JavascriptEngine;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.HashMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageBuilder {
    private String text;

    public MessageBuilder(String text) {
        this.text = text;
    }

    public MessageBuilder colorize() {
        this.setText(MessageAPI.colorize(this.getText()));
        return this;
    }

    public MessageBuilder parseText() {
        this.replaceJavascript();
        this.colorize();
        return this;
    }

    public MessageBuilder parseText(HashMap<String, String> placeholders) {
        if (placeholders != null) {
            this.replacePlaceholder(placeholders);
        }
        this.replaceJavascript();
        this.colorize();
        return this;
    }

    public MessageBuilder parseText(OfflinePlayer player) {
        this.parseText(player, null);
        return this;
    }

    public MessageBuilder parseText(OfflinePlayer player, HashMap<String, String> placeholders) {
        if (placeholders != null) {
            this.replacePlaceholder(placeholders);
        }
        this.replaceJavascript(player);
        this.colorize();
        return this;
    }

    public MessageBuilder parseText(Player player) {
        this.parseText(player, null);
        return this;
    }

    public MessageBuilder parseText(Player player, HashMap<String, String> placeholders) {
        if (placeholders != null) {
            this.replacePlaceholder(placeholders);
        }
        this.replaceJavascript((OfflinePlayer)player);
        this.replacePlaceHolders(player);
        this.colorize();
        return this;
    }

    public MessageBuilder replaceJavascript() {
        this.setText(PlaceholderUtils.replaceJavascript(this.getText()));
        return this;
    }

    public MessageBuilder replaceJavascript(AdvancedCoreUser user) {
        this.setText(PlaceholderUtils.replaceJavascript(user, this.getText()));
        return this;
    }

    public MessageBuilder replaceJavascript(CommandSender sender) {
        this.setText(PlaceholderUtils.replaceJavascript(sender, this.getText()));
        return this;
    }

    public MessageBuilder replaceJavascript(JavascriptEngine engine) {
        this.setText(PlaceholderUtils.replaceJavascript(this.getText(), engine));
        return this;
    }

    public MessageBuilder replaceJavascript(OfflinePlayer player) {
        this.setText(PlaceholderUtils.replaceJavascript(player, this.getText()));
        return this;
    }

    public MessageBuilder replacePlaceholder(HashMap<String, String> placeholders) {
        this.setText(PlaceholderUtils.replacePlaceHolder(this.text, placeholders));
        return this;
    }

    public MessageBuilder replacePlaceholder(HashMap<String, String> placeholders, boolean ignoreCase) {
        this.setText(PlaceholderUtils.replacePlaceHolder(this.text, placeholders, ignoreCase));
        return this;
    }

    public MessageBuilder replacePlaceholder(String toReplace, String replaceWith) {
        this.setText(PlaceholderUtils.replacePlaceHolder(this.text, toReplace, replaceWith));
        return this;
    }

    public MessageBuilder replacePlaceholder(String toReplace, String replaceWith, boolean ignoreCase) {
        this.setText(PlaceholderUtils.replacePlaceHolder(this.text, toReplace, replaceWith, ignoreCase));
        return this;
    }

    public MessageBuilder replacePlaceHolders(Player player) {
        this.setText(PlaceholderUtils.replacePlaceHolders(player, this.getText()));
        return this;
    }

    public String toString() {
        return this.getText();
    }

    public TextComponent toTextComponent() {
        return PlaceholderUtils.parseJson(this.getText());
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }
}

