/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.javascript;

import com.bencodez.votingplugin.simpleapi.nms.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class JavascriptEngineHandler {
    private static JavascriptEngineHandler instance = new JavascriptEngineHandler();
    private boolean builtIn = false;
    private Class<?> factory;
    private Method methodToUse;

    public static JavascriptEngineHandler getInstance() {
        return instance;
    }

    public JavascriptEngineHandler() {
        if (Double.parseDouble(System.getProperty("java.specification.version")) < 15.0) {
            this.builtIn = true;
        } else {
            try {
                this.builtIn = false;
                this.factory = ReflectionUtils.getClassForName("org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory");
                for (Method m : this.factory.getDeclaredMethods()) {
                    if (m.getParameterCount() != 0 || !m.getName().equals("getScriptEngine")) continue;
                    this.methodToUse = m;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ScriptEngine getJSScriptEngine() {
        if (this.builtIn) {
            return new ScriptEngineManager().getEngineByName("js");
        }
        if (this.factory != null) {
            try {
                return (ScriptEngine)this.methodToUse.invoke(this.factory.newInstance(), new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

