/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.javascript;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.javascript.JavascriptEngineHandler;
import com.bencodez.votingplugin.advancedcore.api.javascript.JavascriptPlaceholderRequest;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JavascriptEngine {
    private HashMap<String, Object> engineAPI = new HashMap();

    public JavascriptEngine addPlayer(AdvancedCoreUser user) {
        this.addToEngine("PlayerName", user.getPlayerName());
        this.addToEngine("PlayerUUID", user.getUUID());
        this.addToEngine("AdvancedCoreUser", user);
        for (JavascriptPlaceholderRequest request : AdvancedCorePlugin.getInstance().getJavascriptEngineRequests()) {
            this.addToEngine(request.getStr(), request.getObject(user.getOfflinePlayer()));
        }
        if (user.isOnline()) {
            return this.addPlayer(user.getPlayer());
        }
        return this;
    }

    public JavascriptEngine addPlayer(CommandSender player) {
        this.addToEngine("CommandSender", player);
        if (player instanceof Player) {
            Player p = (Player)player;
            this.addToEngine("Player", p);
            this.addToEngine("PlayerName", p.getName());
            this.addToEngine("PlayerUUID", p.getUniqueId().toString());
            this.addToEngine("AdvancedCoreUser", AdvancedCorePlugin.getInstance().getUserManager().getUser(p));
            for (JavascriptPlaceholderRequest request : AdvancedCorePlugin.getInstance().getJavascriptEngineRequests()) {
                this.addToEngine(request.getStr(), request.getObject((OfflinePlayer)p));
            }
        } else {
            this.addToEngine("Player", player);
        }
        return this;
    }

    public JavascriptEngine addPlayer(OfflinePlayer player) {
        this.addToEngine("Player", player);
        this.addToEngine("PlayerName", player.getName());
        this.addToEngine("PlayerUUID", player.getUniqueId().toString());
        this.addToEngine("AdvancedCoreUser", AdvancedCorePlugin.getInstance().getUserManager().getUser(player));
        this.addToEngine("CommandSender", player);
        for (JavascriptPlaceholderRequest request : AdvancedCorePlugin.getInstance().getJavascriptEngineRequests()) {
            this.addToEngine(request.getStr(), request.getObject(player));
        }
        if (player.isOnline()) {
            return this.addPlayer(player.getPlayer());
        }
        return this;
    }

    public JavascriptEngine addPlayer(Player player) {
        if (player != null) {
            this.addToEngine("Player", player);
            this.addToEngine("PlayerName", player.getName());
            this.addToEngine("PlayerUUID", player.getUniqueId().toString());
            this.addToEngine("AdvancedCoreUser", AdvancedCorePlugin.getInstance().getUserManager().getUser(player));
            this.addToEngine("CommandSender", player);
            for (JavascriptPlaceholderRequest request : AdvancedCorePlugin.getInstance().getJavascriptEngineRequests()) {
                this.addToEngine(request.getStr(), request.getObject((OfflinePlayer)player));
            }
        }
        return this;
    }

    public JavascriptEngine addToEngine(HashMap<String, Object> engineAPI) {
        if (engineAPI != null && !engineAPI.isEmpty()) {
            this.engineAPI.putAll(engineAPI);
        }
        return this;
    }

    public JavascriptEngine addToEngine(String text, Object ob) {
        this.engineAPI.put(text, ob);
        return this;
    }

    public void execute(String expression) {
        this.getResult(expression);
    }

    public boolean getBooleanValue(String expression) {
        Object result = this.getResult(expression);
        if (result != null) {
            try {
                return (Boolean)result;
            }
            catch (Exception e) {
                AdvancedCorePlugin.getInstance().debug(e);
            }
        }
        return false;
    }

    public Object getResult(String expression) {
        if (!expression.equals("")) {
            ScriptEngine engine = JavascriptEngineHandler.getInstance().getJSScriptEngine();
            if (engine == null) {
                AdvancedCorePlugin.getInstance().debug("Failed to process javascript, engine == null");
                return null;
            }
            engine.put("Bukkit", Bukkit.getServer());
            engine.put("AdvancedCore", (Object)AdvancedCorePlugin.getInstance());
            engine.put("Console", Bukkit.getConsoleSender());
            engine.put("UserManager", AdvancedCorePlugin.getInstance().getUserManager());
            engine.put("RewardHandler", AdvancedCorePlugin.getInstance().getRewardHandler());
            engine.put("MessageAPI", MessageAPI.class);
            this.engineAPI.putAll(AdvancedCorePlugin.getInstance().getJavascriptEngine());
            for (Map.Entry<String, Object> entry : this.engineAPI.entrySet()) {
                engine.put(entry.getKey(), entry.getValue());
            }
            try {
                return engine.eval(expression);
            }
            catch (ScriptException e) {
                AdvancedCorePlugin.getInstance().getLogger().warning("Error occoured while evaluating javascript, turn debug on to see stacktrace: " + e.toString());
                AdvancedCorePlugin.getInstance().debug(e);
            }
        }
        return null;
    }

    public String getStringValue(String expression) {
        try {
            Object result = this.getResult(expression);
            if (result != null) {
                return result.toString();
            }
        }
        catch (Exception e) {
            AdvancedCorePlugin.getInstance().debug(e);
        }
        return "";
    }
}

