/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.item;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.item.ItemModelHandler;
import com.bencodez.votingplugin.advancedcore.api.item.ItemsAdderHandle;
import com.bencodez.votingplugin.advancedcore.api.item.NexoItemHandle;
import com.bencodez.votingplugin.advancedcore.api.javascript.JavascriptEngine;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.nms.NMSManager;
import com.bencodez.votingplugin.simpleapi.skull.SkullCache;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemBuilder {
    private boolean chancePass;
    private boolean checkLoreLength;
    private boolean conditional;
    private ConfigurationSection conditionalValues;
    private List<Integer> fillSlots;
    private ItemStack is;
    private String javascriptConditional;
    private boolean legacy;
    private int loreLength;
    private String path;
    private String identifier;
    private HashMap<String, String> placeholders;
    private String skull;
    private int slot;
    private boolean fillEmptySlots;
    private boolean validMaterial;
    private boolean closeGUISet;
    private boolean closeGUI;

    public ItemBuilder(ConfigurationSection data) {
        block61: {
            this.chancePass = true;
            this.checkLoreLength = true;
            this.conditional = false;
            this.fillSlots = new ArrayList<Integer>();
            this.javascriptConditional = "";
            this.legacy = false;
            this.loreLength = -1;
            this.placeholders = new HashMap();
            this.skull = "";
            this.slot = -1;
            this.fillEmptySlots = false;
            this.validMaterial = true;
            this.closeGUISet = false;
            this.closeGUI = true;
            if (data == null) {
                try {
                    throw new IllegalArgumentException("ConfigurationSection can not be null! You are probably missing a section in your yml file");
                }
                catch (IllegalArgumentException e) {
                    AdvancedCorePlugin.getInstance().getLogger().warning("Error occurred while obtaining item, turn debug on to see full stacktrace: " + e.toString());
                    AdvancedCorePlugin.getInstance().debug(e);
                    this.setBlank();
                    break block61;
                }
            }
            this.path = data.getCurrentPath();
            this.identifier = data.getName();
            double chance = data.getDouble("Chance", 100.0);
            if (this.checkChance(chance)) {
                this.chancePass = true;
                this.javascriptConditional = data.getString("ConditionalJavascript", "");
                if (!this.javascriptConditional.isEmpty()) {
                    this.conditional = true;
                    this.conditionalValues = data.getConfigurationSection("Conditional");
                    this.is = new ItemStack(Material.STONE);
                    this.slot = data.getInt("Slot", -1);
                    this.fillSlots = data.getIntegerList("FillSlots");
                    this.fillEmptySlots = data.getBoolean("FillEmptySlots");
                    if (data.isBoolean("CloseGUI")) {
                        this.closeGUISet = true;
                        this.closeGUI = data.getBoolean("CloseGUI", true);
                    } else {
                        this.closeGUISet = false;
                    }
                } else {
                    if (data.isConfigurationSection("ItemStack")) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (String key : data.getConfigurationSection("ItemStack").getKeys(false)) {
                            map.put(key, data.get("ItemStack." + key));
                        }
                        this.is = ItemStack.deserialize(map);
                    } else if (!data.getString("ItemsAdder", "").isEmpty() || !data.getString("Nexo", "").isEmpty()) {
                        ItemStack item;
                        if (!data.getString("ItemsAdder", "").isEmpty() && Bukkit.getPluginManager().getPlugin("ItemsAdder") != null) {
                            item = new ItemsAdderHandle().getItem(data.getString("ItemsAdder"));
                            if (item != null) {
                                this.is = item;
                            }
                        } else if (!data.getString("Nexo", "").isEmpty() && Bukkit.getPluginManager().getPlugin("Nexo") != null) {
                            item = new NexoItemHandle().getItem(data.getString("Nexo"));
                            if (item != null) {
                                this.is = item;
                            }
                        } else {
                            this.is = new ItemStack(Material.STONE);
                        }
                        List lore = data.getStringList("Lore");
                        String name = data.getString("Name");
                        if (name != null && !name.equals("")) {
                            this.setName(name);
                        }
                        if (lore != null && lore.size() > 0) {
                            this.setLore(lore);
                        } else {
                            String line = data.getString("Lore", "");
                            if (!line.equals("")) {
                                this.addLoreLine(line);
                            }
                        }
                        int amount = data.getInt("Amount");
                        int minAmount = data.getInt("MinAmount");
                        int maxAmount = data.getInt("MaxAmount");
                        int currentAmount = 0;
                        currentAmount = amount > 0 ? amount : ThreadLocalRandom.current().nextInt(minAmount, maxAmount + 1);
                        this.is.setAmount(currentAmount);
                    } else {
                        String name;
                        String textureUUID;
                        String textureURL;
                        String texture;
                        Material material = null;
                        List lore = data.getStringList("Lore");
                        String materialStr = data.getString("Material", data.getName());
                        if (NMSManager.getInstance().isVersion("1.12")) {
                            if (materialStr.equalsIgnoreCase("player_head")) {
                                materialStr = "SKULL";
                            } else if (materialStr.equalsIgnoreCase("CLOCK")) {
                                materialStr = "WATCH";
                            } else if (materialStr.equalsIgnoreCase("OAK_SIGN")) {
                                materialStr = "SIGN";
                            } else if (materialStr.equalsIgnoreCase("BLACK_STAINED_GLASS_PANE")) {
                                materialStr = "STAINED_GLASS_PANE";
                            }
                        }
                        try {
                            material = Material.matchMaterial((String)materialStr.toUpperCase());
                            if (material == null && (material = Material.matchMaterial((String)materialStr, (boolean)true)) != null) {
                                AdvancedCorePlugin.getInstance().getLogger().warning("Found legacy material name: " + materialStr + ", please update this to prevent this message and prevent issues, path: " + data.getCurrentPath());
                                this.legacy = true;
                            }
                        }
                        catch (NoSuchMethodError e) {
                            material = Material.valueOf((String)materialStr.toUpperCase());
                        }
                        if (material == null) {
                            material = Material.STONE;
                            AdvancedCorePlugin.getInstance().getLogger().warning("Invalid material: " + data.getString("Material"));
                            this.validMaterial = false;
                            lore.add("&cInvalid material: " + material);
                        }
                        int amount = data.getInt("Amount");
                        int minAmount = data.getInt("MinAmount");
                        int maxAmount = data.getInt("MaxAmount");
                        int currentAmount = 0;
                        currentAmount = amount > 0 ? amount : (minAmount >= 0 && maxAmount > 0 ? ThreadLocalRandom.current().nextInt(minAmount, maxAmount + 1) : 1);
                        this.is = new ItemStack(material, currentAmount);
                        int power = data.getInt("Power", -1);
                        if (power > 0) {
                            this.setFireworkPower(power);
                        }
                        this.skull = data.getString("Skull", "");
                        if (!this.skull.equals("") && !this.skull.contains("%")) {
                            this.setSkullOwner(this.skull);
                        }
                        if (!(texture = data.getString("SkullTexture", "")).equals("")) {
                            this.setHeadFromBase64(texture);
                            this.is.setAmount(currentAmount);
                        }
                        if (!(textureURL = data.getString("SkullURL", "")).equals("")) {
                            this.is = SkullCache.getSkullURL(textureURL);
                            this.is.setAmount(currentAmount);
                        }
                        if (!(textureUUID = data.getString("SkullUUID", "")).equals("")) {
                            try {
                                this.is = SkullCache.getSkull(UUID.fromString(textureUUID), "");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            this.is.setAmount(currentAmount);
                        }
                        if ((name = data.getString("Name")) != null && !name.equals("")) {
                            this.setName(name);
                        }
                        if (lore != null && lore.size() > 0) {
                            this.setLore(lore);
                        } else {
                            String line = data.getString("Lore", "");
                            if (!line.equals("")) {
                                this.addLoreLine(line);
                            }
                        }
                        int durability = data.getInt("Durability");
                        if (durability > 0) {
                            this.setDurability((short)durability);
                        }
                        if (data.isConfigurationSection("Enchants")) {
                            HashMap<String, Integer> enchants = new HashMap<String, Integer>();
                            for (String enchant : data.getConfigurationSection("Enchants").getKeys(false)) {
                                enchants.put(enchant, data.getInt("Enchants." + enchant));
                            }
                            this.addEnchantments(enchants);
                        }
                        ArrayList itemFlags = (ArrayList)data.getList("ItemFlags", new ArrayList());
                        for (String flag : itemFlags) {
                            this.addItemFlag(flag);
                        }
                        if (data.getBoolean("Glow")) {
                            this.addGlow();
                        }
                        this.checkLoreLength = data.getBoolean("CheckLoreLength", true);
                        this.loreLength = data.getInt("LoreLength", -1);
                        Color color = null;
                        if (data.isConfigurationSection("PotionColor")) {
                            ConfigurationSection potionColor = data.getConfigurationSection("PotionColor");
                            color = Color.fromRGB((int)potionColor.getInt("Red", 0), (int)potionColor.getInt("Green", 0), (int)potionColor.getInt("Blue", 0));
                        }
                        if (data.isConfigurationSection("Potions")) {
                            for (String pot : data.getConfigurationSection("Potions").getKeys(false)) {
                                PotionEffectType type = PotionEffectType.getByName((String)pot);
                                if (type != null) {
                                    this.addPotionEffect(type, data.getInt("Potions." + pot + ".Duration"), data.getInt("Potions." + pot + ".Amplifier", 1), color);
                                    continue;
                                }
                                AdvancedCorePlugin.getInstance().getLogger().warning("Invalid potion effect type: " + pot);
                            }
                        }
                        if (data.contains("CustomModelData")) {
                            this.setCustomModelData(data.getInt("CustomModelData", -1));
                        }
                        if (data.contains("ItemModel")) {
                            this.is = ItemModelHandler.getItemWithModel(this.is, data.getString("ItemModel"));
                        }
                        this.setUnbreakable(data.getBoolean("Unbreakable", false));
                    }
                    this.slot = data.getInt("Slot", -1);
                    this.fillSlots = data.getIntegerList("FillSlots");
                    this.fillEmptySlots = data.getBoolean("FillEmptySlots");
                    if (data.isBoolean("CloseGUI")) {
                        this.closeGUISet = true;
                        this.closeGUI = data.getBoolean("CloseGUI", true);
                    } else {
                        this.closeGUISet = false;
                    }
                    if (data.getBoolean("HideToolTip", false)) {
                        this.setHideTooltipCompat(this.is, true);
                    }
                }
            } else {
                this.setBlank();
                this.chancePass = false;
            }
        }
    }

    public void setHideTooltipCompat(ItemStack item, boolean hide) {
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        try {
            Method m = ItemMeta.class.getMethod("setHideTooltip", Boolean.TYPE);
            m.invoke((Object)meta, hide);
        }
        catch (NoSuchMethodException e) {
            if (hide) {
                meta.addItemFlags(ItemFlag.values());
            } else {
                meta.removeItemFlags(ItemFlag.values());
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        item.setItemMeta(meta);
    }

    public ItemBuilder(ItemStack is) {
        this.chancePass = true;
        this.checkLoreLength = true;
        this.conditional = false;
        this.fillSlots = new ArrayList<Integer>();
        this.javascriptConditional = "";
        this.legacy = false;
        this.loreLength = -1;
        this.placeholders = new HashMap();
        this.skull = "";
        this.slot = -1;
        this.fillEmptySlots = false;
        this.validMaterial = true;
        this.closeGUISet = false;
        this.closeGUI = true;
        this.is = is;
    }

    public ItemBuilder(Material m) {
        this(m, 1);
    }

    public ItemBuilder(Material material, int amount) {
        this.chancePass = true;
        this.checkLoreLength = true;
        this.conditional = false;
        this.fillSlots = new ArrayList<Integer>();
        this.javascriptConditional = "";
        this.legacy = false;
        this.loreLength = -1;
        this.placeholders = new HashMap();
        this.skull = "";
        this.slot = -1;
        this.fillEmptySlots = false;
        this.validMaterial = true;
        this.closeGUISet = false;
        this.closeGUI = true;
        this.is = new ItemStack(material, amount);
    }

    public ItemBuilder(String material) {
        this.chancePass = true;
        this.checkLoreLength = true;
        this.conditional = false;
        this.fillSlots = new ArrayList<Integer>();
        this.javascriptConditional = "";
        this.legacy = false;
        this.loreLength = -1;
        this.placeholders = new HashMap();
        this.skull = "";
        this.slot = -1;
        this.fillEmptySlots = false;
        this.validMaterial = true;
        this.closeGUISet = false;
        this.closeGUI = true;
        String materialStr = material;
        if (NMSManager.getInstance().isVersion("1.12")) {
            materialStr = material.equalsIgnoreCase("player_head") ? "SKULL" : "PAPER";
        }
        try {
            this.is = new ItemStack(Material.valueOf((String)materialStr));
        }
        catch (Exception e) {
            this.is = new ItemStack(Material.PAPER);
            AdvancedCorePlugin.getInstance().debug("Invalid material: " + material);
        }
    }

    public ItemBuilder addAttributeModifier(Attribute att, AttributeModifier modifier) {
        ItemMeta im = this.is.getItemMeta();
        im.addAttributeModifier(att, modifier);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder addEnchant(Enchantment ench, int level) {
        if (ench != null) {
            if (this.is.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                EnchantmentStorageMeta im = (EnchantmentStorageMeta)this.is.getItemMeta();
                im.addStoredEnchant(ench, level, true);
                this.is.setItemMeta((ItemMeta)im);
            } else {
                this.is.addUnsafeEnchantment(ench, level);
            }
        }
        return this;
    }

    public ItemBuilder addEnchantments(HashMap<String, Integer> enchants) {
        if (enchants == null || enchants.size() == 0) {
            return this;
        }
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (String enchant : enchants.keySet()) {
            try {
                if (!NMSManager.getInstance().isVersion("1.12")) {
                    Enchantment ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant));
                    if (ench == null) {
                        Enchantment[] enchantmentArray = Enchantment.values();
                        int n = enchantmentArray.length;
                        for (int i = 0; i < n; ++i) {
                            Enchantment en = enchantmentArray[i];
                            if (!en.toString().equalsIgnoreCase(enchant)) continue;
                            ench = en;
                        }
                    }
                    if (ench != null) {
                        enchantments.put(ench, enchants.get(enchant));
                        continue;
                    }
                    AdvancedCorePlugin.getInstance().getLogger().warning("Invalid enchantment: " + enchant + ", Path: " + this.path);
                    continue;
                }
                for (Enchantment en : Enchantment.values()) {
                    if (!en.toString().equalsIgnoreCase(enchant)) continue;
                    enchantments.put(en, enchants.get(enchant));
                }
            }
            catch (Exception e) {
                AdvancedCorePlugin.getInstance().getLogger().warning("Failed to add enchantment: " + enchant);
                e.printStackTrace();
            }
        }
        return this.addEnchantments((Map<Enchantment, Integer>)enchantments);
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            this.addEnchant(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ItemBuilder addGlow() {
        ItemMeta meta = this.is.getItemMeta();
        try {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            if (meta.getClass().getMethod("setEnchantmentGlintOverride", Boolean.TYPE) != null) {
                meta.getClass().getMethod("setEnchantmentGlintOverride", Boolean.TYPE).invoke((Object)meta, true);
                this.is.setItemMeta(meta);
                return this;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.is.setItemMeta(meta);
        this.is.addUnsafeEnchantment(MiscUtils.getInstance().getEnchant("LOOTING", "LUCK"), 1);
        return this;
    }

    public ItemBuilder addItemFlag(String flag) {
        try {
            ItemMeta meta = this.is.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag)});
            this.is.setItemMeta(meta);
        }
        catch (Exception ex) {
            AdvancedCorePlugin.getInstance().debug("Invalid flag: " + flag);
        }
        return this;
    }

    public ItemBuilder addLoreLine(String line) {
        ItemMeta im;
        if (line != null && (im = this.is.getItemMeta()) != null) {
            ArrayList<String> lore = new ArrayList<String>();
            if (im.hasLore()) {
                lore = new ArrayList(im.getLore());
            }
            for (String str : line.split("%NewLine%")) {
                lore.add(str);
            }
            this.setLore(lore);
        }
        return this;
    }

    public ItemBuilder addLoreLine(String line, int pos) {
        ItemMeta im = this.is.getItemMeta();
        if (im != null) {
            ArrayList<String> lore = new ArrayList<String>(im.getLore());
            lore.set(pos, line);
            return this.setLore(lore);
        }
        return this;
    }

    public ItemBuilder addPlaceholder(HashMap<String, String> placeholders) {
        if (placeholders != null) {
            this.placeholders.putAll(placeholders);
        }
        return this;
    }

    public ItemBuilder addPlaceholder(String toReplace, String replaceWith) {
        this.placeholders.put(toReplace, replaceWith);
        return this;
    }

    public ItemBuilder addPotionEffect(PotionEffectType type, int duration, int amplifier, Color color) {
        PotionMeta meta = (PotionMeta)this.is.getItemMeta();
        meta.addCustomEffect(new PotionEffect(type, duration, amplifier), false);
        if (color != null) {
            meta.setColor(color);
        }
        this.is.setItemMeta((ItemMeta)meta);
        return this;
    }

    private boolean checkChance(double chance) {
        if (chance == 0.0 || chance == 100.0) {
            return true;
        }
        double randomNum = ThreadLocalRandom.current().nextDouble(100.0);
        return randomNum <= chance;
    }

    private ItemBuilder checkLoreLength() {
        int loreLength = this.getLoreLength();
        ArrayList<String> currentLore = this.getLore();
        ArrayList<String> newLore = new ArrayList<String>();
        for (String lore : currentLore) {
            StringBuilder builder = new StringBuilder();
            int count = 0;
            for (char character : lore.toCharArray()) {
                builder.append(character);
                if (++count <= loreLength || character != ' ') continue;
                String str = builder.toString();
                builder = new StringBuilder();
                builder.append(ChatColor.getLastColors((String)str));
                if (!ChatColor.stripColor((String)str).isEmpty()) {
                    newLore.add(str);
                }
                count = 0;
            }
            String s = builder.toString();
            if (ChatColor.stripColor((String)s).isEmpty()) continue;
            newLore.add(builder.toString());
        }
        this.setLore(newLore);
        return this;
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this.is);
    }

    public LinkedHashMap<String, Object> createConfigurationData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("Material", this.is.getType().toString());
        data.put("Amount", this.getAmount());
        if (this.hasCustomDisplayName()) {
            data.put("Name", this.getName());
        }
        if (this.hasCustomLore()) {
            data.put("Lore", this.getLore());
        }
        data.put("Durability", this.is.getDurability());
        data.put("Data", this.is.getData().getData());
        for (Map.Entry en : this.is.getItemMeta().getEnchants().entrySet()) {
            data.put("Enchants." + ((Enchantment)en.getKey()).getName(), en.getValue());
        }
        ArrayList<String> flags = new ArrayList<String>();
        for (ItemFlag fl : this.is.getItemMeta().getItemFlags()) {
            flags.add(fl.toString());
        }
        data.put("ItemFlags", flags);
        data.put("Unbreakable", this.is.getItemMeta().isUnbreakable());
        data.put("Skull", this.getSkull());
        return data;
    }

    public ItemBuilder dontCheckLoreLength() {
        this.checkLoreLength = false;
        return this;
    }

    public boolean equals(Object ob) {
        if (ob instanceof ItemBuilder) {
            ItemBuilder b = (ItemBuilder)ob;
            return b.toItemStack().equals((Object)this.toItemStack());
        }
        return false;
    }

    private int getAmount() {
        return this.is.getAmount();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.is.getItemMeta().getAttributeModifiers();
    }

    public Collection<AttributeModifier> getAttributeModifiers(Attribute att) {
        return this.is.getItemMeta().getAttributeModifiers(att);
    }

    public ItemBuilder getConditionItemBuilder(OfflinePlayer player) {
        return this.setConditional(new JavascriptEngine().addPlayer(player));
    }

    public Map<String, Object> getConfiguration(boolean deseralize) {
        if (deseralize) {
            return this.is.serialize();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Material", this.is.getType().toString());
        map.put("Amount", this.is.getAmount());
        if (this.hasCustomDisplayName()) {
            map.put("Name", this.getName());
        }
        if (this.hasCustomLore()) {
            map.put("Lore", this.getLore());
        }
        ItemMeta im = this.is.getItemMeta();
        for (Map.Entry entry : im.getEnchants().entrySet()) {
            map.put("Enchants." + ((Enchantment)entry.getKey()).getKeyOrThrow().getKey(), (Integer)entry.getValue());
        }
        ArrayList<String> flagList = new ArrayList<String>();
        for (ItemFlag flag : im.getItemFlags()) {
            flagList.add(flag.toString());
        }
        map.put("ItemFlags", flagList);
        if (im.hasCustomModelData()) {
            map.put("CustomModelData", im.getCustomModelData());
        }
        if (this.hasGetItemModel(im)) {
            map.put("ItemModel", ItemModelHandler.getModel(this.is));
        }
        return map;
    }

    public boolean hasGetItemModel(ItemMeta meta) {
        try {
            Method method = meta.getClass().getMethod("getItemModel", new Class[0]);
            return method != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public String getCustomData(String key) {
        NamespacedKey namespace = new NamespacedKey((Plugin)AdvancedCorePlugin.getInstance(), key);
        ItemMeta itemMeta = this.is.getItemMeta();
        PersistentDataContainer tagContainer = itemMeta.getPersistentDataContainer();
        if (tagContainer.has(namespace, PersistentDataType.STRING)) {
            return (String)tagContainer.get(namespace, PersistentDataType.STRING);
        }
        return null;
    }

    public ArrayList<String> getLore() {
        if (this.hasCustomLore()) {
            List lore = this.is.getItemMeta().getLore();
            ArrayList<String> list = new ArrayList<String>();
            if (lore != null) {
                list.addAll(lore);
            }
            return list;
        }
        return new ArrayList<String>();
    }

    public int getLoreLength() {
        if (this.loreLength < 0) {
            return AdvancedCorePlugin.getInstance().getOptions().getNewLoreLength();
        }
        return this.loreLength;
    }

    public String getName() {
        if (this.hasCustomDisplayName()) {
            return this.is.getItemMeta().getDisplayName();
        }
        return "";
    }

    public String getRewardsPath(Player player) {
        if (this.conditional) {
            JavascriptEngine engine = new JavascriptEngine().addPlayer(player);
            String value = engine.getStringValue(this.javascriptConditional);
            return "Conditional." + value + ".Rewards";
        }
        return "Rewards";
    }

    @Deprecated
    public String getSkull() {
        try {
            SkullMeta im = (SkullMeta)this.is.getItemMeta();
            if (im.hasOwner()) {
                return im.getOwner();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public OfflinePlayer getSkullOwner() {
        try {
            SkullMeta im = (SkullMeta)this.is.getItemMeta();
            if (im.hasOwner()) {
                return im.getOwningPlayer();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public Material getType() {
        return this.is.getType();
    }

    public boolean hasAttributes() {
        return this.is.getItemMeta().hasAttributeModifiers();
    }

    public boolean hasCustomDisplayName() {
        if (this.hasItemMeta()) {
            return this.is.getItemMeta().hasDisplayName();
        }
        return false;
    }

    public boolean hasCustomLore() {
        if (this.hasItemMeta()) {
            return this.is.getItemMeta().hasLore();
        }
        return false;
    }

    public boolean hasItemMeta() {
        return this.is.hasItemMeta();
    }

    public ItemStack parsePlaceholders(OfflinePlayer player) {
        if (player == null) {
            return this.toItemStack();
        }
        this.setName(MessageAPI.colorize(PlaceholderUtils.replaceJavascript(player, PlaceholderUtils.replacePlaceHolder(this.getName(), this.placeholders))));
        this.setLore(ArrayUtils.colorize(PlaceholderUtils.replaceJavascript(player, PlaceholderUtils.replacePlaceHolder(this.getLore(), this.placeholders))));
        if (this.skull.contains("%")) {
            this.setSkullOwner(PlaceholderUtils.replaceJavascript(player, PlaceholderUtils.replacePlaceHolder(this.skull, this.placeholders)));
        }
        return this.is;
    }

    public ItemBuilder removeEnchantment(Enchantment ench) {
        this.is.removeEnchantment(ench);
        return this;
    }

    public ItemBuilder removeLore() {
        this.setLore(new String[0]);
        return this;
    }

    public ItemBuilder removeLoreLine(int index) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList lore = new ArrayList(im.getLore());
        if (index < 0 || index > lore.size()) {
            return this;
        }
        lore.remove(index);
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder removeLoreLine(String line) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList lore = new ArrayList(im.getLore());
        if (!lore.contains(line)) {
            return this;
        }
        lore.remove(line);
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.is.setAmount(amount);
        return this;
    }

    public ItemBuilder setAmountNone(int i) {
        if (this.getAmount() == 0) {
            this.setAmount(i);
        }
        return this;
    }

    private void setBlank() {
        this.is = new ItemStack(Material.STONE);
        this.setAmount(0);
    }

    private ItemBuilder setConditional(JavascriptEngine engine) {
        String value;
        ConfigurationSection data;
        if (this.conditional && (data = this.conditionalValues.getConfigurationSection(value = engine.getStringValue(this.javascriptConditional))) != null) {
            return new ItemBuilder(data);
        }
        return null;
    }

    public ItemBuilder setCustomData(String key, String value) {
        NamespacedKey namespace = new NamespacedKey((Plugin)AdvancedCorePlugin.getInstance(), key);
        ItemMeta itemMeta = this.is.getItemMeta();
        itemMeta.getPersistentDataContainer().set(namespace, PersistentDataType.STRING, (Object)value);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setCustomModelData(int data) {
        ItemMeta im = this.is.getItemMeta();
        im.setCustomModelData(Integer.valueOf(data));
        this.is.setItemMeta(im);
        return this;
    }

    @Deprecated
    public ItemBuilder setDurability(short dur) {
        this.is.setDurability(dur);
        return this;
    }

    @Deprecated
    public ItemBuilder setDyeColor(DyeColor color) {
        this.is.setDurability((short)color.getDyeData());
        return this;
    }

    public ItemBuilder setFireworkPower(int power) {
        try {
            FireworkMeta meta = (FireworkMeta)this.is.getItemMeta();
            meta.setPower(power);
            this.is.setItemMeta((ItemMeta)meta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public ItemBuilder setHeadFromBase64(String value) {
        this.is = SkullCache.getSkullBase64(value);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        ItemMeta meta = this.is.getItemMeta();
        meta.setUnbreakable(true);
        this.is.setItemMeta(meta);
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        try {
            LeatherArmorMeta im = (LeatherArmorMeta)this.is.getItemMeta();
            im.setColor(color);
            this.is.setItemMeta((ItemMeta)im);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : lore) {
            for (String s : str.split("%NewLine%")) {
                list.add(s);
            }
        }
        ItemMeta im = this.is.getItemMeta();
        if (im != null) {
            im.setLore(list);
            this.is.setItemMeta(im);
        }
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        return this.setLore(ArrayUtils.convert(lore));
    }

    public ItemBuilder setLoreLength(int length) {
        this.loreLength = length;
        return this;
    }

    public ItemBuilder setName(String name) {
        ItemMeta im = this.is.getItemMeta();
        if (im != null) {
            im.setDisplayName(name);
            this.is.setItemMeta(im);
        }
        return this;
    }

    public ItemBuilder setNameIfNotExist(String name) {
        if (!this.hasCustomDisplayName()) {
            this.setName(name);
        }
        return this;
    }

    public ItemBuilder setPlaceholders(HashMap<String, String> placeholders) {
        this.placeholders = placeholders;
        return this;
    }

    public ItemBuilder setSkullOwner(OfflinePlayer offlinePlayer) {
        if (offlinePlayer != null) {
            try {
                SkullMeta im = (SkullMeta)this.is.getItemMeta();
                im.setOwningPlayer(offlinePlayer);
                this.is.setItemMeta((ItemMeta)im);
            }
            catch (Exception expected) {
                this.setSkullOwner(offlinePlayer.getName());
            }
        }
        return this;
    }

    @Deprecated
    public ItemBuilder setSkullOwner(String owner) {
        if (owner != null && !owner.isEmpty()) {
            try {
                SkullMeta im = (SkullMeta)this.is.getItemMeta();
                im.setOwner(owner);
                this.is.setItemMeta((ItemMeta)im);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return this;
    }

    public ItemBuilder setSlot(int slot) {
        this.slot = slot;
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        try {
            ItemMeta meta = this.is.getItemMeta();
            if (meta != null) {
                meta.setUnbreakable(unbreakable);
                this.is.setItemMeta(meta);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return this;
    }

    @Deprecated
    public ItemStack toItemStack() {
        if (this.conditional) {
            return this.setConditional(new JavascriptEngine()).toItemStack();
        }
        this.setName(MessageAPI.colorize(PlaceholderUtils.replaceJavascript(PlaceholderUtils.replacePlaceHolder(this.getName(), this.placeholders))));
        this.setLore(ArrayUtils.colorize(PlaceholderUtils.replaceJavascript(PlaceholderUtils.replacePlaceHolder(this.getLore(), this.placeholders))));
        if (this.checkLoreLength) {
            this.checkLoreLength();
        }
        return this.is;
    }

    public ItemStack toItemStack(OfflinePlayer player) {
        if (!this.placeholders.containsKey("player")) {
            this.placeholders.put("player", player.getName());
        }
        if (this.conditional) {
            return this.getConditionItemBuilder(player).setPlaceholders(this.placeholders).toItemStack(player);
        }
        this.parsePlaceholders(player);
        if (this.checkLoreLength) {
            this.checkLoreLength();
        }
        return this.is;
    }

    public ItemStack toItemStack(Player player) {
        if (!this.placeholders.containsKey("player")) {
            this.placeholders.put("player", player.getName());
        }
        if (this.conditional) {
            return this.setConditional(new JavascriptEngine().addPlayer(player)).setPlaceholders(this.placeholders).toItemStack(player);
        }
        this.parsePlaceholders((OfflinePlayer)player);
        if (this.checkLoreLength) {
            this.checkLoreLength();
        }
        return this.is;
    }

    public String toString() {
        return this.is.toString();
    }

    @Generated
    public boolean isChancePass() {
        return this.chancePass;
    }

    @Generated
    public void setChancePass(boolean chancePass) {
        this.chancePass = chancePass;
    }

    @Generated
    public boolean isCheckLoreLength() {
        return this.checkLoreLength;
    }

    @Generated
    public void setCheckLoreLength(boolean checkLoreLength) {
        this.checkLoreLength = checkLoreLength;
    }

    @Generated
    public boolean isConditional() {
        return this.conditional;
    }

    @Generated
    public ConfigurationSection getConditionalValues() {
        return this.conditionalValues;
    }

    @Generated
    public List<Integer> getFillSlots() {
        return this.fillSlots;
    }

    @Generated
    public String getJavascriptConditional() {
        return this.javascriptConditional;
    }

    @Generated
    public boolean isLegacy() {
        return this.legacy;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public boolean isFillEmptySlots() {
        return this.fillEmptySlots;
    }

    @Generated
    public boolean isValidMaterial() {
        return this.validMaterial;
    }

    @Generated
    public boolean isCloseGUISet() {
        return this.closeGUISet;
    }

    @Generated
    public boolean isCloseGUI() {
        return this.closeGUI;
    }
}

