/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.item;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FullInventoryHandler {
    private ConcurrentHashMap<UUID, ArrayList<ItemStack>> items = new ConcurrentHashMap();
    private AdvancedCorePlugin plugin;
    private ScheduledExecutorService timer;
    private ConcurrentHashMap<UUID, Long> lastMessageTime = new ConcurrentHashMap();

    public FullInventoryHandler(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
        this.loadTimer();
        this.startup();
    }

    public void add(UUID uuid, ArrayList<ItemStack> item) {
        if (this.items.containsKey(uuid)) {
            ArrayList<ItemStack> current = this.items.get(uuid);
            current.addAll(item);
            this.items.put(null, current);
        } else {
            this.items.put(uuid, item);
        }
    }

    public void add(UUID uuid, ItemStack item) {
        if (this.items.containsKey(uuid)) {
            ArrayList<ItemStack> current = this.items.get(uuid);
            current.add(item);
            this.items.put(uuid, current);
        } else {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(item);
            this.items.put(uuid, itemList);
        }
    }

    public void check() {
        for (UUID entry : this.items.keySet()) {
            Player p = Bukkit.getPlayer((UUID)entry);
            this.check(p);
            if (!this.lastMessageTime.containsKey(entry) || System.currentTimeMillis() - this.lastMessageTime.get(p.getUniqueId()) <= 5000L) continue;
            this.lastMessageTime.remove(entry);
        }
    }

    public void check(Player p) {
        if (p != null && this.items.containsKey(p.getUniqueId())) {
            ArrayList<ItemStack> extra = new ArrayList<ItemStack>();
            for (ItemStack item : this.items.get(p.getUniqueId())) {
                HashMap excess = p.getInventory().addItem(new ItemStack[]{item});
                for (Map.Entry me : excess.entrySet()) {
                    extra.add((ItemStack)me.getValue());
                }
            }
            if (extra.size() == 0) {
                this.items.remove(p.getUniqueId());
            } else {
                this.items.put(p.getUniqueId(), extra);
            }
        }
    }

    public void giveItem(Player p, ItemStack ... item) {
        HashMap excess = p.getInventory().addItem(item);
        boolean full = false;
        boolean dropItems = this.plugin.getOptions().isDropOnFullInv();
        for (Map.Entry me : excess.entrySet()) {
            full = true;
            if (dropItems) {
                p.getWorld().dropItem(p.getLocation(), (ItemStack)me.getValue());
                continue;
            }
            this.add(p.getUniqueId(), (ItemStack)me.getValue());
        }
        if (full) {
            if (this.lastMessageTime.containsKey(p.getUniqueId())) {
                if (System.currentTimeMillis() - this.lastMessageTime.get(p.getUniqueId()) > 5000L) {
                    this.sendMessage(p);
                }
            } else {
                this.sendMessage(p);
            }
        }
        p.updateInventory();
    }

    public void loadTimer() {
        this.timer = Executors.newScheduledThreadPool(1);
        this.timer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FullInventoryHandler.this.check();
            }
        }, 10L, 30L, TimeUnit.SECONDS);
    }

    public void save() {
        try {
            if (this.plugin.getServerDataFile().getData() == null) {
                return;
            }
            for (Map.Entry<UUID, ArrayList<ItemStack>> entry : this.items.entrySet()) {
                ArrayList<ItemStack> items = entry.getValue();
                for (int i = 0; i < items.size(); ++i) {
                    this.plugin.getServerDataFile().setData("FullInventory." + entry.getKey().toString() + ".Items." + i, items.get(i));
                }
                this.plugin.getServerDataFile().setData("FullInventory." + entry.getKey().toString() + ".Time", System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMessage(Player p) {
        String msg = MessageAPI.colorize(AdvancedCorePlugin.getInstance().getOptions().getFormatInvFull());
        if (!msg.isEmpty()) {
            p.sendMessage(msg);
            this.lastMessageTime.put(p.getUniqueId(), System.currentTimeMillis());
        }
    }

    public void startup() {
        try {
            if (this.plugin.getServerDataFile().getData() == null || !this.plugin.getServerDataFile().getData().isConfigurationSection("FullInventory")) {
                return;
            }
            for (String uuid : this.plugin.getServerDataFile().getData().getConfigurationSection("FullInventory").getKeys(false)) {
                long time = this.plugin.getServerDataFile().getData().getLong("FullInventory." + uuid + ".Time");
                if (System.currentTimeMillis() - time >= 86400000L) continue;
                for (String itemnum : this.plugin.getServerDataFile().getData().getConfigurationSection("FullInventory." + uuid + ".Items").getKeys(false)) {
                    this.add(UUID.fromString(uuid), this.plugin.getServerDataFile().getData().getItemStack("FullInventory." + uuid + ".Items." + itemnum));
                }
            }
            this.plugin.getServerDataFile().setData("FullInventory", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Generated
    public ConcurrentHashMap<UUID, ArrayList<ItemStack>> getItems() {
        return this.items;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public ConcurrentHashMap<UUID, Long> getLastMessageTime() {
        return this.lastMessageTime;
    }
}

