/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.inventory;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class UpdatingBInventoryButton
extends BInventoryButton {
    private long delay;
    private long updateInterval;
    private AdvancedCorePlugin plugin;
    private boolean updateOnClick = false;
    private long clickUpdateDelay = 0L;

    public UpdatingBInventoryButton(AdvancedCorePlugin plugin, ItemBuilder item, long delay, long updateInterval) {
        super(item);
        this.plugin = plugin;
        this.updateInterval = updateInterval;
        this.delay = delay;
    }

    public UpdatingBInventoryButton(AdvancedCorePlugin plugin, ItemStack item, long delay, long updateInterval) {
        super(item);
        this.plugin = plugin;
        this.updateInterval = updateInterval;
        this.delay = delay;
    }

    public UpdatingBInventoryButton(AdvancedCorePlugin plugin, String name, String[] lore, ItemStack item, long delay, long updateInterval) {
        super(name, lore, item);
        this.plugin = plugin;
        this.updateInterval = updateInterval;
        this.delay = delay;
    }

    private void checkUpdate(final Player p) {
        if (!this.plugin.isLoadUserData() || this.plugin.getUserManager().getDataManager().isCached(p.getUniqueId())) {
            final ItemStack item = this.onUpdate(p).toItemStack(p);
            if (item != null) {
                if (this.plugin.isEnabled()) {
                    this.plugin.getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (p != null && UpdatingBInventoryButton.this.getInv().isOpen(p)) {
                                    if (UpdatingBInventoryButton.this.getFillSlots() != null && UpdatingBInventoryButton.this.getFillSlots().size() > 0) {
                                        for (Integer slot : UpdatingBInventoryButton.this.getFillSlots()) {
                                            PlayerUtils.getTopInventory(p).setItem(slot.intValue(), item);
                                        }
                                    } else {
                                        PlayerUtils.getTopInventory(p).setItem(UpdatingBInventoryButton.this.getSlot(), item);
                                    }
                                } else {
                                    UpdatingBInventoryButton.this.getInv().cancelTimer();
                                }
                            }
                            catch (Exception e) {
                                UpdatingBInventoryButton.this.plugin.debug(e);
                                UpdatingBInventoryButton.this.getInv().cancelTimer();
                            }
                        }
                    }, (Entity)p);
                } else {
                    this.getInv().cancelTimer();
                }
            } else {
                this.getInv().cancelTimer();
            }
        }
    }

    public UpdatingBInventoryButton delay(long mileseconds) {
        this.clickUpdateDelay = mileseconds;
        return this;
    }

    @Override
    public void load(final Player p) {
        this.getInv().addUpdatingButton(this.plugin, this.delay, this.updateInterval, new Runnable(){

            @Override
            public void run() {
                UpdatingBInventoryButton.this.checkUpdate(p);
            }
        });
    }

    @Override
    public void onClick(final BInventory.ClickEvent event, BInventory inv) {
        super.onClick(event, inv);
        if (this.updateOnClick) {
            if (this.clickUpdateDelay > 0L) {
                this.plugin.getInventoryTimer().schedule(new Runnable(){

                    @Override
                    public void run() {
                        UpdatingBInventoryButton.this.update(event.getPlayer());
                    }
                }, this.clickUpdateDelay, TimeUnit.MILLISECONDS);
            } else {
                this.update(event.getPlayer());
            }
        }
    }

    public abstract ItemBuilder onUpdate(Player var1);

    public void update(final Player p) {
        ItemStack item;
        if ((!this.plugin.isLoadUserData() || this.plugin.getUserManager().getDataManager().isCached(p.getUniqueId())) && (item = this.onUpdate(p).toItemStack(p)) != null && this.plugin.isEnabled()) {
            this.plugin.getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        if (p != null && UpdatingBInventoryButton.this.getInv().isOpen(p)) {
                            if (UpdatingBInventoryButton.this.getFillSlots() != null && UpdatingBInventoryButton.this.getFillSlots().size() > 0) {
                                for (Integer slot : UpdatingBInventoryButton.this.getFillSlots()) {
                                    p.getOpenInventory().getTopInventory().setItem(slot.intValue(), item);
                                }
                            } else {
                                p.getOpenInventory().getTopInventory().setItem(UpdatingBInventoryButton.this.getSlot(), item);
                            }
                        }
                    }
                    catch (Exception e) {
                        UpdatingBInventoryButton.this.plugin.debug(e);
                    }
                }
            }, (Entity)p);
        }
    }

    public UpdatingBInventoryButton updateOnClick() {
        this.updateOnClick = true;
        return this;
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Generated
    public long getUpdateInterval() {
        return this.updateInterval;
    }

    @Generated
    public boolean isUpdateOnClick() {
        return this.updateOnClick;
    }

    @Generated
    public long getClickUpdateDelay() {
        return this.clickUpdateDelay;
    }
}

