/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.inventory;

import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;

public class GUISession
implements InventoryHolder {
    private BInventory inventoryGUI;
    private int page = 1;

    public static GUISession extractSession(Inventory inventory) {
        if (inventory == null) {
            return null;
        }
        InventoryHolder ih = inventory.getHolder();
        if (ih != null && ih instanceof GUISession) {
            return (GUISession)ih;
        }
        return null;
    }

    public static GUISession extractSession(Player player) {
        if (player == null) {
            return null;
        }
        InventoryView oInv = player.getOpenInventory();
        if (oInv == null) {
            return null;
        }
        Inventory inv = PlayerUtils.getTopInventory(player);
        if (inv != null) {
            return GUISession.extractSession(inv);
        }
        return GUISession.extractSession(oInv.getTopInventory());
    }

    public GUISession(BInventory inventoryGUI, int page) {
        if (inventoryGUI == null) {
            throw new IllegalArgumentException("InventoryGUI must not be null");
        }
        this.inventoryGUI = inventoryGUI;
        this.page = page;
    }

    public Inventory getInventory() {
        return null;
    }

    public BInventory getInventoryGUI() {
        return this.inventoryGUI;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("Page must be >= 1");
        }
        this.page = page;
    }
}

