/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.inventory;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.GUISession;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BInventoryListener
implements Listener {
    private AdvancedCorePlugin plugin;

    public BInventoryListener(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClick(final InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        this.plugin.getBukkitScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (player.getInventory().firstEmpty() != -1) {
                    BInventoryListener.this.plugin.getFullInventoryHandler().check(player);
                }
            }
        });
        final GUISession session = GUISession.extractSession(player);
        if (session == null) {
            return;
        }
        final BInventory gui = session.getInventoryGUI();
        event.setCancelled(true);
        event.setResult(Event.Result.DENY);
        if (event.getClickedInventory() != null && event.getClickedInventory().getType() == InventoryType.CHEST) {
            long cTime;
            if (event.isShiftClick() && event.getClickedInventory() != null && event.getRawSlot() < event.getInventory().getSize()) {
                event.setCurrentItem(new ItemStack(Material.AIR));
            }
            player.setItemOnCursor(new ItemStack(Material.AIR));
            player.updateInventory();
            if (this.plugin.getOptions().isCloseGUIOnShiftClick()) {
                gui.forceClose(player);
            }
            if (gui.isCloseInv()) {
                gui.closeInv(player, null);
            }
            if ((cTime = System.currentTimeMillis()) - gui.getLastPressTime() < (long)this.plugin.getOptions().getSpamClickTime()) {
                this.plugin.debug(player.getName() + " spam clicking GUI, preventing exploits");
                player.updateInventory();
                event.setCurrentItem(new ItemStack(Material.AIR));
                gui.forceClose(player);
                String msg = this.plugin.getOptions().getSpamClickMessage();
                if (!msg.isEmpty()) {
                    player.sendMessage(MessageAPI.colorize(msg));
                }
                return;
            }
            gui.setLastPressTime(cTime);
            this.plugin.getBukkitScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    int slot = event.getSlot();
                    if (!gui.isPages()) {
                        for (int buttonSlot : gui.getButtons().keySet()) {
                            BInventoryButton button = gui.getButtons().get(buttonSlot);
                            if (slot != buttonSlot) continue;
                            gui.closeInv(player, button);
                            try {
                                gui.onClick(event, button);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        int nextPage;
                        int maxInvSize = gui.getMaxInvSize();
                        int page = session.getPage();
                        int maxPage = gui.getMaxPage();
                        if (slot < maxInvSize - 9) {
                            int buttonSlot = (page - 1) * (maxInvSize - 9) + event.getSlot();
                            BInventoryButton button = gui.getButtons().get(buttonSlot);
                            if (button != null) {
                                gui.closeInv(player, button);
                                try {
                                    gui.onClick(event, button);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                return;
                            }
                        } else if (slot == maxInvSize - 9) {
                            if (page > 1) {
                                nextPage = page - 1;
                                gui.playSound(player);
                                gui.openInventory(player, nextPage);
                            }
                        } else if (slot == maxInvSize - 1 && maxPage > page) {
                            nextPage = page + 1;
                            gui.playSound(player);
                            gui.openInventory(player, nextPage);
                        }
                        for (BInventoryButton b : gui.getPageButtons()) {
                            if (slot != b.getSlot() + (gui.getMaxInvSize() - 9)) continue;
                            gui.closeInv(player, b);
                            try {
                                gui.onClick(event, b);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return;
                        }
                    }
                }
            });
        }
    }
}

