/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.inventory;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class BInventoryButton {
    private ItemBuilder builder;
    private boolean closeInv = true;
    private boolean closeInvSet = false;
    private HashMap<String, Object> data = new HashMap();
    private List<Integer> fillSlots;
    private BInventory inv;
    private int slot = -1;
    private boolean fillEmptySlots = false;

    public BInventoryButton(BInventoryButton button) {
        this.setBuilder(button.getBuilder());
        this.slot = button.getSlot();
        this.fillSlots = button.getFillSlots();
    }

    public BInventoryButton(ItemBuilder item) {
        this.setBuilder(item);
        this.slot = item.getSlot();
        this.fillSlots = item.getFillSlots();
        this.fillEmptySlots = item.isFillEmptySlots();
        if (item.isCloseGUISet()) {
            this.closeInv = item.isCloseGUI();
            this.closeInvSet = true;
        }
    }

    public BInventoryButton(ItemStack item) {
        this.setBuilder(new ItemBuilder(item));
    }

    public BInventoryButton(String name, String[] lore, ItemStack item) {
        this.setBuilder(new ItemBuilder(item).setName(name).setLore(lore));
    }

    public BInventoryButton addData(String key, Object object) {
        this.getData().put(key, object);
        return this;
    }

    public BInventoryButton dontClose() {
        this.closeInv = false;
        return this;
    }

    public ItemBuilder getBuilder() {
        return this.builder;
    }

    public BInventoryButton getButton() {
        return this;
    }

    public HashMap<String, Object> getData() {
        return this.data;
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public Object getData(String key, Object defaultValue) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return defaultValue;
    }

    @Deprecated
    public ItemStack getItem() {
        return this.builder.toItemStack();
    }

    public ItemStack getItem(Player player) {
        return this.builder.toItemStack(player);
    }

    public ItemStack getItem(Player player, HashMap<String, String> placeholders) {
        return this.builder.addPlaceholder(placeholders).toItemStack(player);
    }

    public String getLastRewardsPath(Player player) {
        String test = this.builder.getRewardsPath(player);
        return test;
    }

    public Object getMeta(Player player, String str) {
        return PlayerUtils.getPlayerMeta(AdvancedCorePlugin.getInstance(), player, str);
    }

    public int getSlot() {
        return this.slot;
    }

    public void load(Player p) {
    }

    public abstract void onClick(BInventory.ClickEvent var1);

    public void onClick(BInventory.ClickEvent event, BInventory inv) {
        this.inv = inv;
        this.onClick(event);
    }

    public void sendMessage(Player player, String msg) {
        player.sendMessage(MessageAPI.colorize(msg));
    }

    public void setBuilder(ItemBuilder builder) {
        this.builder = builder;
    }

    public BInventoryButton setCloseInv(boolean value) {
        this.closeInv = value;
        this.closeInvSet = true;
        return this;
    }

    public void setItem(ItemBuilder builder) {
        this.builder = builder;
    }

    public void setItem(ItemStack item) {
        this.builder = new ItemBuilder(item);
    }

    public void setMeta(Player player, String str, Object ob) {
        PlayerUtils.setPlayerMeta(AdvancedCorePlugin.getInstance(), player, str, ob);
    }

    public BInventoryButton setSlot(int slot) {
        this.slot = slot;
        return this;
    }

    @Generated
    public boolean isCloseInv() {
        return this.closeInv;
    }

    @Generated
    public boolean isCloseInvSet() {
        return this.closeInvSet;
    }

    @Generated
    public List<Integer> getFillSlots() {
        return this.fillSlots;
    }

    @Generated
    public BInventory getInv() {
        return this.inv;
    }

    @Generated
    public void setInv(BInventory inv) {
        this.inv = inv;
    }

    @Generated
    public boolean isFillEmptySlots() {
        return this.fillEmptySlots;
    }
}

