/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.inventory;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.GUISession;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BInventory {
    private Map<Integer, BInventoryButton> buttons = new HashMap<Integer, BInventoryButton>();
    private boolean closeInv = true;
    private HashMap<String, Object> data = new HashMap();
    private Inventory inv;
    private String inventoryName;
    private long lastPressTime = 0L;
    private int maxInvSize = 54;
    private int maxPage = 1;
    private ItemStack nextItem;
    private int page = 1;
    private ArrayList<BInventoryButton> pageButtons = new ArrayList();
    private boolean pages = false;
    private String perm;
    private HashMap<String, String> placeholders = new HashMap();
    private boolean playerSound = true;
    private ItemStack prevItem;
    ArrayList<ScheduledFuture> futures;
    private ArrayList<BInventoryButton> fillItems = new ArrayList();

    public static void openInventory(Player player, BInventory inventory) {
        inventory.openInventory(player);
    }

    public BInventory(String name) {
        this.setInventoryName(name);
    }

    public void addButton(final BInventoryButton button) {
        int slot = button.getSlot();
        if (slot == -1) {
            slot = this.getNextSlot();
        }
        if (slot == -2) {
            slot = this.getProperSize(this.getNextSlot()) - 1;
        }
        if (!button.isFillEmptySlots()) {
            if (button.getFillSlots() != null && button.getFillSlots().size() > 0) {
                for (Integer fill : button.getFillSlots()) {
                    slot = fill;
                    BInventoryButton button1 = new BInventoryButton(button){

                        @Override
                        public void onClick(ClickEvent clickEvent) {
                            button.onClick(clickEvent);
                        }
                    };
                    button1.setSlot(slot);
                    this.getButtons().put(slot, button1);
                }
            } else {
                button.setSlot(slot);
                this.getButtons().put(slot, button);
            }
        } else {
            this.fillItems.add(button);
        }
    }

    public boolean isSlotTaken(int slot) {
        return this.buttons.containsKey(slot);
    }

    public void addButton(int position, BInventoryButton button) {
        this.getButtons().put(position, button);
    }

    public BInventory addData(String key, Object object) {
        this.getData().put(key, object);
        return this;
    }

    private void addFillSlots() {
        for (final BInventoryButton button : this.fillItems) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                boolean slotExist = false;
                for (Integer exist : this.getButtons().keySet()) {
                    if (exist != i) continue;
                    slotExist = true;
                }
                if (slotExist) continue;
                BInventoryButton button1 = new BInventoryButton(button){

                    @Override
                    public void onClick(ClickEvent clickEvent) {
                        button.onClick(clickEvent);
                    }
                };
                button1.setSlot(i);
                this.getButtons().put(i, button1);
            }
        }
        this.fillItems.clear();
    }

    public BInventory addPlaceholder(String toReplace, String replaceWith) {
        this.placeholders.put(toReplace, replaceWith);
        return this;
    }

    public void addUpdatingButton(AdvancedCorePlugin plugin, long delay, long interval, Runnable runnable) {
        if (this.futures == null) {
            this.futures = new ArrayList();
        }
        this.futures.add(plugin.getInventoryTimer().scheduleWithFixedDelay(runnable, delay, delay, TimeUnit.MILLISECONDS));
    }

    public void cancelTimer() {
        if (this.futures != null) {
            for (ScheduledFuture f : this.futures) {
                f.cancel(true);
            }
            this.futures = null;
        }
    }

    public void closeInv(Player p, BInventoryButton b) {
        if (!PlayerUtils.getTopInventory(p).equals(this.inv)) {
            return;
        }
        if (this.pages || this.closeInv && (b == null || !b.isCloseInvSet())) {
            this.forceClose(p);
            return;
        }
        if (b != null && b.isCloseInvSet() && b.isCloseInv()) {
            this.forceClose(p);
            return;
        }
    }

    private void closeUpdatingBInv() {
        this.cancelTimer();
    }

    public BInventory dontClose() {
        this.closeInv = false;
        return this;
    }

    public void forceClose(final Player p) {
        if (Bukkit.isPrimaryThread()) {
            p.closeInventory();
            AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskAsynchronously((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BInventory.this.closeUpdatingBInv();
                }
            });
        } else {
            this.closeUpdatingBInv();
            AdvancedCorePlugin.getInstance().getBukkitScheduler().runTask((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    p.closeInventory();
                }
            }, (Entity)p);
        }
    }

    public Map<Integer, BInventoryButton> getButtons() {
        return this.buttons;
    }

    public HashMap<String, Object> getData() {
        return this.data;
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public Object getData(String key, Object defaultValue) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return defaultValue;
    }

    public int getFirstEmptySlot() {
        if (this.buttons.keySet().size() == 0) {
            return 0;
        }
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.buttons.containsKey(i)) continue;
            return i;
        }
        return this.getHighestSlot() + 1;
    }

    public int getHighestSlot() {
        int highestNum = 0;
        for (int num : this.buttons.keySet()) {
            if (num <= highestNum) continue;
            highestNum = num;
        }
        return highestNum;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public int getInventorySize() {
        return this.getProperSize(this.getHighestSlot());
    }

    public int getMaxInvSize() {
        return this.maxInvSize;
    }

    public Object getMeta(Player player, String str) {
        return PlayerUtils.getPlayerMeta(AdvancedCorePlugin.getInstance(), player, str);
    }

    public ItemStack getNextItem() {
        return this.nextItem;
    }

    public int getNextSlot() {
        if (this.buttons.keySet().size() == 0) {
            return 0;
        }
        return this.getHighestSlot() + 1;
    }

    public ArrayList<BInventoryButton> getPageButtons() {
        return this.pageButtons;
    }

    public ItemStack getPrevItem() {
        return this.prevItem;
    }

    private int getProperSize(int size) {
        if (size < 9) {
            return 9;
        }
        if (size < 18) {
            return 18;
        }
        if (size < 27) {
            return 27;
        }
        if (size < 36) {
            return 36;
        }
        if (size < 45) {
            return 45;
        }
        return 54;
    }

    public boolean isOpen(Player p) {
        GUISession session = GUISession.extractSession(p);
        return session != null && session.getInventoryGUI() == this;
    }

    public boolean isPages() {
        return this.pages;
    }

    public BInventory noSound() {
        this.playerSound = false;
        return this;
    }

    public void onClick(InventoryClickEvent event, BInventoryButton b) {
        this.playSound((Player)event.getWhoClicked());
        b.onClick(new ClickEvent(event, b), this);
    }

    private void openInv(final Player player, final Inventory inv) {
        AdvancedCorePlugin.getInstance().getBukkitScheduler().runTask((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

            @Override
            public void run() {
                player.openInventory(inv);
            }
        }, (Entity)player);
    }

    public void openInventory(Player player) {
        if (player.isSleeping()) {
            AdvancedCorePlugin.getInstance().debug(player.getName() + " is sleeping, not opening gui!");
            return;
        }
        if (this.perm != null) {
            if (!this.perm.contains("|")) {
                if (!player.hasPermission(this.perm)) {
                    player.sendMessage(MessageAPI.colorize(AdvancedCorePlugin.getInstance().getOptions().getFormatNoPerms()));
                    return;
                }
            } else {
                boolean hasPerm = false;
                for (String permStr : this.perm.split(Pattern.quote("|"))) {
                    if (!player.hasPermission(permStr)) continue;
                    hasPerm = true;
                }
                if (!hasPerm) {
                    player.sendMessage(MessageAPI.colorize(AdvancedCorePlugin.getInstance().getOptions().getFormatNoPerms()));
                    return;
                }
            }
        }
        this.addFillSlots();
        BInventory inventory = this;
        if (inventory.getHighestSlot() >= this.maxInvSize) {
            this.pages = true;
        }
        if (!this.pages) {
            this.inv = Bukkit.createInventory((InventoryHolder)new GUISession(this, 1), (int)inventory.getInventorySize(), (String)PlaceholderUtils.replaceJavascript(player, PlaceholderUtils.replacePlaceHolder(inventory.getInventoryName(), this.getPlaceholders())));
            for (Map.Entry entry : inventory.getButtons().entrySet()) {
                ItemStack item = ((BInventoryButton)entry.getValue()).getItem(player, this.getPlaceholders());
                this.inv.setItem(((Integer)entry.getKey()).intValue(), item);
                BInventoryButton b = (BInventoryButton)entry.getValue();
                b.setInv(this);
                b.setSlot((Integer)entry.getKey());
                b.load(player);
            }
            this.openInv(player, this.inv);
        } else {
            this.maxPage = this.getHighestSlot() / (this.maxInvSize - 9);
            if (this.getHighestSlot() % (this.maxInvSize - 9) != 0) {
                ++this.maxPage;
            }
            this.addPlaceholder("totalpages", "" + this.maxPage);
            this.openInventory(player, 1);
        }
    }

    public void openInventory(Player player, int page) {
        BInventory inventory = this;
        this.addPlaceholder("currentpage", "" + page);
        this.inv = Bukkit.createInventory((InventoryHolder)new GUISession(this, page), (int)this.maxInvSize, (String)PlaceholderUtils.replaceJavascript(player, PlaceholderUtils.replacePlaceHolder(inventory.getInventoryName(), this.getPlaceholders())));
        this.page = page;
        int startSlot = (page - 1) * (this.maxInvSize - 9);
        for (Map.Entry<Integer, BInventoryButton> pair : inventory.getButtons().entrySet()) {
            int slot = pair.getKey();
            if (slot < startSlot || (slot -= startSlot) >= this.maxInvSize - 9) continue;
            ItemStack item = pair.getValue().getItem(player, this.getPlaceholders());
            this.inv.setItem(slot, item);
            BInventoryButton b = pair.getValue();
            b.setInv(this);
            b.setSlot(pair.getKey());
            b.load(player);
        }
        for (BInventoryButton b : this.pageButtons) {
            this.inv.setItem(this.maxInvSize - 9 + b.getSlot(), b.getItem(player, this.getPlaceholders()));
        }
        if (this.prevItem == null) {
            this.prevItem = AdvancedCorePlugin.getInstance().getOptions().getPrevItem() != null ? new ItemBuilder(AdvancedCorePlugin.getInstance().getOptions().getPrevItem()).addPlaceholder(this.getPlaceholders()).toItemStack(player) : new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE, 1).setName("&aPrevious Page").addPlaceholder(this.getPlaceholders()).toItemStack(player);
        }
        if (this.nextItem == null) {
            this.nextItem = AdvancedCorePlugin.getInstance().getOptions().getNextItem() != null ? new ItemBuilder(AdvancedCorePlugin.getInstance().getOptions().getNextItem()).addPlaceholder(this.getPlaceholders()).toItemStack(player) : new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE, 1).setName("&aNext Page").addPlaceholder(this.getPlaceholders()).toItemStack(player);
        }
        this.inv.setItem(this.maxInvSize - 9, this.prevItem);
        this.inv.setItem(this.maxInvSize - 1, this.nextItem);
        this.openInv(player, this.inv);
    }

    public void playSound(Player player) {
        Sound sound;
        if (this.playerSound && (sound = AdvancedCorePlugin.getInstance().getOptions().getClickSoundSound()) != null) {
            player.playSound(player.getLocation(), sound, (float)AdvancedCorePlugin.getInstance().getOptions().getClickSoundVolume(), (float)AdvancedCorePlugin.getInstance().getOptions().getClickSoundPitch());
        }
    }

    public void requirePermission(String permission) {
        this.perm = permission;
    }

    public void setButtons(Map<Integer, BInventoryButton> buttons) {
        this.buttons = buttons;
    }

    public BInventory setCloseInv(boolean value) {
        this.closeInv = value;
        return this;
    }

    public void setInventoryName(String inventoryName) {
        this.inventoryName = MessageAPI.colorize(inventoryName);
    }

    public void setMaxInvSize(int maxInvSize) {
        this.maxInvSize = this.getProperSize(maxInvSize);
    }

    public void setMeta(Player player, String str, Object ob) {
        PlayerUtils.setPlayerMeta(AdvancedCorePlugin.getInstance(), player, str, ob);
    }

    public void setNextItem(ItemStack nextItem) {
        this.nextItem = nextItem;
    }

    public void setPageButtons(ArrayList<BInventoryButton> pageButtons) {
        this.pageButtons = pageButtons;
    }

    public void setPages(boolean pages) {
        this.pages = pages;
    }

    public void setPrevItem(ItemStack prevItem) {
        this.prevItem = prevItem;
    }

    @Generated
    public boolean isCloseInv() {
        return this.closeInv;
    }

    @Generated
    public long getLastPressTime() {
        return this.lastPressTime;
    }

    @Generated
    public void setLastPressTime(long lastPressTime) {
        this.lastPressTime = lastPressTime;
    }

    @Generated
    public int getMaxPage() {
        return this.maxPage;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public HashMap<String, String> getPlaceholders() {
        return this.placeholders;
    }

    @Generated
    public boolean isPlayerSound() {
        return this.playerSound;
    }

    @Generated
    public void setPlayerSound(boolean playerSound) {
        this.playerSound = playerSound;
    }

    public class ClickEvent {
        private BInventoryButton button;
        private ClickType click;
        private ItemStack clickedItem;
        private InventoryClickEvent event;
        private Inventory inventory;
        private Player player;
        private int slot;

        public ClickEvent(InventoryClickEvent event, BInventoryButton b) {
            this.event = event;
            this.player = (Player)event.getWhoClicked();
            this.click = event.getClick();
            this.inventory = event.getInventory();
            this.clickedItem = event.getCurrentItem();
            this.slot = event.getSlot();
            this.button = b;
        }

        public void closeInventory() {
            this.runSync(new Runnable(){

                @Override
                public void run() {
                    if (ClickEvent.this.player != null) {
                        ClickEvent.this.player.closeInventory();
                    }
                }
            });
        }

        public ItemStack getCurrentItem() {
            return this.clickedItem;
        }

        public Object getMeta(Player player, String str) {
            return PlayerUtils.getPlayerMeta(AdvancedCorePlugin.getInstance(), player, str);
        }

        public Object getMeta(String str) {
            return PlayerUtils.getPlayerMeta(AdvancedCorePlugin.getInstance(), this.player, str);
        }

        public Player getWhoClicked() {
            return this.player;
        }

        public void runSync(Runnable run) {
            AdvancedCorePlugin.getInstance().getBukkitScheduler().runTask((Plugin)AdvancedCorePlugin.getInstance(), run);
        }

        @Generated
        public BInventoryButton getButton() {
            return this.button;
        }

        @Generated
        public ClickType getClick() {
            return this.click;
        }

        @Generated
        public ItemStack getClickedItem() {
            return this.clickedItem;
        }

        @Generated
        public InventoryClickEvent getEvent() {
            return this.event;
        }

        @Generated
        public Inventory getInventory() {
            return this.inventory;
        }

        @Generated
        public Player getPlayer() {
            return this.player;
        }

        @Generated
        public int getSlot() {
            return this.slot;
        }
    }
}

