/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.hologram;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Hologram {
    private ArmorStand armorStand;
    private Location loc;

    public Hologram(Location loc, final String name) {
        this.loc = loc;
        if (!Bukkit.isPrimaryThread()) {
            AdvancedCorePlugin.getInstance().getBukkitScheduler().executeOrScheduleSync((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Hologram.this.createHologram(name, true, false);
                }
            });
        } else {
            this.createHologram(name, true, false);
        }
        AdvancedCorePlugin.getInstance().getHologramHandler().add(this);
    }

    public Hologram(Location loc, final String name, final boolean marker) {
        this.loc = loc;
        if (!Bukkit.isPrimaryThread()) {
            AdvancedCorePlugin.getInstance().getBukkitScheduler().executeOrScheduleSync((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Hologram.this.createHologram(name, marker, false);
                }
            });
        } else {
            this.createHologram(name, marker, false);
        }
        AdvancedCorePlugin.getInstance().getHologramHandler().add(this);
    }

    public Hologram(Location loc, final String name, final boolean marker, final boolean glowing) {
        this.loc = loc;
        if (!Bukkit.isPrimaryThread()) {
            AdvancedCorePlugin.getInstance().getBukkitScheduler().executeOrScheduleSync((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Hologram.this.createHologram(name, marker, glowing);
                }
            });
        } else {
            this.createHologram(name, marker, glowing);
        }
        AdvancedCorePlugin.getInstance().getHologramHandler().add(this);
    }

    public Hologram(Location loc, final String name, final boolean marker, final boolean glowing, final NamespacedKey key, final int value) {
        this.loc = loc;
        if (!Bukkit.isPrimaryThread()) {
            AdvancedCorePlugin.getInstance().getBukkitScheduler().executeOrScheduleSync((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Hologram.this.createHologram(name, marker, glowing, key, value);
                }
            });
        } else {
            this.createHologram(name, marker, glowing, key, value);
        }
        AdvancedCorePlugin.getInstance().getHologramHandler().add(this);
    }

    public Hologram(Location loc, final String name, final boolean marker, final boolean glowing, final NamespacedKey key, final int value, final String str, final Object value1) {
        this.loc = loc;
        if (!Bukkit.isPrimaryThread()) {
            AdvancedCorePlugin.getInstance().getBukkitScheduler().executeOrScheduleSync((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Hologram.this.createHologram(name, marker, glowing, key, value, str, value1);
                }
            });
        } else {
            this.createHologram(name, marker, glowing, key, value, str, value1);
        }
        AdvancedCorePlugin.getInstance().getHologramHandler().add(this);
    }

    private void createHologram(String name, boolean marker, boolean glowing) {
        this.armorStand = (ArmorStand)this.loc.getWorld().spawnEntity(this.loc, EntityType.ARMOR_STAND);
        this.armorStand.setVisible(false);
        if (!name.isEmpty()) {
            this.armorStand.setCustomNameVisible(true);
        } else {
            this.armorStand.setCustomNameVisible(false);
        }
        this.armorStand.setCustomName(MessageAPI.colorize(name));
        this.armorStand.setGravity(false);
        this.armorStand.setAI(false);
        this.armorStand.setMarker(marker);
        this.armorStand.setGlowing(glowing);
        this.armorStand.setInvulnerable(true);
    }

    private void createHologram(String name, boolean marker, boolean glowing, NamespacedKey key, int value) {
        this.armorStand = (ArmorStand)this.loc.getWorld().spawnEntity(this.loc, EntityType.ARMOR_STAND);
        this.armorStand.setVisible(false);
        if (!name.isEmpty()) {
            this.armorStand.setCustomNameVisible(true);
        } else {
            this.armorStand.setCustomNameVisible(false);
        }
        this.armorStand.setCustomName(MessageAPI.colorize(name));
        this.armorStand.setGravity(false);
        this.armorStand.setAI(false);
        this.armorStand.setMarker(marker);
        this.armorStand.setGlowing(glowing);
        this.armorStand.setInvulnerable(true);
        this.armorStand.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
    }

    private void createHologram(String name, boolean marker, boolean glowing, NamespacedKey key, int value, String str, Object object) {
        this.armorStand = (ArmorStand)this.loc.getWorld().spawnEntity(this.loc, EntityType.ARMOR_STAND);
        this.armorStand.setVisible(false);
        if (!name.isEmpty()) {
            this.armorStand.setCustomNameVisible(true);
        } else {
            this.armorStand.setCustomNameVisible(false);
        }
        this.armorStand.setCustomName(MessageAPI.colorize(name));
        this.armorStand.setGravity(false);
        this.armorStand.setAI(false);
        this.armorStand.setMarker(marker);
        this.armorStand.setGlowing(glowing);
        this.armorStand.setInvulnerable(true);
        this.armorStand.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
        MiscUtils.getInstance().setEntityMeta((Entity)this.armorStand, str, object);
    }

    public PersistentDataContainer getPersistentDataHolder() {
        return this.armorStand.getPersistentDataContainer();
    }

    public void glow(boolean value) {
        if (this.armorStand != null) {
            this.armorStand.setGlowing(value);
        }
    }

    public boolean isAlive() {
        return !this.armorStand.isDead();
    }

    public boolean isCreated() {
        return this.armorStand != null;
    }

    public void kill() {
        if (!Bukkit.isPrimaryThread()) {
            AdvancedCorePlugin.getInstance().getBukkitScheduler().executeOrScheduleSync((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Hologram.this.armorStand.setHealth(0.0);
                    Hologram.this.armorStand.remove();
                    Hologram.this.armorStand = null;
                }
            });
        } else {
            this.armorStand.setHealth(0.0);
            this.armorStand.remove();
            this.armorStand = null;
        }
        AdvancedCorePlugin.getInstance().getHologramHandler().remove(this, false);
    }

    @Generated
    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    @Generated
    public Location getLoc() {
        return this.loc;
    }
}

