/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.gui;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class GUIHandler {
    private HashMap<String, Object> data = new HashMap();
    private CommandSender player;
    private AdvancedCorePlugin plugin;

    public GUIHandler(AdvancedCorePlugin plugin, CommandSender player) {
        this.plugin = plugin;
        this.player = player;
    }

    public String colorize(String str) {
        return MessageAPI.colorize(str);
    }

    public abstract ArrayList<String> getChat(CommandSender var1);

    public abstract void onBook(Player var1);

    public abstract void onChat(CommandSender var1);

    public abstract void onChest(Player var1);

    public abstract void open();

    public void open(GUIMethod method) {
        if (this.player instanceof Player) {
            switch (method) {
                case BOOK: {
                    this.onBook((Player)this.player);
                    return;
                }
                case CHAT: {
                    this.onChat(this.player);
                    return;
                }
                case CHEST: {
                    this.onChest((Player)this.player);
                    return;
                }
            }
        } else {
            this.onChat(this.player);
        }
    }

    public void sendMessage(ArrayList<String> message) {
        if (this.player instanceof Player) {
            AdvancedCoreUser user = this.plugin.getUserManager().getUser((Player)this.player);
            user.sendMessage(message);
        } else {
            this.player.sendMessage(ArrayUtils.convert(message));
        }
    }

    public void sendMessage(String ... message) {
        if (this.player instanceof Player) {
            AdvancedCoreUser user = this.plugin.getUserManager().getUser((Player)this.player);
            user.sendMessage(message);
        } else {
            this.player.sendMessage(message);
        }
    }

    public void sendMessageJson(ArrayList<TextComponent> text) {
        if (this.player instanceof Player) {
            AdvancedCoreUser user = this.plugin.getUserManager().getUser((Player)this.player);
            user.sendJson(text);
        } else {
            this.player.sendMessage(ArrayUtils.convert(ArrayUtils.comptoString(text)));
        }
    }

    public void setData(String str, Object value) {
        this.data.put(str, value);
    }

    @Generated
    public HashMap<String, Object> getData() {
        return this.data;
    }

    @Generated
    public CommandSender getPlayer() {
        return this.player;
    }

    @Generated
    public AdvancedCorePlugin getPlugin() {
        return this.plugin;
    }
}

