/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.command;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import org.bukkit.command.CommandSender;

public abstract class PlayerCommandHandler
extends CommandHandler {
    private int playerArg = -1;

    public PlayerCommandHandler(AdvancedCorePlugin plugin) {
        super(plugin);
        this.figureOutPlayerArg();
    }

    public PlayerCommandHandler(AdvancedCorePlugin plugin, String[] args, String perm) {
        super(plugin, args, perm);
        this.figureOutPlayerArg();
    }

    public PlayerCommandHandler(AdvancedCorePlugin plugin, String[] args, String perm, String helpMessage) {
        super(plugin, args, perm, helpMessage);
        this.figureOutPlayerArg();
    }

    public PlayerCommandHandler(AdvancedCorePlugin plugin, String[] args, String perm, String helpMessage, boolean allowConsole) {
        super(plugin, args, perm, helpMessage, allowConsole);
        this.figureOutPlayerArg();
    }

    public PlayerCommandHandler(AdvancedCorePlugin plugin, String[] args, String perm, String helpMessage, boolean allowConsole, boolean forceConsole) {
        super(plugin, args, perm, helpMessage, allowConsole);
        this.figureOutPlayerArg();
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (this.playerArg >= 0 && args[this.playerArg].equalsIgnoreCase("all")) {
            this.executeAll(sender, args);
        }
        this.executeSinglePlayer(sender, args);
    }

    public abstract void executeAll(CommandSender var1, String[] var2);

    public abstract void executeSinglePlayer(CommandSender var1, String[] var2);

    private void figureOutPlayerArg() {
        for (int i = 0; i < this.getArgs().length; ++i) {
            if (!this.getArgs()[i].equalsIgnoreCase("(player)")) continue;
            this.playerArg = i;
            return;
        }
        this.getPlugin().devDebug("Failed to figure out player arg number for: " + this.getArgs());
    }

    @Override
    public void setArgs(String[] args) {
        super.setArgs(args);
        this.figureOutPlayerArg();
    }
}

