/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.bookgui;

import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;

public class Layout {
    private BaseComponent compToAdd;
    private HashMap<String, String> placeholders = new HashMap();
    private ArrayList<String> stringLayout;
    private String text;

    public Layout(ArrayList<String> layout) {
        this.stringLayout = layout;
    }

    public Layout addPlaceholder(String toReplace, String replaceWith) {
        this.placeholders.put(toReplace, replaceWith);
        return this;
    }

    private String colorize(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public BaseComponent[] getLayout(HashMap<String, String> placeholders) {
        this.stringLayout = PlaceholderUtils.replacePlaceHolder(this.stringLayout, placeholders);
        this.stringLayout = PlaceholderUtils.replacePlaceHolder(this.stringLayout, this.placeholders);
        ArrayList<TextComponent> layout = new ArrayList<TextComponent>();
        for (int i = 0; i < this.stringLayout.size(); ++i) {
            String str = this.stringLayout.get(i);
            if (this.text != null && !this.text.equals("") && MessageAPI.containsIgnorecase(str, this.text)) {
                String[] split = str.split(Pattern.quote(this.text));
                String first = "";
                String last = "";
                if (split.length > 0) {
                    first = split[0];
                    if (split.length > 1) {
                        last = split[1];
                    }
                }
                TextComponent comp = new TextComponent(this.colorize(first));
                comp.addExtra(this.compToAdd);
                comp.addExtra(this.colorize(last));
                layout.add(comp);
                continue;
            }
            layout.add(new TextComponent(this.colorize(str)));
        }
        BaseComponent[] comps = new BaseComponent[layout.size()];
        for (int i = 0; i < layout.size(); ++i) {
            comps[i] = (BaseComponent)layout.get(i);
        }
        return comps;
    }

    public Layout replaceTextComponent(String text, BaseComponent compToAdd) {
        this.text = text;
        this.compToAdd = compToAdd;
        return this;
    }

    @Generated
    public ArrayList<String> getStringLayout() {
        return this.stringLayout;
    }
}

