/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.bookgui;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.bookgui.Layout;
import com.bencodez.votingplugin.advancedcore.xyz.upperlevel.spigot.book.BookUtil;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BookWrapper {
    private ItemStack book;
    private ArrayList<BaseComponent[]> builder = new ArrayList();
    private BookUtil.PageBuilder currentPage;
    private int currentPageLines = 0;
    private HashMap<String, String> placeholders = new HashMap();
    private String title;

    public BookWrapper(String title) {
        this.title = title;
        this.currentPage = new BookUtil.PageBuilder();
    }

    public BookWrapper addLayout(Layout layout) {
        this.addToCurrentPage(layout.getLayout(this.getPlaceholders()));
        return this;
    }

    public BookWrapper addLine() {
        ++this.currentPageLines;
        if (this.currentPageLines > 14) {
            this.nextPage(0);
        }
        this.currentPage.newLine();
        return this;
    }

    public BookWrapper addPlaceholder(String toReplace, String replaceWith) {
        this.placeholders.put(toReplace, replaceWith);
        return this;
    }

    public BookWrapper addToCurrentPage(BaseComponent ... baseComponents) {
        this.currentPageLines += baseComponents.length;
        if (this.currentPageLines > 14) {
            this.nextPage(baseComponents.length);
        }
        for (BaseComponent comp : baseComponents) {
            this.currentPage.add(comp);
            this.currentPage.newLine();
        }
        return this;
    }

    public String colorize(String s) {
        return MessageAPI.colorize(s);
    }

    public BookWrapper nextPage(int newSize) {
        this.builder.add(this.currentPage.build());
        this.currentPage = new BookUtil.PageBuilder();
        this.currentPageLines = newSize;
        return this;
    }

    public void open(final Player player) {
        this.builder.add(this.currentPage.build());
        this.book = BookUtil.writtenBook().author(player.getName()).title(this.colorize(this.title)).pages(this.builder).build();
        AdvancedCorePlugin.getInstance().getBukkitScheduler().runTask((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

            @Override
            public void run() {
                BookUtil.openPlayer(player, BookWrapper.this.book);
            }
        }, (Entity)player);
    }

    @Generated
    public ItemStack getBook() {
        return this.book;
    }

    @Generated
    public ArrayList<BaseComponent[]> getBuilder() {
        return this.builder;
    }

    @Generated
    public BookUtil.PageBuilder getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public int getCurrentPageLines() {
        return this.currentPageLines;
    }

    @Generated
    public void setCurrentPageLines(int currentPageLines) {
        this.currentPageLines = currentPageLines;
    }

    @Generated
    public HashMap<String, String> getPlaceholders() {
        return this.placeholders;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }
}

