/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.backup;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCreator {
    static ZipCreator instance = new ZipCreator();
    public AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public static ZipCreator getInstance() {
        return instance;
    }

    private ZipCreator() {
    }

    public void addAllFiles(File dir, List<File> fileList) {
        try {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.getName() != null && !file.getName().equals("Users.db-journal")) {
                    fileList.add(file);
                }
                if (file.isDirectory()) {
                    this.plugin.debug("directory:" + file.getCanonicalPath());
                    if (file.getAbsolutePath().contains(AdvancedCorePlugin.getInstance().getName() + File.separator + "Backups") || file.getAbsolutePath().contains(AdvancedCorePlugin.getInstance().getName() + File.separator + "Reports")) continue;
                    this.addAllFiles(file, fileList);
                    continue;
                }
                this.plugin.debug("file:" + file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addToZip(File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        if (file.exists()) {
            int length;
            FileInputStream fis = new FileInputStream(file);
            String zipFilePath = file.getPath();
            this.plugin.extraDebug("Writing '" + zipFilePath + "' to zip file");
            ZipEntry zipEntry = new ZipEntry(zipFilePath);
            zos.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            zos.closeEntry();
            fis.close();
        }
    }

    public void create(File directory, File zipFileLocation) {
        if (zipFileLocation.exists()) {
            zipFileLocation.delete();
        }
        try {
            zipFileLocation.getParentFile().mkdirs();
            zipFileLocation.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        try {
            this.plugin.debug("---Getting references to all files in: " + directory.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addAllFiles(directory, fileList);
        this.plugin.debug("---Creating zip file");
        this.writeZipFile(fileList, zipFileLocation);
        this.plugin.debug("---Done");
    }

    public void createReport() {
        long time = Calendar.getInstance().getTime().getTime();
        this.create(this.plugin.getDataFolder(), new File(this.plugin.getDataFolder(), "Reports" + File.separator + "Reports." + Long.toString(time) + ".zip"));
    }

    private void writeZipFile(List<File> fileList, File zipFile) {
        try {
            File fileZipFolder = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "Reports");
            if (!fileZipFolder.exists()) {
                fileZipFolder.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (File file : fileList) {
                if (!file.exists() || file.isDirectory() || file.getAbsolutePath().equals(zipFile.getAbsolutePath())) continue;
                try {
                    this.addToZip(file, zos);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            this.plugin.getLogger().info("Created zip file at " + zipFile.getAbsolutePath());
            zos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

