/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.backup;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.backup.ZipCreator;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.api.time.events.DateChangedEvent;
import java.io.File;
import java.time.LocalDateTime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class BackupHandle
implements Listener {
    private static BackupHandle instance = new BackupHandle();

    public static BackupHandle getInstance() {
        return instance;
    }

    private BackupHandle() {
    }

    public void checkOldBackups() {
        for (File file : new File(AdvancedCorePlugin.getInstance().getDataFolder(), "Backups").listFiles()) {
            long lastModified = file.lastModified();
            if (!LocalDateTime.now().minusDays(5L).isAfter(MiscUtils.getInstance().getTime(lastModified))) continue;
            file.delete();
            AdvancedCorePlugin.getInstance().debug("Deleting old backup: " + file.getName());
        }
    }

    @EventHandler
    public void onPostDateChange(DateChangedEvent e) {
        if (!e.getTimeType().equals((Object)TimeType.DAY) || !AdvancedCorePlugin.getInstance().getOptions().isCreateBackups()) {
            return;
        }
        LocalDateTime now = AdvancedCorePlugin.getInstance().getTimeChecker().getTime();
        ZipCreator.getInstance().create(AdvancedCorePlugin.getInstance().getDataFolder(), new File(AdvancedCorePlugin.getInstance().getDataFolder(), "Backups" + File.separator + "Backup-" + now.getYear() + "_" + now.getMonth() + "_" + now.getDayOfMonth() + ".zip"));
        this.checkOldBackups();
    }
}

