/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUIButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueString;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardEditData;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.rewards.injectedrequirement.RequirementInjectString;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHandler {
    private Economy econ = null;
    private Permission perms;

    public void loadVault(final AdvancedCorePlugin plugin) {
        if (plugin.isLoadVault()) {
            plugin.getBukkitScheduler().runTaskLater((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    if (VaultHandler.this.setupEconomy(plugin)) {
                        plugin.getLogger().info("Successfully hooked into vault economy!");
                    } else {
                        plugin.getLogger().warning("Failed to hook into vault economy");
                    }
                    if (VaultHandler.this.setupPermissions(plugin)) {
                        plugin.getLogger().info("Hooked into vault permissions");
                        plugin.getRewardHandler().addInjectedRequirements(new RequirementInjectString("VaultGroup", ""){

                            @Override
                            public boolean onRequirementsRequest(Reward reward, AdvancedCoreUser user, String type, RewardOptions rewardOptions) {
                                if (type.equals("")) {
                                    return true;
                                }
                                String group = "";
                                group = !rewardOptions.isGiveOffline() && user.isOnline() ? VaultHandler.this.getPerms().getPrimaryGroup(user.getPlayer()) : VaultHandler.this.getPerms().getPrimaryGroup(null, user.getOfflinePlayer());
                                return group.equalsIgnoreCase(type);
                            }
                        }.priority(100).addEditButton(new EditGUIButton(new ItemBuilder(Material.PAPER), new EditGUIValueString("VaultGroup", null){

                            @Override
                            public void setValue(Player player, String value) {
                                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                                reward.setValue(this.getKey(), value);
                                plugin.reloadAdvancedCore(false);
                            }
                        }.addOptions(VaultHandler.this.getPerms().getGroups()))));
                    } else {
                        plugin.getLogger().warning("Failed to hook into vault permissions");
                    }
                }
            }, 5L);
        } else {
            plugin.debug("Vault hook disabled");
        }
    }

    private boolean setupEconomy(AdvancedCorePlugin plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    private boolean setupPermissions(AdvancedCorePlugin plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp == null) {
            return false;
        }
        this.perms = (Permission)rsp.getProvider();
        return this.perms != null;
    }

    @Generated
    public Economy getEcon() {
        return this.econ;
    }

    @Generated
    public Permission getPerms() {
        return this.perms;
    }
}

