/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore;

import com.bencodez.votingplugin.advancedcore.AdvancedCoreConfigOptions;
import com.bencodez.votingplugin.advancedcore.VaultHandler;
import com.bencodez.votingplugin.advancedcore.api.backup.BackupHandle;
import com.bencodez.votingplugin.advancedcore.api.bedrock.BedrockNameResolver;
import com.bencodez.votingplugin.advancedcore.api.cmi.CMIHandler;
import com.bencodez.votingplugin.advancedcore.api.hologram.HologramHandler;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryListener;
import com.bencodez.votingplugin.advancedcore.api.item.FullInventoryHandler;
import com.bencodez.votingplugin.advancedcore.api.javascript.JavascriptPlaceholderRequest;
import com.bencodez.votingplugin.advancedcore.api.misc.effects.FireworkHandler;
import com.bencodez.votingplugin.advancedcore.api.permissions.LuckPermsHandle;
import com.bencodez.votingplugin.advancedcore.api.permissions.PermissionHandler;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardHandler;
import com.bencodez.votingplugin.advancedcore.api.time.TimeChecker;
import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.api.updater.UpdateDownloader;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.UserManager;
import com.bencodez.votingplugin.advancedcore.api.user.UserStartup;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import com.bencodez.votingplugin.advancedcore.api.user.userstorage.mysql.MySQL;
import com.bencodez.votingplugin.advancedcore.api.user.userstorage.sql.UserTable;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.InputMethod;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.sign.SignMenu;
import com.bencodez.votingplugin.advancedcore.command.CommandLoader;
import com.bencodez.votingplugin.advancedcore.command.executor.ValueRequestInputCommand;
import com.bencodez.votingplugin.advancedcore.data.ServerData;
import com.bencodez.votingplugin.advancedcore.listeners.AuthMeLogin;
import com.bencodez.votingplugin.advancedcore.listeners.LoginSecurityLogin;
import com.bencodez.votingplugin.advancedcore.listeners.NLoginAuthenticate;
import com.bencodez.votingplugin.advancedcore.listeners.PlayerJoinEvent;
import com.bencodez.votingplugin.advancedcore.listeners.PlayerShowListener;
import com.bencodez.votingplugin.advancedcore.listeners.PluginUpdateVersionEvent;
import com.bencodez.votingplugin.advancedcore.listeners.WorldChangeEvent;
import com.bencodez.votingplugin.advancedcore.logger.Logger;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandle;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandler;
import com.bencodez.votingplugin.simpleapi.debug.DebugLevel;
import com.bencodez.votingplugin.simpleapi.file.YMLConfig;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.nms.NMSManager;
import com.bencodez.votingplugin.simpleapi.scheduler.BukkitScheduler;
import com.bencodez.votingplugin.simpleapi.servercomm.pluginmessage.PluginMessage;
import com.bencodez.votingplugin.simpleapi.skull.SkullCacheHandler;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.sqlite.Database;
import com.bencodez.votingplugin.simpleapi.sql.sqlite.Table;
import com.bencodez.votingplugin.simpleapi.utils.PluginUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public abstract class AdvancedCorePlugin
extends JavaPlugin {
    private static AdvancedCorePlugin javaPlugin;
    public VaultHandler vaultHandler;
    private CommandLoader advancedCoreCommandLoader;
    private SkullCacheHandler skullCacheHandler;
    private boolean authMeLoaded = false;
    private boolean nLoginLoaded = false;
    private boolean loginSecurityLoaded = false;
    private ArrayList<String> bannedPlayers = new ArrayList();
    private String buildTime = "";
    private String bungeeChannel;
    private CMIHandler cmiHandle;
    private Database database;
    private FullInventoryHandler fullInventoryHandler;
    private HologramHandler hologramHandler;
    private HashMap<String, Object> javascriptEngine = new HashMap();
    private ArrayList<JavascriptPlaceholderRequest> javascriptEngineRequests = new ArrayList();
    private String jenkinsSite = "";
    private boolean loadRewards = true;
    private boolean loadServerData = true;
    private boolean loadUserData = true;
    private MySQL mysql;
    private AdvancedCoreConfigOptions options = new AdvancedCoreConfigOptions();
    private boolean placeHolderAPIEnabled;
    private Logger pluginLogger;
    private PluginMessage pluginMessaging;
    private ServerData serverDataFile;
    private SignMenu signMenu;
    private TimeChecker timeChecker;
    private ScheduledExecutorService timer;
    private ScheduledExecutorService loginTimer;
    private ScheduledExecutorService inventoryTimer;
    private UserManager userManager;
    private ArrayList<UserStartup> userStartup = new ArrayList();
    private ConcurrentHashMap<String, String> uuidNameCache;
    private String version = "";
    private String advancedCoreBuildNumber = "NOTSET";
    private PermissionHandler permissionHandler;
    private RewardHandler rewardHandler;
    private LuckPermsHandle luckPermsHandle;
    private BukkitScheduler bukkitScheduler;
    private boolean loadBedrockAPI = true;
    private boolean loadLuckPerms = true;
    private BedrockNameResolver bedrockHandle;
    private boolean loadSkullHandler = true;
    private boolean loadVault = true;

    public static AdvancedCorePlugin getInstance() {
        return javaPlugin;
    }

    public static void setInstance(AdvancedCorePlugin plugin) {
        javaPlugin = plugin;
    }

    public void addUserStartup(UserStartup start) {
        this.userStartup.add(start);
    }

    public void allowDownloadingFromSpigot(int resourceId) {
        this.getOptions().setResourceId(resourceId);
    }

    private void checkAutoUpdate() {
        this.getBukkitScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (AdvancedCorePlugin.this.getOptions().isAutoDownload() && AdvancedCorePlugin.this.getOptions().getResourceId() != 0) {
                    UpdateDownloader.getInstance().checkAutoDownload(javaPlugin, AdvancedCorePlugin.this.getOptions().getResourceId());
                }
            }
        });
    }

    private void checkCMI() {
        this.getBukkitScheduler().runTaskAsynchronously((Plugin)javaPlugin, new Runnable(){

            @Override
            public void run() {
                if (Bukkit.getPluginManager().getPlugin("CMI") != null) {
                    AdvancedCorePlugin.this.getLogger().info("CMI found, loading hook");
                    AdvancedCorePlugin.this.cmiHandle = new CMIHandler();
                }
            }
        });
    }

    private void checkPlaceHolderAPI() {
        this.getBukkitScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                    AdvancedCorePlugin.this.placeHolderAPIEnabled = true;
                    AdvancedCorePlugin.this.debug("PlaceholderAPI found, will attempt to parse placeholders");
                } else {
                    AdvancedCorePlugin.this.placeHolderAPIEnabled = false;
                    AdvancedCorePlugin.this.debug("PlaceholderAPI not found, PlaceholderAPI placeholders will not work");
                }
            }
        });
    }

    public void checkPluginUpdate() {
        if (!this.loadServerData) {
            return;
        }
        this.getBukkitScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                String version = AdvancedCorePlugin.this.getServerDataFile().getPluginVersion((Plugin)javaPlugin);
                if (!version.equals(javaPlugin.getDescription().getVersion())) {
                    PluginUpdateVersionEvent event = new PluginUpdateVersionEvent((Plugin)javaPlugin, version);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                }
                AdvancedCorePlugin.this.getServerDataFile().setPluginVersion((Plugin)javaPlugin);
            }
        });
    }

    public void convertDataStorage(UserStorage from, UserStorage to) {
        this.debug("Starting convert process");
        if (to == null) {
            throw new RuntimeException("Invalid Storage Method");
        }
        this.loadUserAPI(from);
        this.loadUserAPI(to);
        if (this.getMysql() != null) {
            this.getMysql().clearCacheBasic();
        }
        HashMap<UUID, ArrayList<Column>> cols = this.getUserManager().getAllKeys(from);
        LinkedList<Map.Entry<UUID, ArrayList<Column>>> players = new LinkedList<Map.Entry<UUID, ArrayList<Column>>>(cols.entrySet());
        while (players.size() > 0) {
            Map.Entry entry = (Map.Entry)players.poll();
            AdvancedCoreUser user = this.getUserManager().getUser((UUID)entry.getKey(), false);
            user.dontCache();
            user.getData().setValues(to, user.getData().convert((List)entry.getValue()));
            this.debug("Finished convert for " + user.getUUID() + ", " + players.size() + " more left to go!");
            if (players.size() % 50 != 0) continue;
            this.getLogger().info("Working on converting data, about " + players.size() + " left to go!");
        }
        this.debug("Convert finished!");
    }

    public void debug(DebugLevel debugLevel, String debug) {
        if (debugLevel.equals((Object)DebugLevel.EXTRA)) {
            debug = "ExtraDebug: " + debug;
        } else if (debugLevel.equals((Object)DebugLevel.INFO)) {
            debug = "Debug: " + debug;
        } else if (debugLevel.equals((Object)DebugLevel.DEV)) {
            debug = "Developer Debug: " + debug;
        }
        if (this.getOptions().getDebug().isDebug(debugLevel)) {
            this.getLogger().info(debug);
        }
        if (this.getOptions().isDebugIngame()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.hasPermission(this.getName() + ".Debug")) continue;
                player.sendMessage(MessageAPI.colorize("&c" + this.getName() + " Debug: " + debug));
            }
        }
        if (this.getOptions().isLogDebugToFile()) {
            if (this.pluginLogger == null) {
                this.loadLogger();
            }
            String str = new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(Calendar.getInstance().getTime());
            this.pluginLogger.logToFile(str + ":" + debug);
        }
    }

    public void debug(Exception e) {
        if (this.getOptions().getDebug().isDebug()) {
            e.printStackTrace();
        }
        if (this.getOptions().isLogDebugToFile()) {
            if (this.pluginLogger != null) {
                String str = new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(Calendar.getInstance().getTime());
                this.pluginLogger.logToFile(str + " [" + this.getName() + "] ExceptionDebug: " + e.getMessage());
            } else {
                this.loadLogger();
            }
        }
    }

    public void debug(String debug) {
        this.debug(DebugLevel.INFO, debug);
    }

    public void devDebug(String debug) {
        this.debug(DebugLevel.DEV, debug);
    }

    public void extraDebug(String debug) {
        this.debug(DebugLevel.EXTRA, debug);
    }

    public UserTable getSQLiteUserTable() {
        if (this.database == null && this.loadUserData) {
            this.loadUserAPI(this.getStorageType());
        }
        if (this.loadUserData) {
            for (Table table : this.database.getTables()) {
                if (!(table instanceof UserTable)) continue;
                return (UserTable)table;
            }
        }
        return null;
    }

    public UserStorage getStorageType() {
        return this.getOptions().getStorageType();
    }

    public UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = new UserManager(this);
        }
        return this.userManager;
    }

    private YamlConfiguration getVersionFile() {
        try {
            CodeSource src = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource();
            if (src != null) {
                InputStreamReader defConfigStream;
                String name;
                ZipEntry e;
                URL jar = src.getLocation();
                ZipInputStream zip = null;
                zip = new ZipInputStream(jar.openStream());
                while ((e = zip.getNextEntry()) == null || !(name = e.getName()).equals("advancedcoreversion.yml") || (defConfigStream = new InputStreamReader(zip)) == null) {
                }
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                ((Reader)defConfigStream).close();
                return defConfig;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isMySQLOkay() {
        if (this.getStorageType().equals((Object)UserStorage.MYSQL)) {
            return this.mysql != null;
        }
        return true;
    }

    public void loadAdvancedCoreEvents() {
        if (this.loadUserData) {
            Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinEvent(this), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new WorldChangeEvent(this), (Plugin)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)FireworkHandler.getInstance(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BInventoryListener(this), (Plugin)this);
    }

    public void loadAutoUpdateCheck() {
        long delay = 3600L;
        this.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AdvancedCorePlugin.this.checkAutoUpdate();
            }
        }, delay, delay, TimeUnit.SECONDS);
    }

    private void loadConfig(boolean userStorage) {
        this.getOptions().load(this);
        if (this.loadUserData && userStorage) {
            this.loadUserAPI(this.getOptions().getStorageType());
        }
    }

    private void loadHandle() {
        if (Bukkit.getOnlineMode()) {
            this.debug("Server in online mode");
        } else {
            this.debug("Server in offline mode");
        }
    }

    public void loadHook() {
        this.serverDataFile = new ServerData(this);
        this.hologramHandler = new HologramHandler(this);
        if (this.loadLuckPerms && Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            this.luckPermsHandle = new LuckPermsHandle();
            this.luckPermsHandle.load(this);
        }
        this.loadSignAPI();
        this.loadUUIDs();
        this.getOptions().setPermPrefix(this.getName());
        this.checkPlaceHolderAPI();
        this.checkCMI();
        this.loadHandle();
        this.loadVault();
        this.loadAdvancedCoreEvents();
        this.timeChecker = new TimeChecker(this);
        if (this.loadServerData) {
            this.serverDataFile.setup();
            this.timeChecker.loadTimer();
        }
        this.getUserManager();
        this.permissionHandler = new PermissionHandler(this);
        this.loadConfig(true);
        this.skullCacheHandler = new SkullCacheHandler(this.getOptions().getSkullLoadDelay()){

            @Override
            public void debugException(Exception e) {
                AdvancedCorePlugin.this.debug(e);
            }

            @Override
            public void debugLog(String debug) {
                AdvancedCorePlugin.this.extraDebug(debug);
            }

            @Override
            public void log(String log) {
                AdvancedCorePlugin.this.getLogger().info(log);
            }
        };
        if (!this.getOptions().getSkullProfileAPIURL().isEmpty()) {
            this.debug("Setting API profile URL to " + this.getOptions().getSkullProfileAPIURL());
            this.skullCacheHandler.changeApiProfileURL(this.getOptions().getSkullProfileAPIURL());
        }
        this.skullCacheHandler.setBedrockPrefix(this.getOptions().getBedrockPlayerPrefix());
        this.skullCacheHandler.startTimer();
        if (this.loadBedrockAPI) {
            this.bedrockHandle = new BedrockNameResolver(this);
        }
        this.rewardHandler = RewardHandler.getInstance();
        this.rewardHandler.loadInjectedRewards();
        this.rewardHandler.loadInjectedRequirements();
        if (this.loadRewards) {
            File rewardsFolder = new File(this.getDataFolder(), "Rewards");
            this.rewardHandler.addRewardFolder(rewardsFolder, false, true);
            File file = new File(rewardsFolder.getAbsolutePath() + File.separator + "DirectlyDefined");
            this.rewardHandler.addRewardFolder(file, false, false);
            this.rewardHandler.loadRewards();
        }
        this.loadValueRequestInputCommands();
        this.checkPluginUpdate();
        this.loadAutoUpdateCheck();
        this.loadVersionFile();
        this.getUserManager().purgeOldPlayersStartup();
        this.userStartup();
        this.loadTabComplete();
        this.fullInventoryHandler = new FullInventoryHandler(this);
        for (OfflinePlayer p : Bukkit.getBannedPlayers()) {
            this.bannedPlayers.add(p.getUniqueId().toString());
        }
        Bukkit.getPluginManager().registerEvents((Listener)BackupHandle.getInstance(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("authme") != null) {
            this.authMeLoaded = true;
            Bukkit.getPluginManager().registerEvents((Listener)new AuthMeLogin(this), (Plugin)this);
        }
        if (Bukkit.getPluginManager().getPlugin("nLogin") != null) {
            this.nLoginLoaded = true;
            Bukkit.getPluginManager().registerEvents((Listener)new NLoginAuthenticate(this), (Plugin)this);
        }
        if (Bukkit.getPluginManager().getPlugin("LoginSecurity") != null) {
            this.loginSecurityLoaded = true;
            Bukkit.getPluginManager().registerEvents((Listener)new LoginSecurityLogin(this), (Plugin)this);
        }
        try {
            Class.forName("de.myzelyam.api.vanish.PostPlayerShowEvent");
            this.registerEvents(new PlayerShowListener(this));
            this.debug("Loaded PostPlayerShowEvent");
        }
        catch (ClassNotFoundException e) {
            this.debug("Not loading PostPlayerShowEvent");
        }
        String buildNumberMsg = "";
        if (!this.advancedCoreBuildNumber.equals("NOTSET")) {
            buildNumberMsg = ", build number: " + this.advancedCoreBuildNumber + ", ";
        }
        this.debug("Using AdvancedCore '" + this.getVersion() + "' built on '" + this.getBuildTime() + "' " + buildNumberMsg + " Spigot Version: " + Bukkit.getVersion() + " Total RAM: " + PluginUtils.getMemory() + " Free RAM: " + PluginUtils.getFreeMemory());
        this.debug(DebugLevel.INFO, "Debug Level: " + this.getOptions().getDebug().toString());
    }

    public void loadLogger() {
        if (this.getOptions().isLogDebugToFile() && this.pluginLogger == null) {
            this.pluginLogger = new Logger((Plugin)this, new File(this.getDataFolder(), "Log" + File.separator + "Log.txt"));
        }
    }

    private void loadSignAPI() {
        if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null && !NMSManager.getInstance().isVersion("1.8", "1.9", "1.10", "1.11") && Bukkit.getPluginManager().getPlugin("ProtocolLib").isEnabled()) {
            try {
                this.signMenu = new SignMenu((Plugin)this);
            }
            catch (Exception e) {
                this.getLogger().warning("ProtocolLib may not be up to date? Failed to load SignMenu");
                this.debug(e);
            }
        }
    }

    public void loadTabComplete() {
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(AllPlayer)", new ArrayList()){

            @Override
            public void reload() {
                ArrayList<String> players = new ArrayList<String>();
                for (String name : AdvancedCorePlugin.this.getUuidNameCache().values()) {
                    if (players.contains(name)) continue;
                    players.add(name);
                }
                this.setReplace(players);
            }

            @Override
            public void updateReplacements() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (this.getReplace().contains(player.getName())) continue;
                    this.getReplace().add(player.getName());
                }
            }
        });
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(Player)", new ArrayList()){

            @Override
            public void reload() {
                ArrayList<String> list = new ArrayList<String>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    list.add(player.getName());
                }
                this.setReplace(list);
            }

            @Override
            public void updateReplacements() {
                ArrayList<String> list = new ArrayList<String>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    list.add(player.getName());
                }
                this.setReplace(list);
            }
        }.updateOnLoginLogout());
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(PlayerExact)", new ArrayList()){

            @Override
            public void reload() {
                ArrayList<String> list = new ArrayList<String>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    list.add(player.getName());
                }
                this.setReplace(list);
            }

            @Override
            public void updateReplacements() {
                ArrayList<String> list = new ArrayList<String>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    list.add(player.getName());
                }
                this.setReplace(list);
            }
        }.updateOnLoginLogout());
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(uuid)", new ArrayList()){

            @Override
            public void reload() {
                ArrayList<String> uuids = new ArrayList<String>();
                for (String name : AdvancedCorePlugin.this.getUuidNameCache().keySet()) {
                    if (uuids.contains(name)) continue;
                    uuids.add(name);
                }
                this.setReplace(uuids);
            }

            @Override
            public void updateReplacements() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (this.getReplace().contains(player.getUniqueId().toString())) continue;
                    this.getReplace().add(player.getUniqueId().toString());
                }
            }
        }.updateEveryXMinutes(this.getTimer(), 30));
        ArrayList<String> options = new ArrayList<String>();
        options.add("True");
        options.add("False");
        TabCompleteHandler.getInstance().addTabCompleteOption("(Boolean)", options);
        options = new ArrayList();
        TabCompleteHandler.getInstance().addTabCompleteOption("(List)", options);
        TabCompleteHandler.getInstance().addTabCompleteOption("(String)", options);
        TabCompleteHandler.getInstance().addTabCompleteOption("(Text)", options);
        TabCompleteHandler.getInstance().addTabCompleteOption("(Number)", options);
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(Reward)", options){

            @Override
            public void reload() {
                ArrayList<String> rewards = new ArrayList<String>();
                for (Reward reward : AdvancedCorePlugin.this.rewardHandler.getRewards()) {
                    if (reward.getConfig().isDirectlyDefinedReward()) continue;
                    rewards.add(reward.getRewardName());
                }
                this.setReplace(rewards);
            }

            @Override
            public void updateReplacements() {
            }
        });
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(ChoiceReward)", options){

            @Override
            public void reload() {
                ArrayList<String> rewards = new ArrayList<String>();
                for (Reward reward : AdvancedCorePlugin.this.rewardHandler.getRewards()) {
                    if (!reward.getConfig().getEnableChoices()) continue;
                    rewards.add(reward.getRewardName());
                }
                this.setReplace(rewards);
            }

            @Override
            public void updateReplacements() {
            }
        });
        ArrayList<String> method = new ArrayList<String>();
        for (InputMethod me : InputMethod.values()) {
            method.add(me.toString());
        }
        TabCompleteHandler.getInstance().addTabCompleteOption("(RequestMethod)", method);
        ArrayList<String> userStorage = new ArrayList<String>();
        for (UserStorage storage : UserStorage.values()) {
            userStorage.add(storage.toString());
        }
        TabCompleteHandler.getInstance().addTabCompleteOption("(UserStorage)", userStorage);
        ArrayList<String> times = new ArrayList<String>();
        for (TimeType ty : TimeType.values()) {
            times.add(ty.toString());
        }
        TabCompleteHandler.getInstance().addTabCompleteOption("(TimeType)", times);
    }

    public void loadUserAPI(UserStorage storageType) {
        if (storageType.equals((Object)UserStorage.SQLITE)) {
            ArrayList<Column> columns = new ArrayList<Column>();
            Column key = new Column("uuid", DataType.STRING);
            columns.add(key);
            UserTable table = new UserTable(this, "Users", columns, key);
            this.database = new Database((Plugin)this, "Users", table);
            table.addCustomColumns();
        } else if (storageType.equals((Object)UserStorage.MYSQL)) {
            this.setMysql(new MySQL(javaPlugin, javaPlugin.getName() + "_Users", this.getOptions().getYmlConfig().getData().getConfigurationSection("MySQL")));
        } else if (storageType.equals((Object)UserStorage.FLAT)) {
            this.getLogger().severe("Detected using FLAT storage, this will be removed in the future!");
        }
    }

    private void loadUUIDs() {
        this.uuidNameCache = new ConcurrentHashMap();
        this.addUserStartup(new UserStartup(){

            @Override
            public void onFinish() {
                TabCompleteHandler.getInstance().reload();
                AdvancedCorePlugin.this.debug("Finished loading uuids");
            }

            @Override
            public void onStart() {
                AdvancedCorePlugin.this.debug("Starting background uuid/name task");
                if (!AdvancedCorePlugin.this.getOptions().isOnlineMode()) {
                    this.setProcess(false);
                }
            }

            @Override
            public void onStartUp(AdvancedCoreUser user) {
                String uuid = user.getUUID();
                String name = user.getData().getString("PlayerName", false, true);
                boolean add = true;
                if (AdvancedCorePlugin.this.uuidNameCache.containsKey(uuid)) {
                    AdvancedCorePlugin.this.debug("Duplicate uuid? " + uuid + "/" + name);
                }
                if (name == null || name.equals("") || name.equals("Error getting name") || name.equals("null")) {
                    add = false;
                } else if (AdvancedCorePlugin.this.uuidNameCache.containsValue(name)) {
                    AdvancedCorePlugin.this.debug("Duplicate player name?" + uuid + "/" + name);
                }
                if (uuid == null || uuid.equals("")) {
                    AdvancedCorePlugin.this.debug("Invalid uuid: " + uuid);
                    add = false;
                }
                if (add) {
                    AdvancedCorePlugin.this.uuidNameCache.put(uuid, name);
                }
            }
        });
        TabCompleteHandler.getInstance().reload();
        TabCompleteHandler.getInstance().loadTabCompleteOptions();
        TabCompleteHandler.getInstance().loadTimer(this.getTimer());
    }

    public void loadValueRequestInputCommands() {
        CommandLoader.getInstance().loadValueRequestCommands();
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.register(this.getName() + "valuerequestinput", (Command)new ValueRequestInputCommand(this, this.getName() + "valuerequestinput"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadVault() {
        this.vaultHandler = new VaultHandler();
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            this.debug("Attempting to hook into vault");
            this.vaultHandler.loadVault(this);
        }
    }

    private void loadVersionFile() {
        YamlConfiguration conf = this.getVersionFile();
        this.version = conf.getString("version", "Unknown");
        this.buildTime = conf.getString("time", "Unknown");
        this.advancedCoreBuildNumber = conf.getString("buildnumber", "NOTSET");
    }

    public void onDisable() {
        if (this.getOptions().getStorageType().equals((Object)UserStorage.MYSQL)) {
            this.getMysql().close();
        }
        this.getServerDataFile().setLastUpdated();
        this.timer.shutdown();
        this.loginTimer.shutdown();
        this.timeChecker.getTimer().shutdown();
        this.inventoryTimer.shutdown();
        try {
            this.getLogger().info("Allowing background tasks to finish, this could take up to 5 seconds");
            this.loginTimer.awaitTermination(2L, TimeUnit.SECONDS);
            this.timer.awaitTermination(2L, TimeUnit.SECONDS);
            this.timeChecker.getTimer().awaitTermination(2L, TimeUnit.SECONDS);
            this.inventoryTimer.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.debug(e);
        }
        this.rewardHandler.shutdown();
        this.loginTimer.shutdownNow();
        this.timer.shutdownNow();
        this.inventoryTimer.shutdownNow();
        this.timeChecker.getTimer().shutdownNow();
        this.onUnLoad();
        this.getSkullCacheHandler().close();
        this.fullInventoryHandler.save();
        this.unRegisterValueRequest();
        this.hologramHandler.onShutDown();
        if (this.getPermissionHandler() != null) {
            this.getPermissionHandler().shutDown();
        }
        javaPlugin = null;
    }

    public void onEnable() {
        javaPlugin = this;
        this.bukkitScheduler = new BukkitScheduler(this);
        this.timer = Executors.newSingleThreadScheduledExecutor();
        this.loginTimer = Executors.newSingleThreadScheduledExecutor();
        this.advancedCoreCommandLoader = CommandLoader.getInstance();
        this.inventoryTimer = Executors.newSingleThreadScheduledExecutor();
        this.onPreLoad();
        this.loadHook();
        this.onPostLoad();
        this.getRewardHandler().checkSubRewards();
    }

    public abstract void onPostLoad();

    public abstract void onPreLoad();

    public abstract void onUnLoad();

    public void registerBungeeChannels(String name) {
        this.bungeeChannel = name;
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, name);
        this.pluginMessaging = new PluginMessage(this, name);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, name, (PluginMessageListener)this.pluginMessaging);
        this.getLogger().info("Loaded plugin message channels: " + name);
    }

    public void registerEvents(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public abstract void reload();

    @Deprecated
    public void reloadAdvancedCore() {
        this.reloadAdvancedCore(false);
    }

    public void reloadAdvancedCore(boolean userStorage) {
        this.getServerDataFile().reloadData();
        this.rewardHandler.loadRewards();
        this.loadConfig(userStorage);
        if (userStorage) {
            this.getUserManager().getDataManager().clearCache();
            if (this.getStorageType().equals((Object)UserStorage.MYSQL) && this.getMysql() != null) {
                this.getMysql().clearCacheBasic();
            }
        }
        this.timeChecker.update();
        TabCompleteHandler.getInstance().reload();
        TabCompleteHandler.getInstance().loadTabCompleteOptions();
        this.getRewardHandler().checkSubRewards();
        if (this.skullCacheHandler != null) {
            if (!this.getOptions().getSkullProfileAPIURL().isEmpty()) {
                this.debug("Setting API profile URL to " + this.getOptions().getSkullProfileAPIURL());
                this.skullCacheHandler.changeApiProfileURL(this.getOptions().getSkullProfileAPIURL());
            }
            this.getSkullCacheHandler().setBedrockPrefix(this.getOptions().getBedrockPlayerPrefix());
        }
    }

    @Deprecated
    public void setConfigData(ConfigurationSection configData) {
        this.getOptions().setYmlConfig(new YMLConfig(this, configData){

            @Override
            public void createSection(String key) {
            }

            @Override
            public void saveData() {
            }

            @Override
            public void setValue(String path, Object value) {
            }
        });
    }

    public void setConfigData(YMLConfig ymlConfig) {
        this.getOptions().setYmlConfig(ymlConfig);
    }

    public void setMysql(MySQL mysql) {
        if (this.mysql != null) {
            this.mysql.close();
            this.mysql = null;
        }
        this.mysql = mysql;
    }

    public void unRegisterValueRequest() {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.getCommand(this.getName() + "valuerequestinput").unregister(commandMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void userStartup() {
        if (!this.loadUserData) {
            this.debug("Not loading userdata");
            return;
        }
        this.rewardHandler.startup();
        this.getBukkitScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                AdvancedCorePlugin.this.debug("User Startup starting");
                for (UserStartup start : AdvancedCorePlugin.this.userStartup) {
                    start.onStart();
                }
                boolean onlineMode = AdvancedCorePlugin.this.getOptions().isOnlineMode();
                int offlineAmount = 0;
                HashMap<UUID, ArrayList<Column>> cols = AdvancedCorePlugin.this.getUserManager().getAllKeys();
                for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                    AdvancedCoreUser user;
                    String uuid = playerData.getKey().toString();
                    if (onlineMode && uuid.charAt(14) == '3') {
                        ++offlineAmount;
                    }
                    if (javaPlugin == null || uuid == null || (user = AdvancedCorePlugin.this.getUserManager().getUser(UUID.fromString(uuid), false)) == null) continue;
                    user.dontCache();
                    user.updateTempCacheWithColumns(playerData.getValue());
                    for (UserStartup start : AdvancedCorePlugin.this.userStartup) {
                        if (!start.isProcess()) continue;
                        start.onStartUp(user);
                    }
                    user.clearTempCache();
                    cols.put(playerData.getKey(), null);
                    user = null;
                }
                cols.clear();
                cols = null;
                for (UserStartup start : AdvancedCorePlugin.this.userStartup) {
                    start.onFinish();
                }
                if (offlineAmount > 0 && onlineMode) {
                    AdvancedCorePlugin.this.debug("Detected offline uuids in a online server, this could mean an error for your server setup: " + offlineAmount);
                }
                AdvancedCorePlugin.this.debug("User Startup finished");
            }
        }, 5L);
    }

    @Generated
    public VaultHandler getVaultHandler() {
        return this.vaultHandler;
    }

    @Generated
    public CommandLoader getAdvancedCoreCommandLoader() {
        return this.advancedCoreCommandLoader;
    }

    @Generated
    public SkullCacheHandler getSkullCacheHandler() {
        return this.skullCacheHandler;
    }

    @Generated
    public boolean isAuthMeLoaded() {
        return this.authMeLoaded;
    }

    @Generated
    public boolean isNLoginLoaded() {
        return this.nLoginLoaded;
    }

    @Generated
    public boolean isLoginSecurityLoaded() {
        return this.loginSecurityLoaded;
    }

    @Generated
    public ArrayList<String> getBannedPlayers() {
        return this.bannedPlayers;
    }

    @Generated
    public String getBuildTime() {
        return this.buildTime;
    }

    @Generated
    public String getBungeeChannel() {
        return this.bungeeChannel;
    }

    @Generated
    public void setBungeeChannel(String bungeeChannel) {
        this.bungeeChannel = bungeeChannel;
    }

    @Generated
    public CMIHandler getCmiHandle() {
        return this.cmiHandle;
    }

    @Generated
    public FullInventoryHandler getFullInventoryHandler() {
        return this.fullInventoryHandler;
    }

    @Generated
    public HologramHandler getHologramHandler() {
        return this.hologramHandler;
    }

    @Generated
    public HashMap<String, Object> getJavascriptEngine() {
        return this.javascriptEngine;
    }

    @Generated
    public void setJavascriptEngine(HashMap<String, Object> javascriptEngine) {
        this.javascriptEngine = javascriptEngine;
    }

    @Generated
    public ArrayList<JavascriptPlaceholderRequest> getJavascriptEngineRequests() {
        return this.javascriptEngineRequests;
    }

    @Generated
    public void setJavascriptEngineRequests(ArrayList<JavascriptPlaceholderRequest> javascriptEngineRequests) {
        this.javascriptEngineRequests = javascriptEngineRequests;
    }

    @Generated
    public String getJenkinsSite() {
        return this.jenkinsSite;
    }

    @Generated
    public void setJenkinsSite(String jenkinsSite) {
        this.jenkinsSite = jenkinsSite;
    }

    @Generated
    public boolean isLoadRewards() {
        return this.loadRewards;
    }

    @Generated
    public void setLoadRewards(boolean loadRewards) {
        this.loadRewards = loadRewards;
    }

    @Generated
    public boolean isLoadServerData() {
        return this.loadServerData;
    }

    @Generated
    public void setLoadServerData(boolean loadServerData) {
        this.loadServerData = loadServerData;
    }

    @Generated
    public boolean isLoadUserData() {
        return this.loadUserData;
    }

    @Generated
    public void setLoadUserData(boolean loadUserData) {
        this.loadUserData = loadUserData;
    }

    @Generated
    public MySQL getMysql() {
        return this.mysql;
    }

    @Generated
    public AdvancedCoreConfigOptions getOptions() {
        return this.options;
    }

    @Generated
    public boolean isPlaceHolderAPIEnabled() {
        return this.placeHolderAPIEnabled;
    }

    @Generated
    public Logger getPluginLogger() {
        return this.pluginLogger;
    }

    @Generated
    public PluginMessage getPluginMessaging() {
        return this.pluginMessaging;
    }

    @Generated
    public ServerData getServerDataFile() {
        return this.serverDataFile;
    }

    @Generated
    public SignMenu getSignMenu() {
        return this.signMenu;
    }

    @Generated
    public TimeChecker getTimeChecker() {
        return this.timeChecker;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public ScheduledExecutorService getLoginTimer() {
        return this.loginTimer;
    }

    @Generated
    public ScheduledExecutorService getInventoryTimer() {
        return this.inventoryTimer;
    }

    @Generated
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Generated
    public ConcurrentHashMap<String, String> getUuidNameCache() {
        return this.uuidNameCache;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getAdvancedCoreBuildNumber() {
        return this.advancedCoreBuildNumber;
    }

    @Generated
    public PermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    @Generated
    public RewardHandler getRewardHandler() {
        return this.rewardHandler;
    }

    @Generated
    public LuckPermsHandle getLuckPermsHandle() {
        return this.luckPermsHandle;
    }

    @Generated
    public BukkitScheduler getBukkitScheduler() {
        return this.bukkitScheduler;
    }

    @Generated
    public boolean isLoadBedrockAPI() {
        return this.loadBedrockAPI;
    }

    @Generated
    public void setLoadBedrockAPI(boolean loadBedrockAPI) {
        this.loadBedrockAPI = loadBedrockAPI;
    }

    @Generated
    public boolean isLoadLuckPerms() {
        return this.loadLuckPerms;
    }

    @Generated
    public void setLoadLuckPerms(boolean loadLuckPerms) {
        this.loadLuckPerms = loadLuckPerms;
    }

    @Generated
    public BedrockNameResolver getBedrockHandle() {
        return this.bedrockHandle;
    }

    @Generated
    public boolean isLoadSkullHandler() {
        return this.loadSkullHandler;
    }

    @Generated
    public void setLoadSkullHandler(boolean loadSkullHandler) {
        this.loadSkullHandler = loadSkullHandler;
    }

    @Generated
    public boolean isLoadVault() {
        return this.loadVault;
    }

    @Generated
    public void setLoadVault(boolean loadVault) {
        this.loadVault = loadVault;
    }
}

