/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin;

import com.bencodez.votingplugin.BungeeHandler;
import com.bencodez.votingplugin.VotingPluginHooks;
import com.bencodez.votingplugin.VotingPluginMetrics;
import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUIButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueNumber;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.javascript.JavascriptPlaceholderRequest;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.DirectlyDefinedReward;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardEditData;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardPlaceholderHandle;
import com.bencodez.votingplugin.advancedcore.api.rewards.injected.RewardInject;
import com.bencodez.votingplugin.advancedcore.api.rewards.injected.RewardInjectConfigurationSection;
import com.bencodez.votingplugin.advancedcore.api.rewards.injected.RewardInjectInt;
import com.bencodez.votingplugin.advancedcore.api.rewards.injected.RewardInjectValidator;
import com.bencodez.votingplugin.advancedcore.api.rewards.injectedrequirement.RequirementInjectConfigurationSection;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.logger.Logger;
import com.bencodez.votingplugin.broadcast.BroadcastHandler;
import com.bencodez.votingplugin.commands.CommandLoader;
import com.bencodez.votingplugin.commands.executers.CommandAdminVote;
import com.bencodez.votingplugin.commands.executers.CommandVote;
import com.bencodez.votingplugin.commands.gui.AdminGUI;
import com.bencodez.votingplugin.commands.tabcompleter.AdminVoteTabCompleter;
import com.bencodez.votingplugin.commands.tabcompleter.VoteTabCompleter;
import com.bencodez.votingplugin.config.BungeeSettings;
import com.bencodez.votingplugin.config.Config;
import com.bencodez.votingplugin.config.ConfigVoteSites;
import com.bencodez.votingplugin.config.GUI;
import com.bencodez.votingplugin.config.ShopFile;
import com.bencodez.votingplugin.config.SpecialRewardsConfig;
import com.bencodez.votingplugin.cooldown.CoolDownCheck;
import com.bencodez.votingplugin.data.ServerData;
import com.bencodez.votingplugin.discord.DiscordHandler;
import com.bencodez.votingplugin.listeners.BlockBreak;
import com.bencodez.votingplugin.listeners.PlayerInteract;
import com.bencodez.votingplugin.listeners.PlayerJoinEvent;
import com.bencodez.votingplugin.listeners.PlayerVoteListener;
import com.bencodez.votingplugin.listeners.SignChange;
import com.bencodez.votingplugin.listeners.VotiferEvent;
import com.bencodez.votingplugin.listeners.VotingPluginUpdateEvent;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.placeholders.MVdWPlaceholders;
import com.bencodez.votingplugin.placeholders.PlaceHolders;
import com.bencodez.votingplugin.placeholders.VotingPluginExpansion;
import com.bencodez.votingplugin.servicesites.ServiceSiteHandler;
import com.bencodez.votingplugin.signs.Signs;
import com.bencodez.votingplugin.simpleapi.file.YMLConfig;
import com.bencodez.votingplugin.simpleapi.skull.SkullCache;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.updater.Updater;
import com.bencodez.votingplugin.specialrewards.SpecialRewards;
import com.bencodez.votingplugin.test.VoteTester;
import com.bencodez.votingplugin.timequeue.TimeQueueHandler;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.topvoter.TopVoterHandler;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import com.bencodez.votingplugin.updater.CheckUpdate;
import com.bencodez.votingplugin.user.UserManager;
import com.bencodez.votingplugin.user.VotingPluginUser;
import com.bencodez.votingplugin.voteparty.VoteParty;
import com.bencodez.votingplugin.votereminding.VoteReminding;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.CodeSource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class VotingPluginMain
extends AdvancedCorePlugin {
    public static VotingPluginMain plugin;
    private ArrayList<CommandHandler> adminVoteCommand;
    private LinkedHashMap<UUID, ArrayList<String>> advancedTab = new LinkedHashMap();
    private BroadcastHandler broadcastHandler;
    private BungeeHandler bungeeHandler;
    private BungeeSettings bungeeSettings;
    private CheckUpdate checkUpdate;
    private CommandLoader commandLoader;
    private Config configFile;
    private ConfigVoteSites configVoteSites;
    private CoolDownCheck coolDownCheck;
    private GUI gui;
    private ShopFile shopFile;
    private LinkedHashMap<TopVoterPlayer, Integer> lastMonthTopVoter;
    private LinkedHashMap<YearMonth, LinkedHashMap<TopVoterPlayer, Integer>> previousMonthsTopVoters;
    private MVdWPlaceholders mvdwPlaceholders;
    private PlaceHolders placeholders;
    private VoteTester voteTester;
    private String profile = "";
    private String buildNumber = "NOTSET";
    private ServerData serverData;
    private Signs signs;
    private SpecialRewards specialRewards;
    private SpecialRewardsConfig specialRewardsConfig;
    private String time = "";
    private LinkedHashMap<TopVoter, LinkedHashMap<TopVoterPlayer, Integer>> topVoter;
    private TopVoterHandler topVoterHandler;
    private boolean update = true;
    private Updater updater;
    private boolean updateStarted = false;
    private ArrayList<CommandHandler> voteCommand;
    private Logger voteLog;
    private VoteParty voteParty;
    private VoteReminding voteReminding;
    private List<VoteSite> voteSites;
    private LinkedHashMap<TopVoterPlayer, HashMap<VoteSite, LocalDateTime>> voteToday;
    private boolean votifierLoaded = true;
    private boolean ymlError = false;
    private ScheduledExecutorService voteTimer;
    private UserManager votingPluginUserManager;
    private TimeQueueHandler timeQueueHandler;
    private ServiceSiteHandler serviceSiteHandler;
    private long lastBackgroundTaskTimeTaken = -1L;
    private boolean firstTimeLoaded = false;
    private DiscordHandler discordHandler;

    public void addDirectlyDefinedRewards(DirectlyDefinedReward directlyDefinedReward) {
        this.getRewardHandler().addDirectlyDefined(directlyDefinedReward);
    }

    public void basicBungeeUpdate() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            VotingPluginUser user = this.getVotingPluginUserManager().getVotingPluginUser(player);
            user.cache();
            user.offVote();
            user.checkOfflineRewards();
        }
    }

    public void checkFirstTimeLoaded() {
        if (!this.firstTimeLoaded && this.getGui().isChestVoteTopUseSkull()) {
            int maxToLoad = 200;
            for (TopVoter top : this.topVoter.keySet()) {
                int num = 1;
                Set<TopVoterPlayer> players = this.topVoter.get((Object)top).keySet();
                for (TopVoterPlayer p : players) {
                    if (num <= maxToLoad) {
                        this.getSkullCacheHandler().addToCache(p.getUuid(), p.getPlayerName());
                    }
                    ++num;
                }
            }
        }
        this.firstTimeLoaded = true;
    }

    private void checkVotifier() {
        try {
            Class.forName("com.vexsoftware.votifier.model.VotifierEvent");
        }
        catch (ClassNotFoundException e) {
            if (!this.bungeeSettings.isUseBungeecoord()) {
                plugin.getLogger().warning("No VotifierEvent found, install Votifier, NuVotifier, or another Votifier plugin");
            } else {
                plugin.debug("No VotifierEvent found, but usebungeecoord enabled");
            }
            this.votifierLoaded = false;
        }
    }

    private void checkYMLError() {
        this.ymlError = this.configFile.isFailedToRead() || this.configVoteSites.isFailedToRead() || this.specialRewardsConfig.isFailedToRead() || this.bungeeSettings.isFailedToRead() || this.gui.isFailedToRead();
        if (this.ymlError) {
            plugin.getBukkitScheduler().runTaskLaterAsynchronously((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    plugin.getLogger().severe("Failed to load a file, check startup log");
                }
            }, 1L);
        }
    }

    public ArrayList<TopVoterPlayer> convertSet(Set<TopVoterPlayer> set) {
        return new ArrayList<TopVoterPlayer>(set);
    }

    public FileConfiguration getConfig() {
        return this.configFile.getData();
    }

    public LinkedHashMap<TopVoterPlayer, Integer> getTopVoter(TopVoter top) {
        LinkedHashMap<TopVoterPlayer, Integer> top1 = this.topVoter.get((Object)top);
        if (top1 == null) {
            top1 = new LinkedHashMap();
        }
        return top1;
    }

    @Deprecated
    public VotingPluginUser getUser(UUID uuid) {
        return this.getVotingPluginUserManager().getVotingPluginUser(uuid);
    }

    private YamlConfiguration getVersionFile() {
        try {
            CodeSource src = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource();
            if (src != null) {
                InputStreamReader defConfigStream;
                String name;
                ZipEntry e;
                URL jar = src.getLocation();
                ZipInputStream zip = null;
                zip = new ZipInputStream(jar.openStream());
                while ((e = zip.getNextEntry()) == null || !(name = e.getName()).equals("votingpluginversion.yml") || (defConfigStream = new InputStreamReader(zip)) == null) {
                }
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                ((Reader)defConfigStream).close();
                return defConfig;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public VoteSite getVoteSite(String site, boolean checkEnabled) {
        String siteName = this.getVoteSiteName(checkEnabled, site);
        for (VoteSite voteSite : this.getVoteSites()) {
            if (!voteSite.getKey().equalsIgnoreCase(siteName) && !voteSite.getDisplayName().equals(siteName)) continue;
            return voteSite;
        }
        if (this.configFile.isAutoCreateVoteSites() && !this.configVoteSites.getVoteSitesNames(false).contains(siteName)) {
            this.configVoteSites.generateVoteSite(siteName);
            return new VoteSite(plugin, siteName.replace(".", "_"));
        }
        return null;
    }

    public String getVoteSiteName(boolean checkEnabled, String ... urls) {
        ArrayList<String> sites = this.getConfigVoteSites().getVoteSitesNames(checkEnabled);
        for (String url : urls) {
            if (url == null) {
                return null;
            }
            if (url.isEmpty() || sites == null) continue;
            for (String siteName : sites) {
                String URL2 = this.getConfigVoteSites().getServiceSite(siteName);
                if (URL2 != null && URL2.equalsIgnoreCase(url)) {
                    return siteName;
                }
                if (!siteName.equalsIgnoreCase(url)) continue;
                return siteName;
            }
        }
        int n = 0;
        String[] stringArray = urls;
        int n2 = stringArray.length;
        if (n < n2) {
            String url;
            url = stringArray[n];
            return url;
        }
        return "";
    }

    public ArrayList<VoteSite> getVoteSitesEnabled() {
        ArrayList<VoteSite> sites = new ArrayList<VoteSite>();
        for (VoteSite site : this.getVoteSites()) {
            if (!site.isEnabled()) continue;
            sites.add(site);
        }
        return sites;
    }

    public String getVoteSiteServiceSite(String name) {
        ArrayList<String> sites = this.getConfigVoteSites().getVoteSitesNames(true);
        if (name == null) {
            return null;
        }
        if (sites != null) {
            for (String siteName : sites) {
                String URL2 = this.getConfigVoteSites().getServiceSite(siteName);
                if (URL2 == null || !URL2.equalsIgnoreCase(name) && !name.equalsIgnoreCase(siteName)) continue;
                return URL2;
            }
        }
        return name;
    }

    public boolean hasVoteSite(String site) {
        String siteName = this.getVoteSiteName(false, site);
        for (VoteSite voteSite : this.getVoteSites()) {
            if (!voteSite.getKey().equalsIgnoreCase(siteName) && !voteSite.getDisplayName().equals(siteName)) continue;
            return true;
        }
        return false;
    }

    public boolean isVoteSite(String voteSite) {
        for (VoteSite site : this.getVoteSites()) {
            if (!site.getKey().equalsIgnoreCase(voteSite)) continue;
            return true;
        }
        return false;
    }

    private void loadBungeeHandler() {
        this.bungeeHandler = new BungeeHandler(this);
        this.bungeeHandler.load();
        if (this.getOptions().getServer().equalsIgnoreCase("PleaseSet")) {
            this.getLogger().warning("Bungeecoord is true and server name is not set, bungeecoord features may not work");
        }
    }

    public void loadDirectlyDefined() {
        this.getRewardHandler().getDirectlyDefinedRewards().clear();
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("AllSites"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("AlmostAllSites"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("FirstVote"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("FirstVoteToday"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteReminding.Rewards"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getConfigFile().saveData();
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getConfigFile().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getConfigFile().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getConfigFile().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteCoolDownEndedReward"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("AnySiteRewards"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("EverySiteReward"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getConfigVoteSites().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getConfigVoteSites().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getConfigVoteSites().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getConfigVoteSites().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("LoginRewards"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("LogoutRewards"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteParty.Rewards"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getSpecialRewardsConfig().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getSpecialRewardsConfig().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
            }
        });
        for (String num : this.getSpecialRewardsConfig().getCumulativeVotes()) {
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward("Cumulative." + num + ".Rewards"){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getSpecialRewardsConfig().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getSpecialRewardsConfig().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
                }
            });
        }
        for (String num : this.getSpecialRewardsConfig().getMilestoneVotes()) {
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward("MileStones." + num + ".Rewards"){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getSpecialRewardsConfig().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getSpecialRewardsConfig().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
                }
            });
        }
        for (VoteSite site : plugin.getVoteSites()) {
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteSites." + site.getKey() + ".Rewards"){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getConfigVoteSites().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getConfigVoteSites().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getConfigVoteSites().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getConfigVoteSites().setValue(path, value);
                }
            });
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteSites." + site.getKey() + ".CoolDownEndRewards"){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getConfigVoteSites().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getConfigVoteSites().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getConfigVoteSites().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getConfigVoteSites().setValue(path, value);
                }
            });
        }
        String[] types = new String[]{"Day", "Week", "Month"};
        for (String type : types) {
            for (String str : plugin.getSpecialRewardsConfig().getVoteStreakVotes(type)) {
                this.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteStreak." + type + "." + str + ".Rewards"){

                    @Override
                    public void createSection(String key) {
                        VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
                    }

                    @Override
                    public ConfigurationSection getFileData() {
                        return VotingPluginMain.this.getSpecialRewardsConfig().getData();
                    }

                    @Override
                    public void save() {
                        VotingPluginMain.this.getSpecialRewardsConfig().saveData();
                    }

                    @Override
                    public void setData(String path, Object value) {
                        VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
                    }
                });
            }
        }
        for (String path : plugin.getSpecialRewardsConfig().getMonthlyPossibleRewardPlaces()) {
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward(plugin.getSpecialRewardsConfig().getMonthlyAwardRewardsPath(path)){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getSpecialRewardsConfig().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getSpecialRewardsConfig().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
                }
            });
        }
        for (String path : plugin.getSpecialRewardsConfig().getWeeklyPossibleRewardPlaces()) {
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward(plugin.getSpecialRewardsConfig().getWeeklyAwardRewardsPath(path)){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getSpecialRewardsConfig().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getSpecialRewardsConfig().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
                }
            });
        }
        for (String path : plugin.getSpecialRewardsConfig().getDailyPossibleRewardPlaces()) {
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward(plugin.getSpecialRewardsConfig().getDailyAwardRewardsPath(path)){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getSpecialRewardsConfig().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getSpecialRewardsConfig().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getSpecialRewardsConfig().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getSpecialRewardsConfig().setValue(path, value);
                }
            });
        }
        for (String identifier : plugin.getShopFile().getShopIdentifiers()) {
            this.addDirectlyDefinedRewards(new DirectlyDefinedReward("Shop." + identifier + ".Rewards"){

                @Override
                public void createSection(String key) {
                    VotingPluginMain.this.getShopFile().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return VotingPluginMain.this.getShopFile().getData();
                }

                @Override
                public void save() {
                    VotingPluginMain.this.getShopFile().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    VotingPluginMain.this.getShopFile().setValue(path, value);
                }
            });
        }
        this.addDirectlyDefinedRewards(new DirectlyDefinedReward("BungeeVotePartyRewards"){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.getBungeeSettings().createSection(key);
            }

            @Override
            public ConfigurationSection getFileData() {
                return VotingPluginMain.this.getBungeeSettings().getData();
            }

            @Override
            public void save() {
                VotingPluginMain.this.getBungeeSettings().saveData();
            }

            @Override
            public void setData(String path, Object value) {
                VotingPluginMain.this.getBungeeSettings().setValue(path, value);
            }
        });
        this.getRewardHandler().checkDirectlyDefined();
    }

    private void loadTimer() {
        plugin.getBukkitScheduler().runTaskLaterAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                VotingPluginMain.this.getTimer().scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (plugin != null) {
                            VotingPluginMain.this.update();
                        }
                    }
                }, 1000L, 60000 * VotingPluginMain.this.configFile.getDelayBetweenUpdates(), TimeUnit.MILLISECONDS);
                VotingPluginMain.this.getTimer().scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (plugin != null && VotingPluginMain.this.configFile.isExtraBackgroundUpdate()) {
                            VotingPluginMain.this.basicBungeeUpdate();
                        }
                    }
                }, 1000L, 30000L, TimeUnit.MILLISECONDS);
            }
        }, 2L);
    }

    private void loadVersionFile() {
        YamlConfiguration conf = this.getVersionFile();
        if (conf != null) {
            this.time = conf.getString("time", "");
            this.profile = conf.getString("profile", "");
            this.buildNumber = conf.getString("buildnumber", "NOTSET");
        }
    }

    public void loadVoteSites() {
        this.configVoteSites.setup();
        this.voteSites = Collections.synchronizedList(new ArrayList());
        this.voteSites.addAll(this.configVoteSites.getVoteSitesLoad());
        if (this.voteSites.size() == 0) {
            plugin.getLogger().warning("Detected no voting sites, this may mean something isn't properly setup");
        }
        plugin.debug("Loaded VoteSites");
    }

    private void loadVoteTimer() {
        this.voteTimer = Executors.newSingleThreadScheduledExecutor();
    }

    public void logVote(LocalDateTime date, String playerName, String voteSite) {
        if (this.configFile.isLogVotesToFile()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            String str = formatter.format(date);
            this.voteLog.logToFile(str + ": " + playerName + " voted on " + voteSite);
        }
    }

    private void metrics() {
        new VotingPluginMetrics().load(plugin);
    }

    @Override
    public void onPostLoad() {
        if (plugin.getShopFile().isJustCreated()) {
            if (!plugin.getGui().isJustCreated() && !this.getServerData().isVoteShopConverted()) {
                plugin.getLogger().warning("Converting VoteShop configuration to Shop.yml from GUI.yml");
                plugin.getShopFile().convertFromGUIFile();
            }
            this.getServerData().setShopConverted(true);
        } else if (!this.getServerData().isVoteShopConverted()) {
            this.getServerData().setShopConverted(true);
        }
        this.loadVersionFile();
        this.getOptions().setServer(this.bungeeSettings.getServer());
        this.getVotingPluginUserManager().purgeOldPlayersNoData();
        this.voteTester = new VoteTester(plugin);
        this.loadVoteTimer();
        if (this.bungeeSettings.isUseBungeecoord()) {
            this.loadBungeeHandler();
        }
        if (!this.bungeeSettings.isUseBungeecoord() || !this.bungeeSettings.isGloblalDataEnabled()) {
            this.timeQueueHandler = new TimeQueueHandler(this);
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null && this.getConfigFile().isLoadInteralExpansion()) {
            new VotingPluginExpansion(this).register();
            this.getLogger().info("Loading PlaceholderAPI expansion");
        }
        this.registerCommands();
        this.checkVotifier();
        this.registerEvents();
        this.loadDirectlyDefined();
        this.checkUpdate = new CheckUpdate(this);
        this.checkUpdate.startUp();
        this.voteReminding = new VoteReminding(this);
        this.voteReminding.loadRemindChecking();
        this.voteReminding.loadReminds();
        this.specialRewards = new SpecialRewards(this);
        this.signs = new Signs(this);
        this.coolDownCheck.checkEnabled();
        this.coolDownCheck.load();
        plugin.getBukkitScheduler().runTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                VotingPluginMain.this.signs.loadSigns();
            }
        });
        this.topVoterHandler = new TopVoterHandler(this);
        this.lastMonthTopVoter = new LinkedHashMap();
        this.previousMonthsTopVoters = new LinkedHashMap();
        plugin.getBukkitScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                VotingPluginMain.this.topVoterHandler.loadLastMonth();
                VotingPluginMain.this.debug("Loaded last month top voters");
                VotingPluginMain.this.topVoterHandler.loadPreviousMonthTopVoters();
            }
        });
        this.topVoter = new LinkedHashMap();
        for (final TopVoter top : TopVoter.values()) {
            this.topVoter.put(top, new LinkedHashMap());
        }
        this.voteToday = new LinkedHashMap();
        this.voteLog = new Logger((Plugin)plugin, new File(plugin.getDataFolder() + File.separator + "Log", "votelog.txt"));
        new AdminGUI(this).loadHook();
        this.voteParty = new VoteParty(this);
        this.voteParty.register();
        this.topVoterHandler.register();
        plugin.getBukkitScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                VotingPluginMain.this.metrics();
            }
        });
        this.getJavascriptEngineRequests().add(new JavascriptPlaceholderRequest("User"){

            @Override
            public Object getObject(OfflinePlayer player) {
                return VotingPluginMain.this.getVotingPluginUserManager().getVotingPluginUser(player);
            }
        });
        this.getJavascriptEngine().put("VotingPluginHooks", VotingPluginHooks.getInstance());
        this.getJavascriptEngine().put("VotingPlugin", (Object)this);
        this.loadTimer();
        this.placeholders = new PlaceHolders(this);
        this.getServerData().updatePlaceholders();
        this.placeholders.load();
        if (Bukkit.getPluginManager().isPluginEnabled("MVdWPlaceholderAPI")) {
            this.mvdwPlaceholders = new MVdWPlaceholders(this);
            this.mvdwPlaceholders.loadMVdWPlaceholders();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("DiscordSRV") && this.configFile.isDiscordSRVEnabled()) {
            this.discordHandler = new DiscordHandler(this);
            this.discordHandler.load();
            this.debug("DiscordSRV enabled, loading DiscordSRV handler");
        }
        this.getRewardHandler().addInjectedReward(new RewardInjectInt("Points", 0){

            @Override
            public String onRewardRequest(Reward reward, AdvancedCoreUser user, int num, HashMap<String, String> placeholders) {
                VotingPluginUser vpUser = VotingPluginMain.this.getVotingPluginUserManager().getVotingPluginUser(user);
                String str = "" + vpUser.addPoints(num);
                this.debug("Setting points to " + str);
                return str;
            }
        }.synchronize().asPlaceholder("newpoints").addEditButton(new EditGUIButton(new ItemBuilder(Material.PAPER), new EditGUIValueNumber("Points", null){

            @Override
            public void setValue(Player player, Number value) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                reward.setValue("Points", value.intValue());
            }
        }.addLore("Give player voting points"))).validator(new RewardInjectValidator(){

            @Override
            public void onValidate(Reward reward, RewardInject inject, ConfigurationSection data) {
                if (data.getInt(inject.getPath(), -1) == 0) {
                    this.warning(reward, inject, "Points can not be 0");
                }
            }
        }));
        this.getRewardHandler().addInjectedReward(new RewardInjectConfigurationSection("VoteBossBar"){

            @Override
            public String onRewardRequested(Reward arg0, AdvancedCoreUser user, ConfigurationSection section, HashMap<String, String> placeholders) {
                if (section.getBoolean("Enabled")) {
                    user.sendBossBar(PlaceholderUtils.replacePlaceHolder(section.getString("Message", ""), placeholders), section.getString("Color", "BLUE"), section.getString("Style", "SOLID"), (double)VotingPluginMain.this.getVotingPluginUserManager().getVotingPluginUser(user).getSitesVotedOn() / (double)plugin.getVoteSites().size(), section.getInt("Delay", 30));
                }
                return null;
            }
        });
        this.getRewardHandler().addInjectedRequirements(new RequirementInjectConfigurationSection("VoteTotal"){

            @Override
            public boolean onRequirementsRequested(Reward reward, AdvancedCoreUser acUser, ConfigurationSection section, RewardOptions rewardOptions) {
                int pointsRequired;
                boolean atleast = section.getBoolean("AtleastMode", false);
                VotingPluginUser user = plugin.getVotingPluginUserManager().getVotingPluginUser(acUser);
                for (TopVoter top : TopVoter.values()) {
                    int required = section.getInt(top.toString(), -1);
                    if (required < 0) continue;
                    int total = user.getTotal(top);
                    if (atleast) {
                        if (total >= required) continue;
                        this.debug("Failed requirement " + top.toString() + " " + total + "/" + required);
                        return false;
                    }
                    if (total == required) continue;
                    this.debug("Failed requirement " + top.toString() + " " + total + "!=" + required);
                    return false;
                }
                int milestoneCountRequired = section.getInt("MilestoneCount", -1);
                if (milestoneCountRequired >= 0) {
                    int milestoneCount = user.getMilestoneCount();
                    if (atleast) {
                        if (milestoneCount < milestoneCountRequired) {
                            this.debug("Failed requirement milestonecount " + milestoneCount + "/" + milestoneCountRequired);
                            return false;
                        }
                    } else if (milestoneCount != milestoneCountRequired) {
                        this.debug("Failed requirement milestonecount " + milestoneCount + "!=" + milestoneCountRequired);
                        return false;
                    }
                }
                if ((pointsRequired = section.getInt("Points", -1)) >= 0) {
                    int points = user.getPoints();
                    if (atleast) {
                        if (points < pointsRequired) {
                            this.debug("Failed requirement points " + points + "/" + pointsRequired);
                            return false;
                        }
                    } else if (points != pointsRequired) {
                        this.debug("Failed requirement points " + points + "!=" + pointsRequired);
                        return false;
                    }
                }
                return true;
            }
        });
        for (final TopVoter top : TopVoter.values()) {
            this.getRewardHandler().addPlaceholder(new RewardPlaceholderHandle("Total_" + top.toString()){

                @Override
                public String getValue(Reward reward, AdvancedCoreUser user) {
                    VotingPluginUser vUser = VotingPluginMain.this.getVotingPluginUserManager().getVotingPluginUser(user);
                    return "" + vUser.getTotal(top);
                }
            });
        }
        if (plugin.getConfigFile().isFormatAlternateBroadcastEnabled()) {
            this.broadcastHandler = new BroadcastHandler(plugin, plugin.getConfigFile().getFormatAlternateBroadcastDelay());
            plugin.debug("Using alternate broadcast method");
        }
        plugin.getLogger().info("Enabled VotingPlugin " + plugin.getDescription().getVersion());
        if (plugin.getDescription().getVersion().contains("SNAPSHOT")) {
            plugin.getLogger().info("Using dev build, this is not a stable build, use at your own risk. Build number: " + this.buildNumber);
        }
        boolean hasRewards = this.getRewardHandler().hasRewards(this.getConfigVoteSites().getData(), this.getConfigVoteSites().getEverySiteRewardPath());
        boolean issues = true;
        ArrayList<String> services = this.serverData.getServiceSites();
        for (VoteSite site : this.getVoteSites()) {
            if (!site.hasRewards() && !hasRewards) {
                issues = false;
                plugin.getLogger().warning("No rewards detected for the site: " + site.getKey() + ". See https://github.com/BenCodez/VotingPlugin/wiki/Rewards");
            }
            boolean contains = false;
            for (String service : services) {
                if (!service.equalsIgnoreCase(site.getServiceSite())) continue;
                contains = true;
            }
            if (contains) continue;
            issues = false;
            plugin.getLogger().warning("No vote has been recieved from " + site.getServiceSite() + ", may be an invalid service site. Please read: https://github.com/BenCodez/VotingPlugin/wiki/Votifier-Troubleshooting");
        }
        if (!issues) {
            plugin.getBukkitScheduler().runTaskLaterAsynchronously((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    plugin.getLogger().warning("Detected an issue with voting sites, check the server startup log for more details: https://github.com/BenCodez/VotingPlugin/wiki/Votifier-Troubleshooting");
                }
            }, 5L);
            plugin.getBukkitScheduler().runTaskLaterAsynchronously((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    VotingPluginMain.this.serviceSiteHandler = new ServiceSiteHandler(plugin);
                }
            }, 10L);
        }
    }

    @Override
    public void onPreLoad() {
        plugin = this;
        this.setupFiles();
        this.loadVoteSites();
        this.votingPluginUserManager = new UserManager(this);
        this.votingPluginUserManager.addCachingKeys();
        this.setJenkinsSite("bencodez.com");
        this.updateAdvancedCoreHook();
    }

    @Override
    public void onUnLoad() {
        if (this.bungeeSettings.isUseBungeecoord()) {
            try {
                this.getBungeeHandler().close();
            }
            catch (Exception e) {
                this.debug(e);
            }
        }
        this.voteTimer.shutdown();
        try {
            this.voteTimer.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.voteTimer.shutdownNow();
        if (this.timeQueueHandler != null) {
            this.timeQueueHandler.save();
        }
        this.getSigns().storeSigns();
        HandlerList.unregisterAll((Plugin)plugin);
        plugin = null;
    }

    private void registerCommands() {
        this.commandLoader = new CommandLoader(this);
        this.commandLoader.loadCommands();
        this.commandLoader.loadAliases();
        this.getCommand("vote").setExecutor((CommandExecutor)new CommandVote(this));
        this.getCommand("vote").setTabCompleter((TabCompleter)new VoteTabCompleter());
        this.getCommand("adminvote").setExecutor((CommandExecutor)new CommandAdminVote(this));
        this.getCommand("adminvote").setTabCompleter((TabCompleter)new AdminVoteTabCompleter());
        this.getCommand("adminvote").setPermission("VotingPlugin.Commands.AdminVote");
        this.getCommand("av").setExecutor((CommandExecutor)new CommandAdminVote(this));
        this.getCommand("av").setTabCompleter((TabCompleter)new AdminVoteTabCompleter());
        this.getCommand("av").setPermission("VotingPlugin.Commands.AdminVote");
        Permission perm = Bukkit.getPluginManager().getPermission("VotingPlugin.Player");
        if (perm != null) {
            if (this.configFile.isGiveDefaultPermission()) {
                perm.setDefault(PermissionDefault.TRUE);
                this.getLogger().info("Giving VotingPlugin.Player permission by default, can be disabled in the config");
            } else {
                perm.setDefault(PermissionDefault.OP);
            }
        }
        plugin.debug("Loaded Commands");
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerJoinEvent(this), (Plugin)this);
        if (this.votifierLoaded) {
            pm.registerEvents((Listener)new VotiferEvent(this), (Plugin)this);
        }
        pm.registerEvents((Listener)new PlayerVoteListener(this), (Plugin)this);
        pm.registerEvents((Listener)new SignChange(this), (Plugin)this);
        pm.registerEvents((Listener)new BlockBreak(this), (Plugin)this);
        if (!plugin.getConfigFile().isDisableInteractEvent()) {
            pm.registerEvents((Listener)new PlayerInteract(this), (Plugin)this);
        }
        if (this.timeQueueHandler != null) {
            pm.registerEvents((Listener)this.timeQueueHandler, (Plugin)plugin);
        }
        pm.registerEvents((Listener)new VotingPluginUpdateEvent(this), (Plugin)this);
        this.coolDownCheck = new CoolDownCheck(this);
        pm.registerEvents((Listener)this.coolDownCheck, (Plugin)this);
        plugin.debug("Loaded Events");
    }

    @Override
    public void reload() {
        this.reloadPlugin(false);
    }

    public void reloadAll() {
        this.reloadPlugin(true);
    }

    private void reloadPlugin(boolean userStorage) {
        this.configFile.reloadData();
        this.configFile.loadValues();
        this.configVoteSites.reloadData();
        this.specialRewardsConfig.reloadData();
        this.gui.reloadData();
        this.shopFile.reloadData();
        this.bungeeSettings.reloadData();
        this.updateAdvancedCoreHook();
        this.reloadAdvancedCore(userStorage);
        if (this.bungeeSettings.isUseBungeecoord()) {
            if (this.getBungeeHandler() == null) {
                this.loadBungeeHandler();
            }
            if (userStorage) {
                this.getBungeeHandler().loadGlobalMysql();
            }
        }
        this.checkYMLError();
        if (this.broadcastHandler != null) {
            this.broadcastHandler.schedule(this.getConfigFile().getFormatAlternateBroadcastDelay());
        }
        plugin.loadVoteSites();
        this.getOptions().setServer(this.bungeeSettings.getServer());
        if (userStorage) {
            this.placeholders.load();
            this.placeholders.reload();
            this.getCoolDownCheck().getTimer().schedule(new Runnable(){

                @Override
                public void run() {
                    for (VoteSite site : plugin.getVoteSites()) {
                        if (!site.isVoteDelayDaily()) continue;
                        VotingPluginMain.this.getCoolDownCheck().checkAllVoteSite(site);
                    }
                }
            }, 5L, TimeUnit.SECONDS);
        }
        this.voteReminding.loadRemindChecking();
        this.coolDownCheck.checkEnabled();
        this.loadDirectlyDefined();
        this.setUpdate(true);
    }

    private void setupFiles() {
        this.configFile = new Config(this);
        this.configFile.setup();
        this.configVoteSites = new ConfigVoteSites(this);
        this.configVoteSites.setup();
        this.specialRewardsConfig = new SpecialRewardsConfig(this);
        this.specialRewardsConfig.setup();
        this.bungeeSettings = new BungeeSettings(this);
        this.bungeeSettings.setup();
        this.serverData = new ServerData(this);
        this.gui = new GUI(this);
        this.gui.setup();
        this.shopFile = new ShopFile(this);
        this.shopFile.setup();
        this.checkYMLError();
        plugin.debug("Loaded Files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (!(!this.update && !this.configFile.isAlwaysUpdate() || this.updateStarted || plugin == null || this.configFile.isUpdateWithPlayersOnlineOnly() && Bukkit.getOnlinePlayers().size() == 0)) {
            this.updateStarted = true;
            this.update = false;
            VotingPluginMain votingPluginMain = plugin;
            synchronized (votingPluginMain) {
                if (plugin != null && plugin.isEnabled()) {
                    this.getUserManager().getDataManager().clearCacheBasic();
                    SkullCache.flushWeek();
                    plugin.debug("Starting background task, current cached users: " + ((ConcurrentHashMap.CollectionView)((Object)plugin.getUserManager().getDataManager().getUserDataCache().keySet())).size());
                    try {
                        long totalTime;
                        boolean extraBackgroundUpdate = this.configFile.isExtraBackgroundUpdate();
                        long startTime = System.currentTimeMillis();
                        LinkedHashMap<TopVoterPlayer, HashMap<VoteSite, LocalDateTime>> voteToday = new LinkedHashMap<TopVoterPlayer, HashMap<VoteSite, LocalDateTime>>();
                        LinkedHashMap<TopVoter, LinkedHashMap<TopVoterPlayer, Integer>> tempTopVoter = new LinkedHashMap<TopVoter, LinkedHashMap<TopVoterPlayer, Integer>>();
                        ArrayList<TopVoter> topVotersToCheck = new ArrayList<TopVoter>();
                        for (TopVoter top : TopVoter.values()) {
                            if (plugin == null) {
                                return;
                            }
                            if (!plugin.getConfigFile().getLoadTopVoter(top)) continue;
                            topVotersToCheck.add(top);
                            tempTopVoter.put(top, new LinkedHashMap());
                        }
                        boolean topVoterIgnorePermissionUse = plugin.getConfigFile().isTopVoterIgnorePermission();
                        ArrayList<String> blackList = plugin.getConfigFile().getBlackList();
                        int currentDay = LocalDateTime.now().getDayOfMonth();
                        HashMap<UUID, ArrayList<Column>> cols = plugin.getUserManager().getAllKeys();
                        long time1 = (System.currentTimeMillis() - startTime) / 1000L;
                        plugin.debug("Finished getting player data in " + time1 + " seconds, " + cols.size() + " users, " + plugin.getStorageType().toString());
                        time1 = System.currentTimeMillis();
                        for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                            String uuid = playerData.getKey().toString();
                            if (plugin == null || !plugin.isEnabled()) {
                                return;
                            }
                            if (uuid == null || uuid.isEmpty()) continue;
                            VotingPluginUser user = this.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), false);
                            user.dontCache();
                            user.updateTempCacheWithColumns(playerData.getValue());
                            cols.put(playerData.getKey(), null);
                            if (!user.isBanned() && !blackList.contains(user.getPlayerName())) {
                                if (!topVoterIgnorePermissionUse || !user.isTopVoterIgnore()) {
                                    for (TopVoter top : topVotersToCheck) {
                                        int total = user.getTotal(top);
                                        if (total <= 0) continue;
                                        tempTopVoter.get((Object)top).put(user.getTopVoterPlayer(), total);
                                    }
                                }
                                HashMap<VoteSite, LocalDateTime> times = new HashMap<VoteSite, LocalDateTime>();
                                for (Map.Entry<VoteSite, Long> entry : user.getLastVotes().entrySet()) {
                                    if (!entry.getKey().isEnabled() || entry.getKey().isHidden()) continue;
                                    long time = entry.getValue();
                                    if (currentDay != MiscUtils.getInstance().getDayFromMili(time) || LocalDateTime.now().getMonthValue() != MiscUtils.getInstance().getMonthFromMili(time) || LocalDateTime.now().getYear() != MiscUtils.getInstance().getYearFromMili(time)) continue;
                                    times.put(entry.getKey(), LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
                                }
                                if (times.keySet().size() > 0) {
                                    voteToday.put(user.getTopVoterPlayer(), times);
                                }
                            }
                            if (extraBackgroundUpdate && user.isOnline()) {
                                user.offVote();
                            }
                            if (plugin != null && (!plugin.getPlaceholders().getCacheLevel().onlineOnly() || user.isOnline())) {
                                plugin.getPlaceholders().onUpdate(user, false);
                            }
                            user.clearTempCache();
                            user = null;
                        }
                        cols.clear();
                        cols = null;
                        this.topVoterHandler.updateTopVoters(tempTopVoter);
                        this.placeholders.onUpdate();
                        this.setVoteToday(voteToday);
                        this.serverData.updateValues();
                        this.getSigns().updateSigns();
                        this.checkFirstTimeLoaded();
                        if (this.discordHandler != null) {
                            plugin.extraDebug("Attempting to update DiscordSRV leaderboard");
                            this.discordHandler.updateDiscordLeaderboard();
                        }
                        plugin.getUserManager().getDataManager().clearNonNeededCachedUsers();
                        plugin.extraDebug("Current cached users: " + ((ConcurrentHashMap.CollectionView)((Object)plugin.getUserManager().getDataManager().getUserDataCache().keySet())).size());
                        this.update = false;
                        tempTopVoter = null;
                        time1 = (System.currentTimeMillis() - time1) / 1000L;
                        this.lastBackgroundTaskTimeTaken = totalTime = (System.currentTimeMillis() - startTime) / 1000L;
                        plugin.debug("Background task finished. Final processing took " + time1 + " seconds. Total time: " + totalTime + " seconds");
                    }
                    catch (Exception ex) {
                        if (plugin != null) {
                            plugin.getLogger().info("Looks like something went wrong");
                        }
                        ex.printStackTrace();
                    }
                }
            }
            this.updateStarted = false;
        }
    }

    public void updateAdvancedCoreHook() {
        this.getJavascriptEngine().put("VotingPlugin", (Object)this);
        this.allowDownloadingFromSpigot(15358);
        this.setConfigData(new YMLConfig(this, (ConfigurationSection)this.configFile.getData()){

            @Override
            public void createSection(String key) {
                VotingPluginMain.this.configFile.createSection(key);
            }

            @Override
            public void saveData() {
                VotingPluginMain.this.configFile.saveData();
            }

            @Override
            public void setValue(String path, Object value) {
                VotingPluginMain.this.configFile.setValue(path, value);
            }
        });
        if (this.bungeeSettings.isUseBungeecoord()) {
            this.getOptions().setPerServerRewards(this.getBungeeSettings().isPerServerRewards());
        }
    }

    @Generated
    public static VotingPluginMain getPlugin() {
        return plugin;
    }

    @Generated
    public ArrayList<CommandHandler> getAdminVoteCommand() {
        return this.adminVoteCommand;
    }

    @Generated
    public void setAdminVoteCommand(ArrayList<CommandHandler> adminVoteCommand) {
        this.adminVoteCommand = adminVoteCommand;
    }

    @Generated
    public LinkedHashMap<UUID, ArrayList<String>> getAdvancedTab() {
        return this.advancedTab;
    }

    @Generated
    public BroadcastHandler getBroadcastHandler() {
        return this.broadcastHandler;
    }

    @Generated
    public BungeeHandler getBungeeHandler() {
        return this.bungeeHandler;
    }

    @Generated
    public BungeeSettings getBungeeSettings() {
        return this.bungeeSettings;
    }

    @Generated
    public CheckUpdate getCheckUpdate() {
        return this.checkUpdate;
    }

    @Generated
    public CommandLoader getCommandLoader() {
        return this.commandLoader;
    }

    @Generated
    public Config getConfigFile() {
        return this.configFile;
    }

    @Generated
    public ConfigVoteSites getConfigVoteSites() {
        return this.configVoteSites;
    }

    @Generated
    public CoolDownCheck getCoolDownCheck() {
        return this.coolDownCheck;
    }

    @Generated
    public GUI getGui() {
        return this.gui;
    }

    @Generated
    public ShopFile getShopFile() {
        return this.shopFile;
    }

    @Generated
    public LinkedHashMap<TopVoterPlayer, Integer> getLastMonthTopVoter() {
        return this.lastMonthTopVoter;
    }

    @Generated
    public LinkedHashMap<YearMonth, LinkedHashMap<TopVoterPlayer, Integer>> getPreviousMonthsTopVoters() {
        return this.previousMonthsTopVoters;
    }

    @Generated
    public void setPreviousMonthsTopVoters(LinkedHashMap<YearMonth, LinkedHashMap<TopVoterPlayer, Integer>> previousMonthsTopVoters) {
        this.previousMonthsTopVoters = previousMonthsTopVoters;
    }

    @Generated
    public MVdWPlaceholders getMvdwPlaceholders() {
        return this.mvdwPlaceholders;
    }

    @Generated
    public PlaceHolders getPlaceholders() {
        return this.placeholders;
    }

    @Generated
    public VoteTester getVoteTester() {
        return this.voteTester;
    }

    @Generated
    public String getProfile() {
        return this.profile;
    }

    @Generated
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Generated
    public ServerData getServerData() {
        return this.serverData;
    }

    @Generated
    public Signs getSigns() {
        return this.signs;
    }

    @Generated
    public void setSigns(Signs signs) {
        this.signs = signs;
    }

    @Generated
    public SpecialRewards getSpecialRewards() {
        return this.specialRewards;
    }

    @Generated
    public SpecialRewardsConfig getSpecialRewardsConfig() {
        return this.specialRewardsConfig;
    }

    @Generated
    public String getTime() {
        return this.time;
    }

    @Generated
    public LinkedHashMap<TopVoter, LinkedHashMap<TopVoterPlayer, Integer>> getTopVoter() {
        return this.topVoter;
    }

    @Generated
    public void setTopVoter(LinkedHashMap<TopVoter, LinkedHashMap<TopVoterPlayer, Integer>> topVoter) {
        this.topVoter = topVoter;
    }

    @Generated
    public TopVoterHandler getTopVoterHandler() {
        return this.topVoterHandler;
    }

    @Generated
    public boolean isUpdate() {
        return this.update;
    }

    @Generated
    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Generated
    public Updater getUpdater() {
        return this.updater;
    }

    @Generated
    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    @Generated
    public boolean isUpdateStarted() {
        return this.updateStarted;
    }

    @Generated
    public ArrayList<CommandHandler> getVoteCommand() {
        return this.voteCommand;
    }

    @Generated
    public void setVoteCommand(ArrayList<CommandHandler> voteCommand) {
        this.voteCommand = voteCommand;
    }

    @Generated
    public Logger getVoteLog() {
        return this.voteLog;
    }

    @Generated
    public VoteParty getVoteParty() {
        return this.voteParty;
    }

    @Generated
    public VoteReminding getVoteReminding() {
        return this.voteReminding;
    }

    @Generated
    public List<VoteSite> getVoteSites() {
        return this.voteSites;
    }

    @Generated
    public LinkedHashMap<TopVoterPlayer, HashMap<VoteSite, LocalDateTime>> getVoteToday() {
        return this.voteToday;
    }

    @Generated
    public void setVoteToday(LinkedHashMap<TopVoterPlayer, HashMap<VoteSite, LocalDateTime>> voteToday) {
        this.voteToday = voteToday;
    }

    @Generated
    public boolean isYmlError() {
        return this.ymlError;
    }

    @Generated
    public ScheduledExecutorService getVoteTimer() {
        return this.voteTimer;
    }

    @Generated
    public UserManager getVotingPluginUserManager() {
        return this.votingPluginUserManager;
    }

    @Generated
    public TimeQueueHandler getTimeQueueHandler() {
        return this.timeQueueHandler;
    }

    @Generated
    public ServiceSiteHandler getServiceSiteHandler() {
        return this.serviceSiteHandler;
    }

    @Generated
    public long getLastBackgroundTaskTimeTaken() {
        return this.lastBackgroundTaskTimeTaken;
    }

    @Generated
    public DiscordHandler getDiscordHandler() {
        return this.discordHandler;
    }
}

