/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalDataHandler;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalMySQL;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.proxy.BungeeMessageData;
import com.bencodez.votingplugin.proxy.BungeeMethod;
import com.bencodez.votingplugin.proxy.BungeeVersion;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.encryption.EncryptionHandler;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.servercomm.global.GlobalMessageHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.global.GlobalMessageListener;
import com.bencodez.votingplugin.simpleapi.servercomm.mqtt.MqttHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.mqtt.MqttServerComm;
import com.bencodez.votingplugin.simpleapi.servercomm.mysql.BackendMessenger;
import com.bencodez.votingplugin.simpleapi.servercomm.pluginmessage.PluginMessageHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.redis.RedisHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.redis.RedisListener;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.ClientHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketHandler;
import com.bencodez.votingplugin.simpleapi.servercomm.sockets.SocketReceiver;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueBoolean;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfigSpigot;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.io.File;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.eclipse.paho.client.mqttv3.MqttException;

public class BungeeHandler
implements Listener {
    private ClientHandler clientHandler;
    private EncryptionHandler encryptionHandler;
    private BungeeMethod method;
    private VotingPluginMain plugin;
    private int bungeeVotePartyCurrent = -2;
    private int bungeeVotePartyRequired = -2;
    private SocketHandler socketHandler;
    private GlobalDataHandler globalDataHandler;
    private ScheduledExecutorService timer;
    private RedisHandler redisHandler;
    private GlobalMessageHandler globalMessageHandler;
    private Thread redisThread;
    private BackendMessenger backendMysqlMessenger;
    private MqttHandler mqttHandler;

    public BungeeHandler(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void checkGlobalData() {
        boolean b;
        HashMap<String, DataValue> data = this.globalDataHandler.getExact(this.plugin.getBungeeSettings().getServer());
        if (data.containsKey("ForceUpdate") && (b = this.checkGlobalDataTimeValue(data.get("ForceUpdate")))) {
            if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
                this.plugin.getMysql().clearCacheBasic();
            }
            this.plugin.getUserManager().getDataManager().clearCache();
            this.plugin.setUpdate(true);
            this.plugin.update();
            this.globalDataHandler.setBoolean(this.plugin.getBungeeSettings().getServer(), "ForceUpdate", false);
        }
        boolean forceUpdate = false;
        if (this.checkGlobalDataTime(TimeType.MONTH, data)) {
            forceUpdate = true;
        }
        if (this.checkGlobalDataTime(TimeType.WEEK, data)) {
            forceUpdate = true;
        }
        if (this.checkGlobalDataTime(TimeType.DAY, data)) {
            forceUpdate = true;
        }
        if (forceUpdate) {
            HashMap<String, DataValue> dataToSet = new HashMap<String, DataValue>();
            dataToSet.put("FinishedProcessing", new DataValueBoolean(true));
            dataToSet.put("Processing", new DataValueBoolean(false));
            this.globalDataHandler.setData(this.plugin.getBungeeSettings().getServer(), dataToSet);
        }
    }

    public boolean checkGlobalDataTime(TimeType type, HashMap<String, DataValue> data) {
        DataValue value;
        boolean b;
        boolean isProcessing = false;
        if (data.containsKey(type.toString()) && (b = this.checkGlobalDataTimeValue(value = data.get(type.toString())))) {
            long lastUpdated = Long.valueOf(data.get("LastUpdated").getString());
            this.plugin.debug("LastUpdated: " + lastUpdated);
            if (LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant().toEpochMilli() - lastUpdated > 0x6DDD00L) {
                this.plugin.getLogger().warning("Ignoring bungee time change since it was more than 2 hours ago");
                this.globalDataHandler.setBoolean(this.plugin.getBungeeSettings().getServer(), type.toString(), false);
                return false;
            }
            this.globalDataHandler.setBoolean(this.plugin.getBungeeSettings().getServer(), "Processing", true);
            isProcessing = true;
            this.plugin.debug("Detected time change from bungee: " + type.toString());
            this.plugin.getTimeChecker().forceChanged(type, false, true, true);
            this.globalDataHandler.setBoolean(this.plugin.getBungeeSettings().getServer(), type.toString(), false);
            this.getGlobalMessageHandler().sendMessage("TimeChangeFinished", "" + this.plugin.getBungeeSettings().getServer());
        }
        return isProcessing;
    }

    public boolean checkGlobalDataTimeValue(DataValue data) {
        if (data.isBoolean()) {
            return data.getBoolean();
        }
        return Boolean.valueOf(data.getString());
    }

    public void close() {
        if (this.backendMysqlMessenger != null) {
            this.backendMysqlMessenger.shutdown();
        }
        if (this.socketHandler != null) {
            this.socketHandler.closeConnection();
        }
        if (this.clientHandler != null) {
            this.clientHandler.stopConnection();
        }
        this.plugin.getServerData().setBungeeVotePartyCurrent(this.bungeeVotePartyCurrent);
        this.plugin.getServerData().setBungeeVotePartyRequired(this.bungeeVotePartyRequired);
        if (this.globalDataHandler != null) {
            this.globalDataHandler.getGlobalMysql().close();
        }
    }

    public void load() {
        this.plugin.debug("Loading bungee handler");
        this.method = BungeeMethod.getByName(this.plugin.getBungeeSettings().getBungeeMethod());
        this.plugin.getLogger().info("Using BungeeMethod: " + this.method.toString());
        this.loadGlobalMysql();
        this.globalMessageHandler = new GlobalMessageHandler(){

            @Override
            public void sendMessage(String subChannel, String ... messageData) {
                if (BungeeHandler.this.method.equals((Object)BungeeMethod.MYSQL)) {
                    try {
                        BungeeHandler.this.backendMysqlMessenger.sendToProxy(subChannel + "%l%" + String.join((CharSequence)"%l%", messageData));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else if (BungeeHandler.this.method.equals((Object)BungeeMethod.PLUGINMESSAGING)) {
                    BungeeHandler.this.plugin.getPluginMessaging().sendPluginMessage(subChannel, messageData);
                } else if (BungeeHandler.this.method.equals((Object)BungeeMethod.SOCKETS)) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(subChannel);
                    list.addAll(ArrayUtils.convert(messageData));
                    BungeeHandler.this.sendData(ArrayUtils.convert(list));
                } else if (BungeeHandler.this.method.equals((Object)BungeeMethod.REDIS)) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(subChannel);
                    list.addAll(ArrayUtils.convert(messageData));
                    BungeeHandler.this.redisHandler.sendMessage(BungeeHandler.this.plugin.getBungeeSettings().getRedisPrefix() + "VotingPlugin", ArrayUtils.convert(list));
                } else if (BungeeHandler.this.method.equals((Object)BungeeMethod.MQTT)) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(subChannel);
                    list.addAll(ArrayUtils.convert(messageData));
                    try {
                        BungeeHandler.this.mqttHandler.publish(BungeeHandler.this.plugin.getBungeeSettings().getMqttPrefix() + "votingplugin/servers/proxy", String.join((CharSequence)":", list));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.globalMessageHandler.addListener(new GlobalMessageListener("Vote"){

            @Override
            public void onReceive(ArrayList<String> args) {
                if (args.size() > 8) {
                    int bungeeVersion = Integer.parseInt(args.get(8));
                    if (bungeeVersion != BungeeVersion.getPluginMessageVersion()) {
                        BungeeHandler.this.plugin.getLogger().warning("Incompatible version with bungee, please update all servers" + bungeeVersion + ":" + BungeeVersion.getPluginMessageVersion());
                        return;
                    }
                    String player = args.get(0);
                    String uuid = args.get(1);
                    String service = args.get(2);
                    long time = Long.parseLong(args.get(3));
                    BungeeHandler.this.plugin.debug("pluginmessaging vote received from " + player + "/" + uuid + " on " + service);
                    VotingPluginUser user = BungeeHandler.this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), player);
                    boolean wasOnline = Boolean.valueOf(args.get(4));
                    BungeeMessageData text = new BungeeMessageData(args.get(6));
                    BungeeHandler.this.bungeeVotePartyCurrent = text.getVotePartyCurrent();
                    BungeeHandler.this.bungeeVotePartyRequired = text.getVotePartyRequired();
                    BungeeHandler.this.plugin.getPlaceholders().onBungeeVotePartyUpdate();
                    BungeeHandler.this.plugin.getServerData().setBungeeVotePartyCurrent(BungeeHandler.this.bungeeVotePartyCurrent);
                    BungeeHandler.this.plugin.getServerData().setBungeeVotePartyRequired(BungeeHandler.this.bungeeVotePartyRequired);
                    boolean setTotals = Boolean.valueOf(args.get(7));
                    user.cache();
                    boolean broadcast = true;
                    boolean bungeeBroadcast = false;
                    if (args.size() > 9) {
                        bungeeBroadcast = Boolean.valueOf(args.get(9));
                    }
                    int num = 1;
                    if (args.size() > 10) {
                        num = Integer.valueOf(args.get(10));
                    }
                    int numberOfVotes = 1;
                    if (args.size() > 11) {
                        numberOfVotes = Integer.valueOf(args.get(11));
                    }
                    if (!bungeeBroadcast) {
                        if (!BungeeHandler.this.plugin.getBungeeSettings().isBungeeBroadcast() && !BungeeHandler.this.plugin.getBungeeSettings().isDisableBroadcast() && (wasOnline || BungeeHandler.this.plugin.getBungeeSettings().isBungeeBroadcastAlways())) {
                            if (BungeeHandler.this.plugin.getConfigFile().isFormatOnlyOneOfflineBroadcast() && !wasOnline) {
                                if (num == 1) {
                                    user.offlineBroadcast(user, BungeeHandler.this.plugin.getBungeeSettings().isUseBungeecoord(), numberOfVotes);
                                }
                            } else {
                                VoteSite site = BungeeHandler.this.plugin.getVoteSite(service, true);
                                if (site != null) {
                                    site.broadcastVote(user, false);
                                    broadcast = false;
                                } else {
                                    BungeeHandler.this.plugin.getLogger().warning("No votesite for " + service);
                                }
                            }
                        }
                    } else {
                        broadcast = false;
                    }
                    user.bungeeVotePluginMessaging(service, time, text, !setTotals, wasOnline, broadcast, num);
                    if (BungeeHandler.this.plugin.getBungeeSettings().isPerServerPoints()) {
                        user.addPoints(BungeeHandler.this.plugin.getConfigFile().getPointsOnVote());
                    }
                    BungeeHandler.this.plugin.getSpecialRewards().bungeeAllSitesCheck(user, numberOfVotes, num);
                    if (Boolean.valueOf(args.get(5)).booleanValue()) {
                        BungeeHandler.this.plugin.getServerData().addServiceSite(service);
                    }
                } else {
                    BungeeHandler.this.plugin.getLogger().warning("Incompatible version with bungee, please update all servers");
                }
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("VoteOnline"){

            @Override
            public void onReceive(ArrayList<String> args) {
                if (args.size() > 8) {
                    int bungeeVersion = Integer.parseInt(args.get(8));
                    if (bungeeVersion != BungeeVersion.getPluginMessageVersion()) {
                        BungeeHandler.this.plugin.getLogger().warning("Incompatible version with bungee, please update all servers");
                        return;
                    }
                    String player = args.get(0);
                    String uuid = args.get(1);
                    String service = args.get(2);
                    long time = Long.parseLong(args.get(3));
                    BungeeMessageData text = new BungeeMessageData(args.get(6));
                    BungeeHandler.this.bungeeVotePartyCurrent = text.getVotePartyCurrent();
                    BungeeHandler.this.bungeeVotePartyRequired = text.getVotePartyRequired();
                    BungeeHandler.this.plugin.getPlaceholders().onBungeeVotePartyUpdate();
                    BungeeHandler.this.plugin.getServerData().setBungeeVotePartyCurrent(BungeeHandler.this.bungeeVotePartyCurrent);
                    BungeeHandler.this.plugin.getServerData().setBungeeVotePartyRequired(BungeeHandler.this.bungeeVotePartyRequired);
                    BungeeHandler.this.plugin.debug("pluginmessaging voteonline received from " + player + "/" + uuid + " on " + service);
                    VotingPluginUser user = BungeeHandler.this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), player);
                    user.cache();
                    boolean setTotals = Boolean.valueOf(args.get(7));
                    boolean wasOnline = Boolean.valueOf(args.get(4));
                    boolean broadcast = true;
                    boolean bungeeBroadcast = false;
                    if (args.size() > 9) {
                        bungeeBroadcast = Boolean.valueOf(args.get(9));
                    }
                    int num = 1;
                    if (args.size() > 10) {
                        num = Integer.valueOf(args.get(10));
                    }
                    int numberOfVotes = 1;
                    if (args.size() > 11) {
                        numberOfVotes = Integer.valueOf(args.get(11));
                    }
                    if (!bungeeBroadcast) {
                        if (!BungeeHandler.this.plugin.getBungeeSettings().isBungeeBroadcast() && !BungeeHandler.this.plugin.getBungeeSettings().isDisableBroadcast() && (wasOnline || BungeeHandler.this.plugin.getBungeeSettings().isBungeeBroadcastAlways())) {
                            if (BungeeHandler.this.plugin.getConfigFile().isFormatOnlyOneOfflineBroadcast() && !wasOnline) {
                                if (num == 1) {
                                    user.offlineBroadcast(user, BungeeHandler.this.plugin.getBungeeSettings().isUseBungeecoord(), numberOfVotes);
                                }
                            } else {
                                VoteSite site = BungeeHandler.this.plugin.getVoteSite(service, true);
                                if (site != null) {
                                    site.broadcastVote(user, false);
                                    broadcast = false;
                                } else {
                                    BungeeHandler.this.plugin.getLogger().warning("No votesite for " + service);
                                }
                            }
                        }
                    } else {
                        broadcast = false;
                    }
                    user.bungeeVotePluginMessaging(service, time, text, !setTotals, wasOnline, broadcast, num);
                    if (BungeeHandler.this.plugin.getBungeeSettings().isPerServerPoints()) {
                        user.addPoints(BungeeHandler.this.plugin.getConfigFile().getPointsOnVote());
                    }
                    BungeeHandler.this.plugin.getSpecialRewards().bungeeAllSitesCheck(user, numberOfVotes, num);
                    if (Boolean.valueOf(args.get(5)).booleanValue()) {
                        BungeeHandler.this.plugin.getServerData().addServiceSite(service);
                    }
                } else {
                    BungeeHandler.this.plugin.getLogger().warning("Incompatible version with bungee, please update all servers");
                }
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("VoteUpdate"){

            @Override
            public void onReceive(ArrayList<String> args) {
                String player = args.get(0);
                BungeeHandler.this.plugin.debug("pluginmessaging voteupdate received for " + player);
                VotingPluginUser user = BungeeHandler.this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(player));
                user.cache();
                user.offVote();
                if (args.size() > 2) {
                    BungeeHandler.this.bungeeVotePartyCurrent = Integer.parseInt(args.get(1));
                    BungeeHandler.this.bungeeVotePartyRequired = Integer.parseInt(args.get(2));
                    BungeeHandler.this.plugin.getServerData().setBungeeVotePartyCurrent(BungeeHandler.this.bungeeVotePartyCurrent);
                    BungeeHandler.this.plugin.getServerData().setBungeeVotePartyRequired(BungeeHandler.this.bungeeVotePartyRequired);
                }
                if (args.size() > 3 && BungeeHandler.this.plugin.getBungeeSettings().isPerServerMilestones()) {
                    BungeeMessageData text = new BungeeMessageData(args.get(3));
                    BungeeHandler.this.plugin.getSpecialRewards().checkMilestone(user, text, true);
                }
                if (args.size() > 5) {
                    String service = args.get(4);
                    String data = args.get(5);
                    if (MessageAPI.isLong(data)) {
                        long time = Long.valueOf(data);
                        if (time > 0L) {
                            user.setTime(BungeeHandler.this.plugin.getVoteSite(service, true), time);
                        } else if (BungeeHandler.this.plugin.getBungeeSettings().isBungeeDebug()) {
                            BungeeHandler.this.plugin.debug("Invalid last vote time received from bungee: " + time);
                        }
                    }
                }
                BungeeHandler.this.plugin.setUpdate(true);
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("BungeeTimeChange"){

            @Override
            public void onReceive(ArrayList<String> args) {
                BungeeHandler.this.checkGlobalData();
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("VoteBroadcast"){

            @Override
            public void onReceive(ArrayList<String> args) {
                if (args.size() > 2) {
                    String uuid = args.get(0);
                    String service = args.get(2);
                    VotingPluginUser user = BungeeHandler.this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), args.get(1));
                    VoteSite site = BungeeHandler.this.plugin.getVoteSite(service, true);
                    if (site != null) {
                        site.broadcastVote(user, false);
                    } else {
                        BungeeHandler.this.plugin.getLogger().warning("No votesite for " + service);
                    }
                }
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("VoteBroadcastOffline"){

            @Override
            public void onReceive(ArrayList<String> args) {
                if (args.size() > 2) {
                    String uuid = args.get(0);
                    String votes = args.get(2);
                    VotingPluginUser user = BungeeHandler.this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), args.get(1));
                    user.offlineBroadcast(user, false, Integer.parseInt(votes));
                }
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("Status"){

            @Override
            public void onReceive(ArrayList<String> args) {
                String server = args.get(0);
                this.sendMessage(BungeeHandler.this.globalMessageHandler, "statusokay", server);
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("ServerName"){

            @Override
            public void onReceive(ArrayList<String> args) {
                String server = args.get(0);
                if (!BungeeHandler.this.plugin.getOptions().getServer().equals(server)) {
                    BungeeHandler.this.plugin.getLogger().warning("Server name doesn't match in BungeeSettings.yml, should be " + server);
                }
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("VotePartyBungee"){

            @Override
            public void onReceive(ArrayList<String> args) {
                for (final String cmd : BungeeHandler.this.plugin.getBungeeSettings().getBungeeVotePartyGlobalCommands()) {
                    BungeeHandler.this.plugin.getBukkitScheduler().runTask((Plugin)BungeeHandler.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd);
                        }
                    });
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    new RewardBuilder((ConfigurationSection)BungeeHandler.this.plugin.getBungeeSettings().getData(), "BungeeVotePartyRewards").send(p);
                }
            }
        });
        this.globalMessageHandler.addListener(new GlobalMessageListener("VotePartyBroadcast"){

            @Override
            public void onReceive(ArrayList<String> args) {
                String broadcast = args.get(0);
                MiscUtils.getInstance().broadcast(broadcast);
            }
        });
        if (this.method.equals((Object)BungeeMethod.MYSQL)) {
            this.plugin.registerBungeeChannels(this.plugin.getBungeeSettings().getPluginMessagingChannel());
            try {
                this.backendMysqlMessenger = new BackendMessenger("VotingPlugin", this.plugin.getMysql().getMysql().getConnectionManager().getDataSource(), this.plugin.getOptions().getServer(), msg -> {
                    this.plugin.debug("Proxy sent: " + msg.payload);
                    String[] message = msg.payload.split(Pattern.quote("%l%"));
                    if (message.length > 0) {
                        ArrayList<String> list = new ArrayList<String>();
                        for (int i = 1; i < message.length; ++i) {
                            list.add(message[i]);
                        }
                        this.globalMessageHandler.onMessage(message[0], list);
                    }
                });
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (this.method.equals((Object)BungeeMethod.REDIS)) {
            this.redisHandler = new RedisHandler(this.plugin.getBungeeSettings().getRedisHost(), this.plugin.getBungeeSettings().getRedisPort(), this.plugin.getBungeeSettings().getRedisUsername(), this.plugin.getBungeeSettings().getRedisPassword()){

                @Override
                public void debug(String message) {
                    if (BungeeHandler.this.plugin.getBungeeSettings().isBungeeDebug()) {
                        BungeeHandler.this.plugin.debug(message);
                    }
                }

                @Override
                protected void onMessage(String channel, String[] message) {
                    if (BungeeHandler.this.plugin.getBungeeSettings().isBungeeDebug()) {
                        BungeeHandler.this.plugin.debug(channel + " " + ArrayUtils.makeStringList(ArrayUtils.convert(message)));
                    }
                    if (message.length > 0) {
                        ArrayList<String> list = new ArrayList<String>();
                        for (int i = 1; i < message.length; ++i) {
                            list.add(message[i]);
                        }
                        BungeeHandler.this.globalMessageHandler.onMessage(message[0], list);
                    }
                }
            };
            this.redisThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (BungeeHandler.this.plugin.isEnabled()) {
                        BungeeHandler.this.redisHandler.loadListener(new RedisListener(BungeeHandler.this.redisHandler, BungeeHandler.this.plugin.getBungeeSettings().getRedisPrefix() + "VotingPlugin_" + BungeeHandler.this.plugin.getBungeeSettings().getServer()));
                    }
                }
            });
            this.redisThread.start();
        } else if (this.method.equals((Object)BungeeMethod.PLUGINMESSAGING)) {
            this.plugin.registerBungeeChannels(this.plugin.getBungeeSettings().getPluginMessagingChannel());
            if (this.plugin.getBungeeSettings().isPluginMessageEncryption()) {
                this.encryptionHandler = new EncryptionHandler(this.plugin.getName(), new File(this.plugin.getDataFolder(), "secretkey.key"));
                this.plugin.getPluginMessaging().setEncryptionHandler(this.encryptionHandler);
            }
            this.plugin.getPluginMessaging().setDebug(this.plugin.getBungeeSettings().isBungeeDebug());
            this.plugin.getPluginMessaging().add(new PluginMessageHandler(){

                @Override
                public void onRecieve(String subChannel, ArrayList<String> args) {
                    BungeeHandler.this.globalMessageHandler.onMessage(subChannel, args);
                }
            });
        } else if (this.method.equals((Object)BungeeMethod.SOCKETS)) {
            this.encryptionHandler = new EncryptionHandler(this.plugin.getName(), new File(this.plugin.getDataFolder(), "secretkey.key"));
            this.clientHandler = new ClientHandler(this.plugin.getBungeeSettings().getBungeeServerHost(), this.plugin.getBungeeSettings().getBungeeServerPort(), this.encryptionHandler, this.plugin.getBungeeSettings().isBungeeDebug());
            this.socketHandler = new SocketHandler(this.plugin.getVersion(), this.plugin.getBungeeSettings().getSpigotServerHost(), this.plugin.getBungeeSettings().getSpigotServerPort(), this.encryptionHandler, this.plugin.getBungeeSettings().isBungeeDebug()){

                @Override
                public void log(String str) {
                    BungeeHandler.this.plugin.getLogger().info(str);
                }
            };
            this.socketHandler.add(new SocketReceiver(){

                @Override
                public void onReceive(String[] data) {
                    BungeeHandler.this.globalMessageHandler.onMessage(data[0], ArrayUtils.convertAndRemoveFirst(data));
                }
            });
        } else if (this.method.equals((Object)BungeeMethod.MQTT)) {
            try {
                String id = this.plugin.getBungeeSettings().getMqttClientID();
                if (id.isEmpty()) {
                    id = this.plugin.getOptions().getServer();
                }
                this.mqttHandler = new MqttHandler(new MqttServerComm(this.plugin.getBungeeSettings().getMqttClientID(), this.plugin.getBungeeSettings().getMqttBrokerURL(), this.plugin.getBungeeSettings().getMqttUsername(), this.plugin.getBungeeSettings().getMqttPassword()), 2);
                this.mqttHandler.subscribe(this.plugin.getBungeeSettings().getMqttPrefix() + "votingplugin/servers/" + this.plugin.getOptions().getServer(), new MqttHandler.MessageHandler(){

                    @Override
                    public void onMessage(String topic, String payload) {
                        String[] message = payload.split(":");
                        if (message.length > 0) {
                            BungeeHandler.this.globalMessageHandler.onMessage(message[0], ArrayUtils.convertAndRemoveFirst(message));
                        }
                    }
                });
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.bungeeVotePartyCurrent = this.plugin.getServerData().getBungeeVotePartyCurrent();
        this.bungeeVotePartyRequired = this.plugin.getServerData().getBungeeVotePartyRequired();
        if (this.plugin.getOptions().getServer().equalsIgnoreCase("pleaseset")) {
            this.plugin.getLogger().warning("Server name for bungee voting is not set, please set it");
        }
    }

    public void loadGlobalMysql() {
        if (this.plugin.getBungeeSettings().isGloblalDataEnabled()) {
            if (this.timer != null) {
                this.timer.shutdown();
                try {
                    this.timer.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.timer.shutdownNow();
            }
            this.timer = Executors.newScheduledThreadPool(1);
            this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    BungeeHandler.this.checkGlobalData();
                }
            }, 60L, 10L, TimeUnit.SECONDS);
            this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    BungeeHandler.this.globalDataHandler.setString(BungeeHandler.this.plugin.getBungeeSettings().getServer(), "LastOnline", "" + LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
                }
            }, 1L, 60L, TimeUnit.MINUTES);
            if (this.globalDataHandler != null) {
                this.globalDataHandler.getGlobalMysql().close();
            }
            this.globalDataHandler = this.plugin.getBungeeSettings().isGloblalDataUseMainMySQL() && this.plugin.getStorageType().equals((Object)UserStorage.MYSQL) ? new GlobalDataHandler(new GlobalMySQL("VotingPlugin_GlobalData", this.plugin.getMysql().getMysql()){

                @Override
                public void debugEx(Exception e) {
                    BungeeHandler.this.plugin.debug(e);
                }

                @Override
                public void debugLog(String text) {
                    BungeeHandler.this.plugin.debug(text);
                }

                @Override
                public void info(String text) {
                    BungeeHandler.this.plugin.getLogger().info(text);
                }

                @Override
                public void logSevere(String text) {
                    BungeeHandler.this.plugin.getLogger().severe(text);
                }

                @Override
                public void warning(String text) {
                    BungeeHandler.this.plugin.getLogger().warning(text);
                }
            }) : new GlobalDataHandler(new GlobalMySQL("VotingPlugin_GlobalData", new MysqlConfigSpigot(this.plugin.getBungeeSettings().getData().getConfigurationSection("GlobalData"))){

                @Override
                public void debugEx(Exception e) {
                    BungeeHandler.this.plugin.debug(e);
                }

                @Override
                public void debugLog(String text) {
                    BungeeHandler.this.plugin.debug(text);
                }

                @Override
                public void info(String text) {
                    BungeeHandler.this.plugin.getLogger().info(text);
                }

                @Override
                public void logSevere(String text) {
                    BungeeHandler.this.plugin.getLogger().severe(text);
                }

                @Override
                public void warning(String text) {
                    BungeeHandler.this.plugin.getLogger().warning(text);
                }
            });
            this.globalDataHandler.getGlobalMysql().alterColumnType("IgnoreTime", "VARCHAR(5)");
            this.globalDataHandler.getGlobalMysql().alterColumnType("MONTH", "VARCHAR(5)");
            this.globalDataHandler.getGlobalMysql().alterColumnType("WEEK", "VARCHAR(5)");
            this.globalDataHandler.getGlobalMysql().alterColumnType("DAY", "VARCHAR(5)");
            this.globalDataHandler.getGlobalMysql().alterColumnType("FinishedProcessing", "VARCHAR(5)");
            this.globalDataHandler.getGlobalMysql().alterColumnType("Processing", "VARCHAR(5)");
            this.globalDataHandler.getGlobalMysql().alterColumnType("LastUpdated", "MEDIUMTEXT");
            this.globalDataHandler.getGlobalMysql().alterColumnType("ForceUpdate", "VARCHAR(5)");
            this.plugin.getTimeChecker().setProcessingEnabled(false);
        }
    }

    public void sendData(String ... strings) {
        this.clientHandler.sendMessage(strings);
    }

    @Generated
    public ClientHandler getClientHandler() {
        return this.clientHandler;
    }

    @Generated
    public BungeeMethod getMethod() {
        return this.method;
    }

    @Generated
    public int getBungeeVotePartyCurrent() {
        return this.bungeeVotePartyCurrent;
    }

    @Generated
    public int getBungeeVotePartyRequired() {
        return this.bungeeVotePartyRequired;
    }

    @Generated
    public SocketHandler getSocketHandler() {
        return this.socketHandler;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public RedisHandler getRedisHandler() {
        return this.redisHandler;
    }

    @Generated
    public GlobalMessageHandler getGlobalMessageHandler() {
        return this.globalMessageHandler;
    }

    @Generated
    public BackendMessenger getBackendMysqlMessenger() {
        return this.backendMysqlMessenger;
    }

    @Generated
    public MqttHandler getMqttHandler() {
        return this.mqttHandler;
    }
}

