/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.log.runtime;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.log.runtime.Frame;
import org.skriptlang.skript.log.runtime.RuntimeError;
import org.skriptlang.skript.log.runtime.RuntimeErrorConsumer;

public class RuntimeErrorManager
implements Closeable {
    private static RuntimeErrorManager instance;
    private final Frame errorFrame;
    private final Frame warningFrame;
    private final Task task;
    private final List<RuntimeErrorConsumer> consumers = new ArrayList<RuntimeErrorConsumer>();

    @ApiStatus.Internal
    public static RuntimeErrorManager getInstance() {
        return instance;
    }

    public static void refresh() {
        long frameLength = SkriptConfig.runtimeErrorFrameDuration.value().getAs(Timespan.TimePeriod.TICK);
        int errorLimit = SkriptConfig.runtimeErrorLimitTotal.value();
        int errorLineLimit = SkriptConfig.runtimeErrorLimitLine.value();
        int errorLineTimeout = SkriptConfig.runtimeErrorLimitLineTimeout.value();
        int errorTimeoutLength = Math.max(SkriptConfig.runtimeErrorTimeoutDuration.value(), 1);
        Frame.FrameLimit errorFrame = new Frame.FrameLimit(errorLimit, errorLineLimit, errorLineTimeout, errorTimeoutLength);
        int warningLimit = SkriptConfig.runtimeWarningLimitTotal.value();
        int warningLineLimit = SkriptConfig.runtimeWarningLimitLine.value();
        int warningLineTimeout = SkriptConfig.runtimeWarningLimitLineTimeout.value();
        int warningTimeoutLength = Math.max(SkriptConfig.runtimeWarningTimeoutDuration.value(), 1);
        Frame.FrameLimit warningFrame = new Frame.FrameLimit(warningLimit, warningLineLimit, warningLineTimeout, warningTimeoutLength);
        List<Object> oldConsumers = List.of();
        if (instance != null) {
            instance.close();
            oldConsumers = RuntimeErrorManager.instance.consumers;
        }
        instance = new RuntimeErrorManager(Math.max((int)frameLength, 1), errorFrame, warningFrame);
        oldConsumers.forEach(consumer -> instance.addConsumer((RuntimeErrorConsumer)consumer));
    }

    public RuntimeErrorManager(int frameLength, Frame.FrameLimit errorLimits, Frame.FrameLimit warningLimits) {
        this.errorFrame = new Frame(errorLimits);
        this.warningFrame = new Frame(warningLimits);
        this.task = new Task((Plugin)Skript.getInstance(), frameLength, frameLength, true){

            @Override
            public void run() {
                RuntimeErrorManager.this.consumers.forEach(consumer -> consumer.printFrameOutput(RuntimeErrorManager.this.errorFrame.getFrameOutput(), Level.SEVERE));
                RuntimeErrorManager.this.errorFrame.nextFrame();
                RuntimeErrorManager.this.consumers.forEach(consumer -> consumer.printFrameOutput(RuntimeErrorManager.this.warningFrame.getFrameOutput(), Level.WARNING));
                RuntimeErrorManager.this.warningFrame.nextFrame();
            }
        };
    }

    public void error(@NotNull RuntimeError error) {
        if (error.level() == Level.SEVERE && this.errorFrame.add(error) || error.level() == Level.WARNING && this.warningFrame.add(error)) {
            this.consumers.forEach(consumer -> consumer.printError(error));
        }
    }

    public Frame getErrorFrame() {
        return this.errorFrame;
    }

    public Frame getWarningFrame() {
        return this.warningFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(RuntimeErrorConsumer consumer) {
        List<RuntimeErrorConsumer> list = this.consumers;
        synchronized (list) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumers(RuntimeErrorConsumer ... newConsumers) {
        List<RuntimeErrorConsumer> list = this.consumers;
        synchronized (list) {
            this.consumers.addAll(Arrays.asList(newConsumers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConsumer(RuntimeErrorConsumer consumer) {
        List<RuntimeErrorConsumer> list = this.consumers;
        synchronized (list) {
            return this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RuntimeErrorConsumer> removeAllConsumers() {
        List<RuntimeErrorConsumer> list = this.consumers;
        synchronized (list) {
            List<RuntimeErrorConsumer> currentConsumers = List.copyOf(this.consumers);
            this.consumers.clear();
            return currentConsumers;
        }
    }

    @Override
    public void close() {
        this.task.close();
    }
}

