/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.loottables.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.loot.LootContext;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.bukkit.loottables.LootContextCreateEvent;
import org.skriptlang.skript.bukkit.loottables.LootContextWrapper;

@Name(value="Luck of Loot Context")
@Description(value={"Returns the luck of a loot context as a float. This represents the luck potion effect that an entity can have."})
@Examples(value={"set {_luck} to loot luck value of {_context}", "", "set {_context} to a loot context at player:", "\tset loot luck value to 10", "\tset looter to player", "\tset looted entity to last spawned pig"})
@Since(value={"2.10"})
public class ExprLootContextLuck
extends SimplePropertyExpression<LootContext, Float> {
    @Override
    @Nullable
    public Float convert(LootContext context) {
        return Float.valueOf(context.getLuck());
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)LootContextCreateEvent.class)) {
            Skript.error("You cannot set the loot context luck of an existing loot context.");
            return null;
        }
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> CollectionUtils.array(Float.class);
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (!(event instanceof LootContextCreateEvent)) {
            return;
        }
        LootContextCreateEvent createEvent = (LootContextCreateEvent)event;
        LootContextWrapper wrapper = createEvent.getContextWrapper();
        float luck = delta != null ? ((Float)delta[0]).floatValue() : 0.0f;
        switch (mode) {
            case SET: 
            case DELETE: 
            case RESET: {
                wrapper.setLuck(luck);
                break;
            }
            case ADD: {
                wrapper.setLuck(wrapper.getLuck() + luck);
                break;
            }
            case REMOVE: {
                wrapper.setLuck(wrapper.getLuck() - luck);
            }
        }
    }

    @Override
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Override
    protected String getPropertyName() {
        return "loot luck factor";
    }

    static {
        ExprLootContextLuck.registerDefault(ExprLootContextLuck.class, Float.class, "loot[ing] [context] luck [value|factor]", "lootcontexts");
    }
}

