/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.damagesource.elements;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;
import org.bukkit.damage.DamageSource;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.bukkit.damagesource.DamageSourceExperimentSyntax;

@Name(value="Damage Source - Source Location")
@Description(value={"The final location where the damage was originated from.", "The 'source location' for vanilla damage sources will retrieve the 'damage location' if set. If 'damage location' is not set, will attempt to grab the location of the 'causing entity', otherwise, null."})
@Example(value="on death:\n\tset {_location} to the source location of event-damage source\n")
@Since(value={"2.12"})
@RequiredPlugins(value={"Minecraft 1.20.4+"})
public class ExprSourceLocation
extends SimplePropertyExpression<DamageSource, Location>
implements DamageSourceExperimentSyntax {
    @Override
    @Nullable
    public Location convert(DamageSource damageSource) {
        return damageSource.getSourceLocation();
    }

    @Override
    public Class<Location> getReturnType() {
        return Location.class;
    }

    @Override
    protected String getPropertyName() {
        return "source location";
    }

    static {
        ExprSourceLocation.registerDefault(ExprSourceLocation.class, Location.class, "source location", "damagesources");
    }
}

