/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.visual;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.util.ContextlessEvent;
import ch.njol.skript.util.visual.ParticleOption;
import ch.njol.skript.util.visual.VisualEffectType;
import ch.njol.skript.util.visual.VisualEffects;
import ch.njol.util.Kleenean;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisualEffect
implements SyntaxElement,
YggdrasilSerializable {
    private VisualEffectType type;
    @Nullable
    private Object data;
    private float speed = 0.0f;
    private float dX;
    private float dY;
    private float dZ = 0.0f;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = VisualEffects.get(matchedPattern);
        if (exprs.length > 4) {
            int exprCount = exprs.length - 4;
            ContextlessEvent event = ContextlessEvent.get();
            if (exprCount == 1) {
                this.data = exprs[0] != null ? exprs[0].getSingle(event) : null;
            } else {
                Object[] dataArray = new Object[exprCount];
                for (int i = 0; i < exprCount; ++i) {
                    dataArray[i] = exprs[i] != null ? exprs[i].getSingle(event) : null;
                }
                this.data = dataArray;
            }
        }
        if (parseResult.hasTag("barrierbm")) {
            this.data = Bukkit.createBlockData((Material)Material.BARRIER);
        } else if (parseResult.hasTag("lightbm")) {
            this.data = Bukkit.createBlockData((Material)Material.LIGHT);
        }
        if ((parseResult.mark & 1) != 0) {
            this.dX = ((Number)exprs[exprs.length - 4].getSingle(null)).floatValue();
            this.dY = ((Number)exprs[exprs.length - 3].getSingle(null)).floatValue();
            this.dZ = ((Number)exprs[exprs.length - 2].getSingle(null)).floatValue();
        }
        if ((parseResult.mark & 2) != 0) {
            this.speed = ((Number)exprs[exprs.length - 1].getSingle(null)).floatValue();
        }
        return true;
    }

    public void play(@Nullable Player[] ps, Location l, @Nullable Entity e, int count, int radius) {
        assert (e == null || l.equals((Object)e.getLocation()));
        if (this.type.isEffect()) {
            Effect effect = this.type.getEffect();
            Object data = this.type.getData(this.data, l);
            if (ps == null) {
                l.getWorld().playEffect(l, effect, data, radius);
            } else {
                for (Player p : ps) {
                    p.playEffect(l, effect, data);
                }
            }
        } else if (this.type.isEntityEffect()) {
            if (e != null) {
                e.playEffect(this.type.getEntityEffect());
            }
        } else if (this.type.isParticle()) {
            int loopCount;
            Particle particle = this.type.getParticle();
            Object data = this.type.getData(this.data, l);
            if (data != null && !particle.getDataType().isAssignableFrom(data.getClass()) && !(data instanceof ParticleOption)) {
                data = null;
                if (Skript.debug()) {
                    Skript.warning("Incompatible particle data, resetting it!");
                }
            }
            if (this.type.isColorable() && data instanceof ParticleOption) {
                ParticleOption option = (ParticleOption)data;
                this.dX = option.getRed();
                this.dY = option.getGreen();
                this.dZ = option.getBlue();
                this.speed = 1.0f;
                data = null;
            }
            int n = loopCount = count == 0 ? 1 : count;
            if (ps == null) {
                if (this.type.isColorable()) {
                    for (int i = 0; i < loopCount; ++i) {
                        l.getWorld().spawnParticle(particle, l, 0, (double)this.dX, (double)this.dY, (double)this.dZ, (double)this.speed, data);
                    }
                } else {
                    l.getWorld().spawnParticle(particle, l, count, (double)this.dX, (double)this.dY, (double)this.dZ, (double)this.speed, data);
                }
            } else {
                for (Player p : ps) {
                    if (this.type.isColorable()) {
                        for (int i = 0; i < loopCount; ++i) {
                            p.spawnParticle(particle, l, 0, (double)this.dX, (double)this.dY, (double)this.dZ, (double)this.speed, data);
                        }
                        continue;
                    }
                    p.spawnParticle(particle, l, count, (double)this.dX, (double)this.dY, (double)this.dZ, (double)this.speed, data);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public VisualEffectType getType() {
        return this.type;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int flags) {
        return this.type.getName().toString(flags);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisualEffect that = (VisualEffect)o;
        return this.type == that.type && Objects.equals(this.data, that.data);
    }

    @Override
    @NotNull
    public String getSyntaxTypeName() {
        return "visual effect";
    }
}

