/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.skriptlang.skript.lang.converter.Converter;

public abstract class FileUtils {
    private static final SimpleDateFormat backupFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBackupSuffix() {
        SimpleDateFormat simpleDateFormat = backupFormat;
        synchronized (simpleDateFormat) {
            return backupFormat.format(System.currentTimeMillis());
        }
    }

    public static void backupPurge(File varFile, int toKeep) throws IOException, IllegalArgumentException {
        if (toKeep < 0) {
            throw new IllegalArgumentException("Called with invalid input, 'toKeep' can not be less than 0");
        }
        File backupDir = new File(varFile.getParentFile(), "backups" + File.separator);
        if (!backupDir.exists() || !backupDir.isDirectory()) {
            throw new IOException("Backup directory not found");
        }
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(backupDir.listFiles()));
        if (files == null || files.size() <= toKeep) {
            return;
        }
        if (toKeep > 0) {
            files.sort(Comparator.comparingLong(File::lastModified));
        }
        int numberToRemove = files.size() - toKeep;
        for (int i = 0; i < numberToRemove; ++i) {
            files.get(i).delete();
        }
    }

    public static File backup(File f) throws IOException {
        File backupFolder;
        String ext;
        String name = f.getName();
        int c = name.lastIndexOf(46);
        String string = ext = c == -1 ? null : name.substring(c + 1);
        if (c != -1) {
            name = name.substring(0, c);
        }
        if (!(backupFolder = new File(f.getParentFile(), "backups" + File.separator)).exists() && !backupFolder.mkdirs()) {
            throw new IOException("Cannot create backups folder");
        }
        File backup = new File(backupFolder, name + "_" + FileUtils.getBackupSuffix() + (String)(ext == null ? "" : "." + ext));
        if (backup.exists()) {
            throw new IOException("Backup file " + backup.getName() + " does already exist");
        }
        FileUtils.copy(f, backup);
        return backup;
    }

    public static File move(File from, File to, boolean replace) throws IOException {
        if (!replace && to.exists()) {
            throw new IOException("Can't rename " + from.getName() + " to " + to.getName() + ": The target file already exists");
        }
        if (replace) {
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        } else {
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        return to;
    }

    public static void copy(File from, File to) throws IOException {
        Files.copy(from.toPath(), to.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static Collection<File> renameAll(File directory, Converter<String, String> renamer) throws IOException {
        ArrayList<File> changed = new ArrayList<File>();
        for (File f : directory.listFiles()) {
            String newName;
            if (f.isDirectory()) {
                changed.addAll(FileUtils.renameAll(f, renamer));
                continue;
            }
            String name = f.getName();
            if (name == null || (newName = renamer.convert(name)) == null) continue;
            File newFile = new File(f.getParent(), newName);
            FileUtils.move(f, newFile, false);
            changed.add(newFile);
        }
        return changed;
    }

    public static void save(InputStream in, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[16384];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
        }
    }
}

