/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.test.platform;

import ch.njol.skript.test.platform.Environment;
import ch.njol.skript.test.utils.TestResults;
import ch.njol.util.NonNullPair;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PlatformMain {
    public static void main(String ... args) throws IOException, InterruptedException {
        HashSet jvmArgs;
        System.out.println("Initializing Skript test platform...");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path runnerRoot = Paths.get(args[0], new String[0]);
        assert (runnerRoot != null);
        Path testsRoot = Paths.get(args[1], new String[0]).toAbsolutePath();
        assert (testsRoot != null);
        Path dataRoot = Paths.get(args[2], new String[0]);
        assert (dataRoot != null);
        Path envsRoot = Paths.get(args[3], new String[0]);
        assert (envsRoot != null);
        boolean devMode = "true".equals(args[4]);
        boolean genDocs = "true".equals(args[5]);
        boolean jUnit = "true".equals(args[6]);
        boolean debug = "true".equals(args[7]);
        String verbosity = args[8].toUpperCase(Locale.ENGLISH);
        long timeout = Long.parseLong(args[9]);
        if (timeout < 0L) {
            timeout = 0L;
        }
        if ((jvmArgs = Sets.newHashSet((Object[])Arrays.copyOfRange(args, 10, args.length))).stream().noneMatch(arg -> arg.contains("-Xmx"))) {
            jvmArgs.add("-Xmx5G");
        }
        List<Environment> envs = Files.isDirectory(envsRoot, new LinkOption[0]) ? Files.walk(envsRoot, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> {
            try {
                return (Environment)gson.fromJson(new String(Files.readAllBytes(path), StandardCharsets.UTF_8), Environment.class);
            }
            catch (JsonSyntaxException | IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()) : Collections.singletonList((Environment)gson.fromJson(new String(Files.readAllBytes(envsRoot), StandardCharsets.UTF_8), Environment.class));
        System.out.println("Test environments: " + String.join((CharSequence)", ", envs.stream().map(Environment::getName).collect(Collectors.toList())));
        HashSet<String> allTests = new HashSet<String>();
        HashMap<String, List> failures = new HashMap<String, List>();
        boolean docsFailed = false;
        envs.sort(Comparator.comparing(Environment::getName));
        for (Environment env : envs) {
            System.out.println("Starting testing on " + env.getName());
            env.initialize(dataRoot, runnerRoot, false);
            TestResults results = env.runTests(runnerRoot, testsRoot, devMode, genDocs, jUnit, debug, verbosity, timeout, jvmArgs);
            if (results == null) {
                if (devMode) {
                    System.exit(0);
                    return;
                }
                System.err.println("The test environment '" + env.getName() + "' failed to produce test results.");
                System.exit(3);
                return;
            }
            docsFailed = results.docsFailed();
            allTests.addAll(results.getSucceeded());
            allTests.addAll(results.getFailed().keySet());
            for (Map.Entry<String, String> fail : results.getFailed().entrySet()) {
                String error = fail.getValue();
                assert (error != null);
                failures.computeIfAbsent(fail.getKey(), k -> new ArrayList()).add(new NonNullPair<Environment, String>(env, error));
            }
        }
        if (docsFailed) {
            System.err.println("Documentation templates not found. Cannot generate docs!");
            System.exit(2);
            return;
        }
        if (genDocs) {
            System.exit(0);
            return;
        }
        List succeeded = allTests.stream().filter(name -> !failures.containsKey(name)).collect(Collectors.toList());
        Collections.sort(succeeded);
        ArrayList failNames = new ArrayList(failures.keySet());
        Collections.sort(failNames);
        StringBuilder output = new StringBuilder(String.format("%s Results %s%n", StringUtils.repeat((String)"-", (int)25), StringUtils.repeat((String)"-", (int)25)));
        output.append("\nTested environments: " + String.join((CharSequence)", ", envs.stream().map(Environment::getName).collect(Collectors.toList())));
        output.append("\nSucceeded:\n  " + String.join((CharSequence)(jUnit ? "\n  " : ", "), succeeded));
        if (!failNames.isEmpty()) {
            output.append("\nFailed:");
            for (String failed : failNames) {
                List errors = (List)failures.get(failed);
                output.append("\n  " + failed + " (on " + errors.size() + " environment" + (errors.size() == 1 ? "" : "s") + ")");
                for (NonNullPair error : errors) {
                    output.append("\n    " + (String)error.getSecond() + " (on " + ((Environment)error.getFirst()).getName() + ")");
                }
            }
            output.append(String.format("%n%n%s", StringUtils.repeat((String)"-", (int)60)));
            System.err.print(output.toString());
            System.exit(failNames.size());
            return;
        }
        output.append(String.format("%n%n%s", StringUtils.repeat((String)"-", (int)60)));
        System.out.print(output.toString());
    }
}

