/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.structures;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import java.util.Locale;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.structure.Structure;

@NoDoc
public class StructEvent
extends Structure {
    private SkriptEvent event;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, @Nullable EntryContainer entryContainer) {
        String expr = parseResult.regexes.get(0).group();
        EventData data = this.getParser().getData(EventData.class);
        data.clear();
        if (parseResult.hasTag("uncancelled")) {
            data.behavior = SkriptEvent.ListeningBehavior.UNCANCELLED;
        } else if (parseResult.hasTag("cancelled")) {
            data.behavior = SkriptEvent.ListeningBehavior.CANCELLED;
        } else if (parseResult.hasTag("any")) {
            data.behavior = SkriptEvent.ListeningBehavior.ANY;
        }
        if (parseResult.hasTag("priority")) {
            String lastTag = parseResult.tags.get(parseResult.tags.size() - 1);
            data.priority = EventPriority.valueOf((String)lastTag.toUpperCase(Locale.ENGLISH));
        }
        assert (entryContainer != null);
        this.event = SkriptEvent.parse(expr, entryContainer.getSource(), null);
        data.clear();
        return this.event != null;
    }

    @Override
    public boolean preLoad() {
        this.getParser().setCurrentStructure(this.event);
        return this.event.preLoad();
    }

    @Override
    public boolean load() {
        this.getParser().setCurrentStructure(this.event);
        return this.event.load();
    }

    @Override
    public boolean postLoad() {
        this.getParser().setCurrentStructure(this.event);
        return this.event.postLoad();
    }

    @Override
    public void unload() {
        this.event.unload();
    }

    @Override
    public void postUnload() {
        this.event.postUnload();
    }

    @Override
    public Structure.Priority getPriority() {
        return this.event.getPriority();
    }

    public SkriptEvent getSkriptEvent() {
        return this.event;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.event.toString(event, debug);
    }

    static {
        Skript.registerStructure(StructEvent.class, "[on] [:uncancelled|:cancelled|any:(any|all)] <.+> [priority:with priority (:(lowest|low|normal|high|highest|monitor))]");
        ParserInstance.registerData(EventData.class, EventData::new);
    }

    public static class EventData
    extends ParserInstance.Data {
        @Nullable
        private EventPriority priority;
        @Nullable
        private SkriptEvent.ListeningBehavior behavior;

        public EventData(ParserInstance parserInstance) {
            super(parserInstance);
        }

        @Nullable
        public EventPriority getPriority() {
            return this.priority;
        }

        @Nullable
        public SkriptEvent.ListeningBehavior getListenerBehavior() {
            return this.behavior;
        }

        public void clear() {
            this.priority = null;
            this.behavior = null;
        }
    }
}

